;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a simple melody on an external MIDI synthesizer.

(in-package :common-music)

(in-syntax :musicKit)

(defscorefile (pathname "Midi-3")
  
  (with-part MidiPoly (name "aMidiPart1" midiChan 1 pitchBend 8192)
    (setf pitchBend (incf pitchBend 100))
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf keyNum (item (degrees d4 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d5 a4 c5 bf4 g e g bf a f d
				e g f g a
				d5 a4 c5 bf4 g e g bf a f d
				e g f e d)
		       :kill t)))

  (with-part MidiPoly (name "aMidiPart2" midiChan 2 pitchBend 8192)
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf keyNum (item (degrees d3 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d4 a3 c4 bf3 g e g bf a f d
				e g f g a
				d4 a3 c4 bf3 g e g bf a f d
				e g f e d)
		       :kill t)))

  (with-part MidiPoly (name "aMidiPart3" midiChan 3 pitchBend 8192)
    (setf pitchBend (incf pitchBend -100))
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf keyNum (item (degrees d2 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d3 a2 c3 bf2 g e g bf a f d
				e g f g a
				d3 a2 c3 bf2 g e g bf a f d
				e g f e d)
		       :kill t))))

