;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a simple melody on an external MIDI synthesizer.

(in-package :common-music)

(in-syntax :musicKit)


(defun change-midi-program (time name program)
  (format *common-music-output*
	  "~&t ~F;~&~A (mute) programChange:~D;~&" time name program))

(defscorefile (pathname "Midi-2")
  (with-part MidiPoly (name "aMidiPart" midiChan 1 programChange 0)
    (setf rhythm (item (rhythms e e e e e e 
				e e e e e e
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h.)))
    (setf keyNum (item (degrees d3 e f f f r 
			        e g f e d r
			        f e f r g r
			        a r
				d4 a3 c4 bf3 g e g bf a f d r
				e g f r g r a r
				d4 a3 c4 bf3 g e g bf a f d r
				e g f r e r d)
		       :kill t))
    (when-resting
      (change-midi-program time name (random 127)))))

