;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This is like Examp5, but a Mono part is used to allow for glissandi
;;; between notes and a greater ease of legato.  Also, the amplitude envelope
;;; is changed from time to time to give some variety of articulation.
;;; There a number of advantages to using Mono parts. In addition to the
;;; extra expression control they provide, Mono parts also prevent overlaps
;;; that needlessly sap your DSP resources.

(in-package :common-music)

(in-syntax :musicKit)

(defparameter *header* 
    (header "envelope legato   = [(0,0)(.2,1)|(.5,0.0)];"
	    "envelope marcato  = [(0,0)(.2,1)(.3,.1)|(.5,0.0)];"
	    "envelope freqFn  = [(0,.9)(.1,1)|(.2,.99)];"))

(defscorefile (pathname "Fm1vi-2" header *header*)
  (with-part Fm1viMono (name "clarinet"  ; Name of the part
			time 0           ; Part begins at time 0
			amp .1           ; Amplitude initialized to .1
			ampAtt .3        ; Amplitude envelope attack time
			ampRel .2        ; Amplitude envelope release time
			freqEnv "freqFn" ; Frequency envelope
			m1IndAtt .1      ; Modulator index attack time
			m1IndRel .1      ; Modulator index release time
			m1Ratio 2.001    ; Modulation ratio
			m1Ind1 1.3       ; Modulation index when envelope is 1
			m1Ind0 .1        ; Modulation index when envelope is 0
			sVibAmp .009     ; Percentage of sinusoidal vibrato
			sVibFreq 4       ; Speed of sinusoidal vibrato
			rVibAmp .005     ; Percentage of random vibrato
			bearing 0        ; Left-right panning.
			print-once '(amp ampAtt ampRel freqEnv m1IndAtt
				     m1IndRel m1Ratio m1Ind1 m1Ind0 sVibAmp
				     sVibFreq rVibAmp bearing))
    (setf freq (item (pitches d4 e f f f e g f e d f e f g a)
		     :kill t)   
          rhythm (item (rhythms e e e e q e e e e q e e q q h))
	  ;; We vary the envelope to add variety
	  ampEnv (item (items (items "legato" for 2) 
			      (items "marcato" for 2)
			      (items "legato" for 3)
			      "marcato"
			      (items "legato" for 2)
			      (items "marcato" for 2)
			      (items "legato" for 3)))
	  m1IndEnv ampEnv
	  ;; Portamento applies to the "arrival" note
	  portamento (if (= count 15) .5 .1))))



