;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a simple melody with the Fm1vi SynthPatch 
;;; in Poly mode. 

(in-package :common-music)

(in-syntax :musicKit)

;;; Music Kit envelopes and such are specified here. This text goes directly
;;; to the header of the scorefile. 

(defparameter *header* 
    (header "envelope ampFn   = [(0,0)(.2,1)(.3,.7)|(.35,0.0)];"
	    "envelope indFn   = [(0,0)(.1,1)(.2,.7)|(.3,.7)];"))

;;;
;;; Write score to file "Fm1vi-1.score".  The header to the score file will 
;;; be the value of the *header* variable.  Play score file after writing it.
;;;

(defscorefile (pathname "Fm1vi-1" header *header* after 'play)
  (with-part Fm1viPoly (name "clarinet"  ; Name of the part
			time 0           ; Part begins at time 0
			amp .1           ; Amplitude initialized to .1
			ampEnv "ampFn"   ; Envelope initialized to "ampFn"
			ampAtt .3        ; Amplitude envelope attack time
			ampRel .2        ; Amplitude envelope release time
			m1IndAtt .1      ; Modulator index attack time
			m1IndRel .1      ; Modulator index release time
			m1Ratio 2.001    ; Modulator portion of c:m ratio
			cRatio 1.0       ; Carrier portion of c:m ratio
			m1Ind1 1         ; Modulation index when envelope is 1
			m1Ind0 0         ; Modulation index when envelope is 0
			m1IndEnv "indFn" ; Modulation index envelope
			sVibAmp .009     ; Percentage of sinusoidal vibrato
			sVibFreq 4       ; Speed of sinusoidal vibrato
			rVibAmp .005     ; Percentage of random vibrato
			bearing 0        ; Left-right panning.
                        print-once '(amp ampEnv ampAtt ampRel m1IndAtt m1IndRel
				     m1Ratio cRatio m1Ind1 m1Ind0 m1IndEnv
				     sVibAmp sVibFreq rVibAmp bearing))
    (setf freq (item (pitches d4 e f f f e g f e d f e f g a)
		     :kill t)          
          rhythm (item (rhythms e e e e q e e e e q e e q q h))
	  duration (- rhythm .1))))      ; Release will cause slight overlaps
