;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example illustrates using the LISP loop macro to make a round
;;; See DBWave2vi-1.lisp and DBWave2vi-2.lisp for more comments.

(in-package :common-music)
(in-syntax :musicKit)

(defparameter *header* 
    (header "info tempo:42;"
	    "envelope smooth  = [(0,0)(.3 ,1.0)|(1.4,0.0)];"
	    "envelope ramp01 =  [(0,0)(.3,1)];"
	    "envelope ramp10 =  [(0,1)(.3,0)];"))

(defscorefile (pathname "DBWave2vi-3" header *header*)
  (loop with ampf = (interpolation 0 .1 5 .2)
        for part-name in '("bass" "tenor" "alto" "soprano1" "soprano2")
        for start-time in '(0 .5 1.0 1.5 1.5)
        for start-pitch in '(d2 f3 d4 g5 e5)
        for pitch-stream in (list (pitches d2 e f g a bf d3 e a bf a)
				    (pitches f3 e a g c4 d f g a)
				    (pitches d4 c e d f a bf a)
				    (pitches g5 a f e c d e a4)
				    (pitches e5 f d c a4 bf g a))
        for rhythm-stream in (list (rhythms e s e. e)
				   (rhythms q s e s)
				   (rhythms e. s e e)
				   (rhythms e s e e.)
				   (rhythms e s e e.))
        for waveform0-stream in (list (items "0BE" "BU" "0BU" "BE" "0BE" "BE")
				      (items "0TE" "TU" "0TU" "TE" "0TE" "TE")
				      (items "0SE" "SU" "0SU" "SE" "0SE" "SE")
				      (items "0SE" "SU" "0SU" "SE" "0SE" "SE")
				      (items "0SE" "SU" "0SU" "SE" "0SE" "SE"))
        for waveform1-stream in (list (items "BA" "0BA" "BO" "0BO" "BA" "0BA")
				      (items "TA" "0TA" "TO" "0TO" "TA" "0TA")
				      (items "SA" "0SA" "SO" "0SO" "SA" "0SA")
				      (items "SA" "0SA" "SO" "0SO" "SA" "0SA")
				      (items "SA" "0SA" "SO" "0SO" "SA" "0SA"))
        for amp-offset in '(0 0 0.1 0 0)
        for bearing-value in '(0 -45 45 -33 33)
        do

    ;;  establish new variable bindings each time through the loop

    (let ((start-time start-time) 
	  (start-pitch start-pitch)
	  (pitch-stream pitch-stream)
	  (rhythm-stream rhythm-stream)
	  (waveform1-stream waveform1-stream)
	  (waveform0-stream waveform0-stream)
	  (amp-offset amp-offset))
 
     (with-part DBWave2viMono (time start-time 
				ampEnv "smooth" 
				sVibAmp .01
				freqEnv "ramp01" 
				bearing bearing-value 
				rVibAmp .008 
				dont-optimize '(waveform1 waveform0)  
				freq start-pitch		           
				print-once '(ampEnv sVibAmp freqEnv bearing 
					     rVibAmp))
	(setf freq0 freq 
	      freq  (item pitch-stream :kill t)
	      rhythm (if (= count 1) 1.0 (item rhythm-stream))
	      waveformAtt rhythm
	      ampAtt (if (= count 1) 1.0 .3)
	      amp (+ amp-offset (function-value (- time start-time) ampf))
	      waveform0 (quotify (item waveform0-stream))
	      waveform1 (quotify (item waveform1-stream))
	      waveformEnv (item (items "ramp01" "ramp10"))
	      svibFreq (+ 4.5 (random 1.0))
	      freqAtt (/ rhythm 2.0))))))
