;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; In this example, we carefully interpolate between two wavetables to
;;; give perfectly smooth transitions. (Compare with DBWave1vi-1.lisp.)
;;; See the documentation on the NeXT Timbre Data Base for details.
;;; Notice the clever way we alternate between wave tables.  This insures 
;;; that no "bump" or "click" is heard when wavetables are changed, because
;;; we always change a wavetable when its amplitude is 0. 

(in-package :common-music)
(in-syntax :musicKit)


(defparameter *header*
    (header "envelope ampEnvelope = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];"
	    "envelope ramp01 =  [(0,0)(.3,1)];"
	    "envelope ramp10 =  [(0,1)(.3,0)];"))

(defscorefile (pathname "DBWave2vi-1" header *header*)
  (with-part DBWave2viMono (name "bass"
			    ampEnv "ampEnvelope" 
			    sVibAmp .01
			    freqEnv "ramp01" 
			    freqAtt .25
			    rvibAmp .008 
			    dont-optimize '(waveform1 waveform0)
			    print-once '(ampEnv sVibAmp freqEnv freqAtt 
					 rvibAmp)
			    freq 'd2)
    (setf freq0 freq 
	  freq (item (pitches d2 e f g a bf d3 e) :kill t)
	  rhythm (item (rhythms e s e. e))
	  waveformAtt rhythm
	  waveform0 (quotify (item (items "0BA" "BA")))
	  waveform1 (quotify (item (items "BA" "0BA")))
	  waveformEnv (item (items "ramp01" "ramp10"))
	  svibFreq (+ 4.5 (random 1.0)))))

