;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example illustrates a simple canonic melody using DBWave1vi 

(in-package :common-music)
(in-syntax :musicKit)


(defparameter *header* 
    (header "envelope marcato = [(0,0)(.1,1,2)(.2,.1)|(.3,0.0)];"
	    "envelope smooth   = [(0,0)(.1,1)|(.3,0.0)];"))

(defscorefile (pathname "DBWave1vi-3" header *header*)
  (loop with ampf = (interpolation 0 .1 5 .2 6 .2 10 .1)	
        and attf = (interpolation 0 .5 5 .05 10 .5)
        and relf = (interpolation 0 .1 5 1 10 .1)
        for part-name in '("part1" "part2" "part3")
        for timbre in '("SA" "SI" "SU")
        as i from 0
        do
    (let ((start-time i))
      (with-part DBWave1viPoly
	  (name part-name 
	   time start-time 
	   end (+ 10 start-time) 
	   duration .25 
	   sVibAmp .01 
	   bearing (- (* i 45) 45)
	   waveform (quotify timbre)
	   rVibAmp .006
	   print-once '(bearing waveform sVibAmp rVibAmp))
	(setf rhythm (item (items .5 .25 .75 .5))
	      freq (item (notes d4 e f g a bf d5 e))
	      ampEnv (if (> rhythm .3) "marcato" "smooth")
	      svibFreq (+ 4 (random 1.0)))
	(let ((x (- time start-time)))
	  (setf amp (function-value x ampf)
		ampAtt (function-value x attf)
		ampRel (function-value x relf)))))))

