;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package :common-music)
(in-syntax :musicKit)

(defparameter *header* 
    (header "envelope ampEnvelope = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];"
	    "envelope freqEnvelope = [(0,.98)(.2,1.0)|(.4,.99)];"))

;;; This example uses the NeXT Timbre Data Base in a monophonic context.
;;; Notice that the perceived timbre gets "munchkinized". Compare
;;; this to DBWave1vi-1.lisp where the perceived timbre remains relatively
;;; constant. The only difference is that we do not include the 
;;; DONT-OPTIMIZE initialization that was present in DBWave1vi-1. 

(defscorefile (pathname "DBWave1vi-2" header *header*)
  (write-line "Here comes the munchkin!")
  (with-part DBWave1viMono (ampEnv "ampEnvelope" 
			    sVibAmp .01
			    freqEnv "freqEnvelope" 
			    freqAtt .25
			    waveform1 (quotify "BA")
			    rvibAmp .008
			    freq 'd2
			    print-once '(ampEnv sVibAmp freqEnv freqAtt 
					 waveform1 rvibAmp))
    (setf freq0 freq 
	  freq  (item (pitches d2 e f g a bf d3 e) :kill t)
	  rhythm (item (rhythms e s e. e))
	  svibFreq (+ 4.5 (random 1.0)))))

