;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package :common-music)
(in-syntax :musicKit)

;;; This example uses the NeXT Timbre Data Base in a monophonic context.
;;;      Notice that the perceived timbre remains relatively constant,
;;;      despite the pitch changes. Compare this to DBWave1vi-2.lisp, where 
;;;      the same wave table is used on every note. 
;;;      Also compare this to DBWave2vi-1.lisp which uses true
;;;      DSP wavetable interpolation and thus avoids the little clicks that
;;;      appear in this example.

(defparameter *header*
    (header "envelope ampEnvelope = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];"
	    "envelope freqEnvelope   = [(0,.98)(.2,1.0)|(.4,.99)];"))

(defscorefile (pathname "DBWave1vi-1" header *header*)
  (with-part DBWave1viMono (name "bass"
			    ampEnv "ampEnvelope" 
			    sVibAmp .01
			    freqEnv "freqEnvelope" 
			    freqAtt .25

			    ;; the value of waveform1 must appear as a
			    ;; quoted string in the scorefile

			    waveform1 (quotify "BA") 
			    rvibAmp .008 

			    ;; Dont-optimize is a special Mono part
			    ;; initializer. It takes a list of  parameters
			    ;; to ALWAYS print, whether or not their value
			    ;; has changed. We need to ALWAYS print the
			    ;; waveform so the Music Kit Timbre Data 
			    ;; Base will select a new timbre on each note. 

			    dont-optimize '(waveform1)   
			    print-once '(ampEnv sVibAmp freqEnv freqAtt 
					 rvibAmp)
			    freq 'd2)
    (setf freq0 freq 
	  freq  (item (pitches d2 e f g a bf d3 e) :kill t)
	  rhythm (item (rhythms e s e. e))
	  svibFreq (+ 4.5 (random 1.0)))))