;;; -*- mode: lisp; syntax: common-lisp; package: common-music; base: 10 -*-

(in-package :common-music)

(in-syntax :csound)

;;;
;;; this example assumes than you have already compiled and loaded the part
;;; file cm/csound/examples/i1.fasl.  the after option is nil because this
;;; example doesnt have an orchestra file associated with it, so there's
;;; nothing to play...
;;;

(defscorefile (after nil)
  (with-part i1 (duration 1.0)
    (setf frequency (item (pitches a4 ef5 d3 in heap for 9) :kill t))
    (setf amplitude (item (items .1 .2 .3))))
  (dotimes (n 4)
    (let ((offset n))
      (with-part son-of-i1 (time offset events (+ 6 offset))
	(setf frequency (transpose (item (pitches c2 d e)) (* 12 offset)))
	(setf rhythm (item (rhythms q e h tempo 140))
	      duration rhythm)))))
	
         
      
