;;; -*- mode: lisp; syntax: common-lisp; package: common-music; base: 10 -*-

;;;
;;; this is an example of defining a csound score part and one subclass.
;;;

(in-package :common-music)

(defpart i1 (csound-part)
	 (name time duration frequency amplitude)
  ((duration :type float)        ; pcl ignores :type, but what the hell...
   (frequency :type float)
   (amplitude :type float)))

;;;
;;; son-of-i1 is a subclass of i1 that defaults its amplitude value to .1. 
;;;

(defpart son-of-i1 (i1)       
	()
  ((name :initform "i1")   		; default name should still be "i1"
   (amplitude :initform .1)))

