;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package :common-music)
(in-syntax :clm)

;(setf *random-state* '#s(RANDOM-STATE :SEED 8044293953500067025))
; after '(load :channels 2 :reverb nrev)

(defscorefile (after NIL)

  ;; slow counterpoint

  (loop with location = 90
   and stream = (rhythms w. w h. in random)
   for note in '(f2 c3 cs3 gs3 a3 e4 ef5 bf5 b5 fs6 g6 d7)
   for begin in '(32 32 32 24 16 8 0 0 0 0 0 0)
   for length in '(80 80 80 80 80 80 80 78 76 74 72 70) 
   for location first 0 then (if (= location 0) 90 0)
   do
    (with-part fm-violin (time begin
			  amplitude .05 
			  reverb-amount .06
			  end (+ begin length)
			  degree location
			  distance 10)
      (setf frequency (item (intervals (0 :max 1 :weight 2 :id 1)
			     (-2 :max 1 )
			     (1 :max 1)
			     in random from note
			     returning Pitch initially 1))
	    amplitude (function-value frequency 
				      '(110 4 440 1.5 1760 0.5)
				      .05))
      (let ((r (item stream)))
	(setf rhythm r duration (+ r 1))))))

