;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package ':common-music)

;;;
;;; score parts for bil's birds. instruments and functions in birdins.lisp
;;;

#|
(defscorefile (pathname "~/birds.clm" after 'load)   ; use to generate birds.
  (loop for bird in *birds*
   as time from 0 by 3
   do (make-score-event bird :time time)))
|#

(defvar *birds* '(western-meadowlark chipping-sparrow yellow-warbler 
		  orchard-oriole cassins-kingbird bobwhite
		  scissortailed-flycatcher greathorned-owl 
		  blackthroated-gray-warbler blacknecked-stilt
		  chestnutsided-warbler grasshopper-sparrow 
		  swamp-sparrow goldencrowned-sparrow indigo-bunting
		  hooded-warbler american-widgeon louisiana-waterthrush 
		  robin	robin2 solitary-vireo pigeon-hawk
		  cerulean-warbler nashville-warbler eastern-phoebe
		  painted-bunting western-flycatcher bachmans-sparrow
		  cedar-waxwing bairds-sparrow kentucky-warbler
		  rufoussided-towhee prothonotary-warbler
		  audubons-warbler lark-bunting eastern-bluebird
		  chuck-wills-widow bluegray-gnatcatcher
		  blackthroated-sparrow blackchinned-sparrow))

;;;
;;; basic class of bird part is used for both Bird and BigBird ins.
;;;

(defpart bird (clm-part)
 	 (name time dur frq skw amp frqf ampf &optional args)
  (dur
   frq
   skw
   amp
   frqf
   ampf
   (args :value-type :quoted))     ; list of partials (it use to be &rest...)
  :define-resource nil)

;;;
;;; most of the birds have variable parameter data. the default composer
;;; functions pop data from these slots and stuff them into their
;;; respective parameters.
;;;

(defclass bird-data-1 ()		
  ((rhys :accessor bird-rhys)
   (durs :accessor bird-durs)
   (frqs :accessor bird-frqs)
   (skws :accessor bird-skws)
   (amps :accessor bird-amps)
   (frqfs :accessor bird-frqfs)))

(defclass bird-data-2 (bird-data-1)
  ((ampfs :accessor bird-ampfs)))

(defun bird-song-1 (p)
  (setf (event-rhythm p) (pop (bird-rhys p))
	(event-dur p) (pop (bird-durs p))
	(event-frq p) (pop (bird-frqs p))
	(event-skw p) (pop (bird-skws p))
	(event-amp p) (pop (bird-amps p))
	(event-frqf p) (pop (bird-frqfs p))))
   
(defun bird-song-2 (p)
  (setf (event-rhythm p) (pop (bird-rhys p))
	(event-dur p) (pop (bird-durs p))
	(event-frq p) (pop (bird-frqs p))
	(event-skw p) (pop (bird-skws p))
	(event-amp p) (pop (bird-amps p))
	(event-frqf p) (pop (bird-frqfs p))
	(event-ampf p) (pop (bird-ampfs p))))

;;;
;;; the birds...
;;;

(defpart western-meadowlark (bird bird-data-1)
         ()
  ((events :initform 8)
   (name :initform 'Bigbird)
   (rhys :initform '(.3 .2 .35 .2 .15 .2 .1))
   (durs :initform '(.1 .15 .25 .15 .1 .1 .05 .1))
   (frqs :initform '(2010 3000 2000 3010 2200 3200 2000 1600))
   (skws :initform '(0 100 150 250 150 1400 200 0))
   (amps :initform '(.1 .11 .2 .11 .11 .11 .11 .11))
   (frqfs :initform '(No_Skw Down_Skw Down_Skw Down_Skw Down_Skw 
		      Fas_Down Fas_Down Fas_Down))
   (ampf :initform 'Bird_Amp)
   (args :initform '(2 1 1 2 .04))
   (composer :initform #'bird-song-1))
  :define-resource nil
  )

(defpart chipping-sparrow (bird)
         ()
  ((events :initform 17)
   (name :initform 'Bird)
   (rhythm :initform .06)
   (dur :initform .05)
   (frq :initform 4000)
   (skw :initform 2400)
   (amp :initform .2)
   (frqf :initform 'Chip_Up)
   (ampf :initform 'Bird_Amp))
  :define-resource nil)

(defpart yellow-warbler (bird bird-data-2)
         ()
  ((events :initform 9)
   (name :initform 'Bird)
   (rhys :initform '(.23 .22 .17 .23 .2 .1 .1 .15))
   (durs :initform '(.05 .12 .13 .16 .15 .075 .075 .075 .2))
   (frqs :initform '(5600 5000 5000 5000 5000 3700 3700 3700 3700))
   (skws :initform '(400 1500 1700 2000 2000 1000 800 800 2000))
   (amps :initform '(.05 .15 .17 .2 .2 .2 .15 .15 .2))
   (frqfs :initform '(Yellow_Up Yellow_Swirl Yellow_Swirl Yellow_Swirl
		      Yellow_Swirl Fas_Down Fas_Down Fas_Down Yellow_Last))
   (ampfs :initform '(Bird_Amp Swirl_Amp Swirl_Amp Swirl_Amp Swirl_Amp
		      Bird_Amp Bird_Amp Bird_Amp Swirl_Amp))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart orchard-oriole (bird bird-data-2)
         ()
  ((events :initform 16)
   (rhys :initform '(.03 .09 .15 .05 .3 .1 .2 .18 .17 .15 .1 .12 .28 .08 .12))
   (durs :initform '(.03 .05 .1 .03 .21 .05 .1 .1 .1 .03 .03 .07 .2 .02 .02 
		     .17))
   (frqs :initform '(3700 2500 2000 3900 2000 4200 2000 2000
		     2300 1800 2200 2500 2400 2200 2200 2000))
   (skws :initform '(100 1000 800 1200 1200 1000 1000 1000 3200
		     300 100 2000 2400 3000 3000 1000))
   (amps :initform '(.05 .1 .2 .1 .15 .1 .25 .25 .1 .05 .04 .15 .25 .04 .04 
		     .2))
   (frqfs :initform '(Fas_Down Fas_Up OriUpDwnA Fas_Down OriBigA
		      Fas_Down OriMid OriMid OriUpDwnB Fas_Up
		      Fas_Down OriUpDwnB OriDwnUp Fas_Up Fas_Up
		      OriUpDwnA))
   (ampfs :initform '(Bird_Amp Bird_Amp Bird_Amp Bird_Amp
		      Bird_Amp Bird_Amp Bird_Amp Bird_Amp OriAmp
		      Bird_Amp Bird_Amp OriAmp Bird_Amp Bird_Amp
		      Bird_Amp OriAmp))
   (names :accessor bird-names :initform '(Bird Bird Bigbird Bird Bigbird Bird
					   Bigbird Bigbird Bird Bird Bird Bird
					   Bigbird Bird Bird Bigbird))
   (argsn :accessor bird-argsn :initform '(() () (3 1 1 2 .02 3 .05) ()
					   (2 1 1 2 .05) () (2 1 1 2 .05)
					   (2 1 1 2 .05) () () () () 
					   (2 1 1 2 .04) () () (2 1 1 2 .04)))
   (composer :initform  #'(lambda (p)
			    (setf (event-name p) (pop (bird-names p))
				  (event-rhythm p) (pop (bird-rhys p))
				  (event-dur p) (pop (bird-durs p))
				  (event-frq p) (pop (bird-frqs p))
				  (event-skw p) (pop (bird-skws p))
				  (event-amp p) (pop (bird-amps p))
				  (event-frqf p) (pop (bird-frqfs p))
				  (event-ampf p) (pop (bird-ampfs p))
				  (event-args p) (pop (bird-argsn p))))))
  :define-resource nil)

(defpart cassins-kingbird (bird bird-data-1)
         ()
  ((events :initform 2)
   (name :initform 'Bigbird)
   (rhythm :initform .09)
   (durs :initform '(.04 .18))
   (frq :initform 1700)
   (skws :initform '(1200 900))
   (amps :initform '(.15 .25))
   (frqfs :initform '(KingFirst KingSecond))
   (ampf :initform 'Bird_Amp)
   (args :initform '(4 1 1 2 .5 3 0 4 .2))
   (composer :initform #'(lambda (p)
			   (setf (event-dur p) (pop (bird-durs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-amp p) (pop (bird-amps p))
				 (event-frqf p) (pop (bird-frqfs p))))))
  :define-resource nil)

(defpart BOBWHITE (bird)
         ()
  ((events :initform 2)
   (name :initform 'Bigbird)
   (rhythm :initform .6)
   (dur :initform .2)
   (frq :initform 1800)
   (skws :accessor bird-skws :initform '(200 1200))
   (amps :accessor bird-amps :initform '(.1 .2))
   (frqfs :accessor bird-frqfs :initform '(BobUp1 BobUp2))
   (ampf :initform 'Bird_Amp)
   (args :initform '(2 1 1 2 .02))
   (composer :initform #'(lambda (p)
			   (setf (event-skw p) (pop (bird-skws p))
				 (event-amp p) (pop (bird-amps p))
				 (event-frqf p) (pop (bird-frqfs p))))))  
  :define-resource nil)

(defpart scissortailed-flycatcher (bird)
         ()
  ((events :initform 1)
   (name :initform 'Bigbird)
   (rhythm :initform 0)
   (dur :initform .05)
   (frq :initform 1800)
   (skw :initform 1800)
   (amp :initform .2)
   (frqf :initform 'Scissor)
   (ampf :initform 'Bird_Amp)
   (args :initform '(5 1 .5 2 1 3 .5 4 .1 5 .01)))
  :define-resource nil)

(defpart greathorned-owl (bird bird-data-1)
         ()
  ((events :initform 4)
   (name :initform 'Bigbird)
   (rhys :initform '(.3 .85 .75))
   (durs :initform '(.1 .4 .35 .2))
   (frqs :initform '(300 293 293 300))
   (skws :initform '(0 6 7 0))
   (amp :initform .1)
   (frqfs :initform '(Bird_Amp Fas_Down OwlUp OwlUp))
   (ampf :initform 'Bird_Amp)
   (args :initform '(3 1 1 3 .02 7 .01))
   (composer :initform #'(lambda (p)
			   (setf (event-rhythm p) (pop (bird-rhys p))
				 (event-dur p) (pop (bird-durs p))
				 (event-frq p) (pop (bird-frqs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-frqf p) (pop (bird-frqfs p))))))
  :define-resource nil)

(defpart blackthroated-gray-warbler (bird bird-data-1)
         ()
  ((events :initform 11)
   (name :initform 'Bird)
   (rhys :initform '(.18 .1 .16 .1 .18 .1 .14 .24 .05 .05))
   (durs :initform '(.12 .08 .12 .08 .12 .08 .12 .2 .02 .02 .02))
   (frqs :initform '(3700 3000 3700 3000 3700 3000 3700 3000 4500 4200 4000))
   (skws :initform '(600 800 600 800 600 800 600 2000 500 800 900))
   (amps :initform '(.05 .07 .12 .15 .2 .25 .25 .2 .05 .05 .05))
   (frqfs :initform '(GrayOne GrayTwo GrayOne GrayTwo GrayOne GrayTwo GrayOne
		      GrayThree Fas_Up Fas_Up Fas_Up))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart blacknecked-stilt (bird)
         ()
  ((events :initform 3)
   (name :initform 'Bigbird)
   (rhythm :initform .3)
   (dur :initform .1)
   (frq :initform 900)
   (skws :accessor bird-skws :initform '(100 200 250))
   (amp :initform .2)
   (frqf :initform 'RampUp)
   (ampf :initform 'Swirl_Amp)
   (args :initform '(5 1 .5 2 1 3 .750 4 .5 5 .1))
   (composer :initform #'(lambda (p)
			   (setf (event-skw p) (pop (bird-skws p))))))
  :define-resource nil)

(defpart chestnutsided-warbler (bird bird-data-2)
         ()
  ((events :initform 13)
   (name :initform 'Bigbird)
   (rhys :initform '(.15 .05 .12 .08 .15 .07 .13 .06 .14	.15 .15 .15))
   (durs :initform '(.1 .03 .1 .03 .1 .03 .1 .03 .1 .12 .12 .12 .12))
   (frqs :initform '(4050 3900 4050 3800 4000 3800 4000 3800 4000 3800 3800 
		     2500 2500))
   (skws :initform '(1200 300 1200 500 1200 500 1200 500 1200 2200 2200 2200 
		     4000))
   (amps :initform '(.05 .075 .15 .1 .2 .15 .2 .15 .2 .15 .15 .25 .15))
   (frqfs :initform '(YCurve VCurve YCurve VCurve YCurve VCurve YCurve VCurve
		      YCurve WCurve WCurve UpCurve DownCurve))
   (ampfs :initform '(Bird_Amp Bird_Amp Swirl_Amp Bird_Amp Bird_Tap Bird_Amp
		      Bird_Tap Bird_Amp Bird_Tap Wamp Wamp Swirl_Amp Bird_Amp))
   (args :initform '(2 1 1 2 .1))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart grasshopper-sparrow (bird bird-data-1)
         ()
  ((events :initform 4)
   (name :initform 'Bird)
   (rhys :initform '(.11 .32 .08))
   (durs :initform '(.01 .01 .01 1.4))
   (frqs :initform '(8000 5700 3900 6000))
   (skws :initform '(100 300 100 2500))
   (amps :initform '(.1 .1 .1 .2))
   (frqfs :initform '(GrassTwo GrassTwo GrassTwo GrassOne))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart swamp-sparrow (bird bird-data-1)
         ()
  ((events :initform 30)
   (name :initform 'Bird)
   (rhys :initform '(.035 .045 .02 .035 .045 .02 .035 .045 .02 .035 .045 .02
		     .035 .045 .02 .035 .045 .02 .035 .045 .02 .035 .045 .02
		     .035 .045 .02 .035 .045))
   (durs :initform '(.02 .035 .025 .02 .035 .025 .02 .035 .025 .02 .035 .025
		     .02 .035 .025 .02 .035 .025 .02 .035 .025 .02 .035 .025
		     .02 .035 .025 .02 .035 .025))
   (frqs :initform '(3900 3200 3700 3900 3200 3700 3900 3200 3700 3900 3200 
		     3700 3900 3200 3700 3900 3200 3700 3900 3200 3700 3900 
		     3200 3700 3900 3200 3700 3900 3200 3700))
   (skws :initform '(200 3000 0 200 3000 0 200 3000 0 200 3000 0 200 3000 0 200
		     3000 0 200 3000 0 200 3000 0 200 3000 0 200 3000 0))
   (amps :initform '(.3 .1 .1 .3 .1 .1 .3 .1 .1 .3 .1 .1 .3 .1 .1 .3 .1 .1 .3 
		     .1 .1 .3 .1 .1 .3 .1 .1 .3 .1 .1))
   (frqfs :initform '(Swamp_Up Swamp_Down Bird_Amp Swamp_Up Swamp_Down 
		      Bird_Amp Swamp_Up Swamp_Down Bird_Amp Swamp_Up 
		      Swamp_Down Bird_Amp Swamp_Up Swamp_Down Bird_Amp 
		      Swamp_Up Swamp_Down Bird_Amp Swamp_Up Swamp_Down 
		      Bird_Amp Swamp_Up Swamp_Down Bird_Amp Swamp_Up 
		      Swamp_Down Bird_Amp Swamp_Up Swamp_Down Bird_Amp))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart goldencrowned-sparrow (bird bird-data-1)
         ()
  ((events :initform 4)
   (name :initform 'Bird)
   (rhys :initform '(.7 .45 .45))
   (durs :initform '(.5 .450 .4 .3))
   (frqs :initform '(4300 3300 3800 3800))
   (skws :initform '(1000 200 100 100))
   (amps :initform '(.15 .15 .15 .1))
   (frqfs :initform '(GoldOne GoldOne GoldTwo GoldTrill))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)


(defpart indigo-bunting (bird bird-data-1)
         ()
  ((events :initform 19)
   (name :initform 'Bird)
   (rhys :initform '(.12 .03 .19 .06 .2 .13 .12 .15 .1 .1 .12 .09 .13 .11 .15 
		     .13 .1 .08))
   (durs :initform '(.08 .02 .15 .02 .15 .1 .03 .08 .03 .07 .1 .05 .1 .07 .08 
		     .07 .08 .07 .08))
   (frqs :initform '(3000 6200 3500 6200 3400 3400 4100 3400 4100 3700 4100 
		     3700 4100 5200 3000 5200 3000 5200 3000))
   (skws :initform '(700 1000 2300 1800 2300 800 2000 800 2000 300 2200 300 
		     2200 1800 1500 1800 1500 1800 1500))
   (amps :initform '(.25 .05 .1 .05 .1 .2 .05 .2 .05 .1 .15 .1 .15 .2
		     .15 .2 .15 .1 .1))
   (frqfs :initform '(Fas_Down Fas_Down Fas_Mid BuntX Fas_Mid Fas_Mid Fas_Down
		      Fas_Mid Fas_Down Fas_Down BuntY Fas_Down BuntY BuntN 
		      Fas_Up BuntN Fas_Up BuntN Fas_Up))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart hooded-warbler (bird bird-data-1)
         ()
  ((events :initform 26)
   (name :initform 'Bird)
   (rhys :initform '(.04 .16 .04 .09 .04 .08 .04 .08 .04 .18 .04 .08 .04 .08 
		     .04 .08 .05 .1 .08 .07 .08 .08 .08 .08 .08))
   (durs :initform '(.03 .03 .03 .03 .03 .03 .03 .03 .03 .03 .03 .03 .03 .03 
		     .03 .03 .03 .03 .04 .04 .04 .04 .04 .04 .04 .04))
   (frqs :initform '(3900 3900 3900 3900 3900 3900 3900 3900 3900 3900 3900 
		     3900 3900 3900 3900 3900 3900 3900 3000 3000 3000 3000 
		     3000 3000 3000 3000))
   (skws :initform '(1600 1700 2000 2000 2100 2100 2100 2100 2100 2100 2100
		     2100 2100 2100 2100 2100 2100 2100 1000 1000 1000 1000
		     1000 1000 1000 1000))
   (amps :initform '(.05 .05 .1 .1 .15 .15 .05 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2
		     .2 .15 .15 .15 .15 .15 .15 .15 .15))
   (frqfs :initform '(Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down
		      Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down 
		      Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down Fas_Down 
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart american-widgeon (bird bird-data-1)
        ()
  ((events :initform 3)
   (name :initform 'Bigbird)
   (rhys :initform '(.1 .15))
   (durs :initform '(.07 .11 .07))
   (frqs :initform '(1900 1700 1900))
   (skws :initform '(300 1400 300))
   (amps :initform '(.15 .25 .15))
   (frqf :initform 'Fas_Mid)
   (ampf :initform 'Fas_Mid)
   (argsn :accessor bird-argsn :initform '((2 1 1 2 .02)(3 1 .7 2 1 3 .02)
					   (2 1 1 2 .02)))
   (composer :initform #'(lambda (p)
			   (setf (event-rhythm p) (pop (bird-rhys p))
				 (event-dur p) (pop (bird-durs p))
				 (event-frq p) (pop (bird-frqs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-amp p) (pop (bird-amps p))
				 (event-args p) (pop (bird-argsn p))))))
  :define-resource nil)

(defpart louisiana-waterthrush (bird bird-data-2)
         ()
  ((events :initform 9)
   (name :initform 'Bird)
   (rhys :initform '(.32 .32 .26 .35 .15 .18 .07 .05))
   (durs :initform '(.17 .18 .2 .2 .12 .1 .02 .02 .035))
   (frqs :initform '(4100 4050 4000 3900 3000 2700 5200 5200 3200))
   (skws :initform '(2000 2050 1900 2000 3000 1500 1000 1000 1000))
   (amps :initform '(.2 .3 .25 .3 .25 .2 .1 .1 .1))
   (frqfs :initform '(Water_One Water_One Water_One Water_Two UpCurve Fas_Up 
		      Fas_Down Fas_Down Fas_Up))
   (ampfs :initform '(Water_Amp Water_Amp Water_Amp Bird_Tap Swirl_Amp 
		      Swirl_Amp Bird_Amp Bird_Amp Swirl_Amp))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart robin (bird bird-data-1)
         ()
  ((events :initform 6)
   (name :initform 'Bigbird)
   (rhys :initform '(.11 .58 .49 .17 .51))
   (durs :initform '(.06 .1 .24 .13 .11 .21))
   (frqs :initform '(2000 2000 2000 1900 2200 1950))
   (skws :initform '(800 900 2000 1600 1200 2000))
   (amps :initform '(.15 .15 .25 .2 .25 .15))
   (frqfs :initform '(R_Six R_One R_two R_Three Fas_Down R_Five))
   (ampf :initform 'Bird_Amp)
   (args :initform '(2 1 1 2 .1))
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart robin2 (bird bird-data-2)
         ()
  ((events :initform 7)
   (name :initform 'Bigbird)
   (rhys :initform '(.17 .38 .1 .5 .6 .18))
   (durs :initform '(.15 .12 .1 .15 .3 .15 .12))
   (frqs :initform '(1800 2000 2000 1950 1900 1900 2000))
   (skws :initform '(600 600 500 400 1700 1000 600))
   (amps :initform '(.2 .2 .15 .15 .2 .2 .2))
   (frqfs :initform '(ROne RTwo RThree RThree RFour ROne RTwo))
   (ampfs :initform '(Bird_Amp Bird_Amp Bird_Amp Bird_Amp RFive Bird_Amp 
		      Bird_Amp))
   (args :initform '(2 1 1 2 .1))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart solitary-vireo (bird)
         ()
  ((events :initform 1)
   (name :initform 'Bird)
   (rhythm :initform 0)
   (dur :initform .4)
   (frq :initform 1800)
   (skw :initform 1200)
   (amp :initform .2)
   (frqf :initform 'BigSkew)
   (ampf :initform 'Bird_Amp))
  :define-resource nil)

(defpart pigeon-hawk (bird bird-data-1)
         ()
  ((events :initform 29)
   (name :initform 'Bigbird)
   (rhys :initform '(.12 .01 .12 .01 .12 .01 .12 .01 .12 .01 .12 .01 .12 .01 
		     .12 .01 .12 .01 .12 .01 .12 .01 .12 .01 .12 .01 .12 .01))
   (durs :initform '(.1 .01 .1 .01 .1 .01 .1 .01 .1 .01 .1 .01 .1 .01 .1 .01 
		     .1 .01 .1 .01 .1 .01 .1 .01 .1 .01 .1 .01 .1))
   (frqs :initform '(1900 2050 1900 2050 1900 2050 1900 2050 1900 2050 1900 
		     2050 1900 2050 1900 2050 1900 2050 1900 2050 1900 2050 
		     1900 2050 1900 2050 1900 2050 1900))
   (skws :initform '(200 0 200 0 200 0 200 0 200 0 200 0 200 0 200 0 200 0 
		     200 0 200 0 200 0 200 0 200 0 200))
   (amps :initform '(.2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2
		     .1 .2 .1 .2 .1 .2 .1 .2 .1 .2))
   (frqfs :initform '(hUpDown Bird_Amp hUpDown Bird_Amp hUpDown Bird_Amp 
		      hUpDown Bird_Amp hUpDown Bird_Amp hUpDown Bird_Amp 
		      hUpDown Bird_Amp hUpDown Bird_Amp hUpDown Bird_Amp 
		      hUpDown Bird_Amp hUpDown Bird_Amp hUpDown Bird_Amp 
		      hUpDown Bird_Amp hUpDown Bird_Amp hUpDown))
   (ampf :initform 'Bird_Amp)
   (args :initform '(2 1 .700 2 1))
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart cerulean-warbler (bird bird-data-1)
         ()
  ((events :initform 41)
   (name :initform 'Bird)
   (rhys :initform '(.06 .08 .01 .01 .08 .09 .12 .08 .12 .08 .01 .01 .01 .01
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01))
   (durs :initform '(.05 .05 .01 .01 .06 .06 .1 .05 .1 .05 .01 .01 .01 .01 
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01))
   (frqs :initform '(3000 3000 3200 3200 3200 3200 3000 3000 3000 3000 3900 
		     3910 3940 4000 3900 3900 3900 3900 3900 3900 3900 3900 
		     3900 3900 3900 3900 3900 3900 3900 3900 3900 3900 3900
		     3900 3900 3900 3900 3900 3900 3900 3900))
   (skws :initform '(1000 800 700 700 700 500 1200 800 1200 800 600 800 500 
		     500 1000 1000 1000 1000 1000 1000 1000 1000 1000 1000 
		     1000 1000 1000 1000 1000 1000 1000 1000 1000 1200 1200 
		     1200 1200 1400 1400 1400 1400))
   (amps :initform '(.05 .075 .07 .08 .09 .1 .2 .2 .2 .2 .1 .1 .1 .1 .1 .1 .1
		     .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 
		     .1 .1 .1 .1 .1))
   (frqfs :initform '(Fas_Down Fas_Up Fas_Down Fas_Down Fas_Down Fas_Up Trill
		      Fas_Up Trill Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up 
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up Fas_Up))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)


(defpart nashville-warbler (bird bird-data-2)
         ()
  ((events :initform 13)
   (name :initform 'Bird)
   (rhys :initform '(.09 .18 .13 .2 .06 .19 .11 .19 .1 .17 .13 .15))
   (durs :initform '(.025 .16 .025 .14 .03 .17 .02 .14 .03 .11 .1 .1 .075))
   (frqs :initform '(3900 4200 3900 4300 3950 4200 3800 4200 3750 4200 3800 
		     3800 3900))
   (skws :initform '(300 3800 300 3700 350 3900 400 3800 300 3700 2200 2150 
		     1800))
   (amps :initform '(.3 .15 .3 .15 .3 .175 .25 .165 .2 .1 .1 .125 .1))
   (frqfs :initform '(Nash_Blip Nash_Down Nash_Blip Nash_Down Nash_Blip
		      Nash_Down Nash_Blip Nash_Down Nash_Blip Nash_Down
		      Nash_Up Nash_Up Nash_Up))
   (ampfs :initform '(Bird_Amp Nash_Amp Bird_Amp Nash_Amp Bird_Amp Bird_Amp
		      Bird_Amp Nash_Amp Bird_Amp Bird_Amp Bird_Amp Bird_Amp
		      Nash_Amp))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart eastern-phoebe (bird bird-data-2)
         ()
  ((events :initform 4)
   (name :initform 'Bird)
   (rhys  :initform '(.35 .05 .15))
   (durs  :initform '(.225 .12 .1 .05))
   (frq :initform 3000)
   (skws  :initform '(1300 500 1500 1400))
   (amps  :initform '(.3 .1 .2 .2))
   (frqfs :initform '(Phoebe_One Fas_Mid Phoebe_Three Phoebe_Four))
   (ampfs :initform '(Bird_Amp OriAmp OriAmp OriAmp))
   (composer :initform #'(lambda (p)
			   (setf (event-rhythm p) (pop (bird-rhys p))
				 (event-dur p) (pop (bird-durs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-amp p) (pop (bird-amps p))
				 (event-frqf p) (pop (bird-frqfs p))
				 (event-ampf p) (pop (bird-ampfs p))))))
  :define-resource nil)

(defpart painted-bunting (bird bird-data-2)
         ()
  ((events :initform 13)
   (name :initform 'Bird)
   (rhys :initform '(.16 .15 .16 .16 .12 .16 .22 .12 .03 .03 .04 .07))
   (durs :initform '(.1 .07 .12 .08 .1 .12 .15 .1 .02 .02 .02 .03 .1))
   (frqs :initform '(3100 4100 3700 2300 4000 2300 3800 2300 3200 3200 3200 
		     4000 2300))
   (skws :initform '(900 700 1000 1600 1000 1700 2200 1600 1000 1000 1000 
		     2000 1700))
   (amps :initform '(.05 .15 .2 .15 .25 .2 .3 .15 .1 .1 .1 .12 .2))
   (frqfs :initform '(Fas_Up Fas_Down Fas_Mid B_Five Fas_Up B_seven B_Eight 
		      B_Ten Fas_Down Fas_Down Fas_Down B_Twelve B_Fourteen))
   (ampfs :initform '(Swirl_Amp Bird_Amp Bird_Amp B_six Bird_Tap Bird_Amp 
		      B_Nine Bird_Amp Bird_Amp Bird_Amp Bird_Amp B_Thirteen
		      B_Fifteen))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart western-flycatcher (bird)
	 ()
  ((events :initform 2)
   (name :initform 'Bigbird)
   (rhythm :initform .3)
   (dur :initform .2)
   (frq :initform 2000)
   (skws :accessor bird-skws :initform '(2200 1100))
   (amp :initform .2)
   (frqfs :accessor bird-frqfs :initform '(F_One F_Two))
   (ampfs :accessor bird-ampfs :initform '(A_One A_Two))
   (args :initform '(4 1 1 2 .02 3 .1 4 .01))
   (composer :initform #'(lambda (p)
			   (setf (event-skw p) (pop (bird-skws p))
				 (event-frqf p) (pop (bird-frqfs p))
				 (event-ampf p) (pop (bird-ampfs p))))))
  :define-resource nil)

(defpart bachmans-sparrow (bird bird-data-1)
         ()
  ((events :initform 38)
   (name :initform 'Bird)
   (rhys :initform '(.52 0 .02 .02 .02 .02 .02 .03 .08 .07 .08 .07 .08 .07 .08
		     .07 .08 .07 .08 .07 .08 1.17 .07 .03 .07 .03 .07 .03 .07 
		     .03 .07 .13 .2 .2 .2 .2 .2))
   (durs :initform '(.51 .015 .015 .015 .015 .015 .015 .015 .07 .03 .07 .03 
		     .07 .03 .07 .03 .07 .03 .07 .03 .07 .03 .06 .01 .06 .01 
		     .06 .01 .06 .01 .06 .01 .15 .15 .15 .15 .15 .15))
   (frqs :initform '(4900 3800 3750 3600 3500 3400 3200 3800 3000 5000 3000 
		     5000 3000 5000 3000 5000 3000 5000 3000 5000 3000 5000 
		     4000 5200 4000 5200 4000 5200 4000 5200 4000 5200 3000 
		     3000 3000 3000 3000 3000))
   (skws :initform '(200 200 250 300 250 200 200 100 750 1000 750 1000 750 
		     1000 750 1000 750 1000 750 1000 750 1000 1700 0 1700 0
		     1700 0 1700 0 1700 0 1000 1000 1000 1000 1000 1000))
   (amps :initform '(.3 .1 .1 .1 .1 .1 .1 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2
		     .1 .2 .1 .1 .2 .1 .2 .1 .2 .1 .2 .1 .2 .2 .2 .2 .2 .2 .2))
   (frqfs :initform '(SOpening Sup Sup Sup Sup Sup Sup Sup Sup SDwn Sup SDwn
		      Sup SDwn Sup SDwn Sup SDwn Sup SDwn Sup SDwn Fas_Up
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up SLast SLast SLast SLast SLast SLast))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart cedar-waxwing (bird)
         ()
  ((events :initform 1)
   (name :initform 'Bird)
   (rhythm :initform 0)
   (dur :initform .5)
   (frq :initform 6000)
   (skw :initform 800)
   (amp :initform .2)
   (frqf :initform 'Cedar)
   (ampf :initform 'CedAmp))
  :define-resource nil)

(defpart bairds-sparrow (bird bird-data-1)
         ()
  ((events :initform 39)
   (name :initform 'Bird)
   (rhys :initform '(.22 .03 .20 .05 .09 .01 .08 .07 .04 .04 .04 .04 .04 .04 
		     .04 .04 .04 .04 .04 .04 .04 .04 .04 .04 .04 .04 .04 .04
		     .04 .04 .04 .04 .04 .04 .04 .04 .05 .05))
   (durs :initform '(.09 .01 .09 .01 .08 .01 .01 .07 .01 .01 .01 .01 .01 .01 
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01))
   (frqs :initform '(6500 5900 6000 4200 4200 4400 4400 5400 4200 4400 4200 
		     4400 4200 4400 4200 4400 4200 4400 4200 4400 4200 4400 
		     4200 4400 4200 4400 4200 4400 4200 4400 4200 4400 4200 
		     4400 4200 4400 4200 4400 4200))
   (skws :initform '(1500 100 1000 100 600 100 100 700 100 100 100 100 100
		     100 100 100 100 100 100 100 100 100 100 100 100 100 100
		     100 100 100 100 100 100 100 100 100 100 100 100))
   (amps :initform '(.2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .19 .19 .18 .18 .17 .17 .16
		     .16 .15 .15 .14 .14 .13 .13 .12 .12 .11 .11 .1 .1 .09 .09
		     .08 .08 .07 .07 .06 .06 .05))
   (frqfs :initform '(BairdStart BairdEnd BairdStart BairdEnd BairdStart
		      BairdEnd BairdEnd BairdStart BairdEnd BairdEnd BairdEnd
		      BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd
		      BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd
		      BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd
		      BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd BairdEnd
		      BairdEnd BairdEnd BairdEnd BairdEnd))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart kentucky-warbler (bird bird-data-1)
         ()
  ((events :initform 25)
   (name :initform 'Bigbird)
   (rhys :initform '(.05 .08 .02 .07 .08 .08 .12 .07 .08 .08 .1 .07 .07 .07
		     .11 .06 .07 .09 .08 .07 .08 .1 .07 .08))
   (durs :initform '(.02 .03 .02 .05 .06 .06 .05 .05 .06 .06 .05 .05 .05 .06
		     .05 .05 .05 .06 .05 .05 .06 .05 .05 .06 .05))
   (frqs :initform '(3800 4300 3200 3000 3100 3200 4600 2900 3000 3100 4600
		     2800 2700 2800 4600 2700 2600 2600 4600 2700 2600 4600
		     2800 2700 4700))
   (skws :initform '(200 200 100 800 1200 1200 100 800 1200 1200 100 800 1200
		     1200 100 800 1200 1200 100 800 1200 100 800 1200 100))
   (amps :initform '(.05 .15 .1 .15 .1 .1 .2 .15 .1 .1 .2 .15 .1 .1 .2 .15 .1
		     .1 .2 .15 .1 .2 .15 .1 .25))
   (frqfs :initform '(KenStart Fas_Up KenDwn KenStart KenDwn KenDwn KenTrill
		      KenStart KenDwn KenDwn KenTrill KenStart KenDwn KenDwn
		      KenTrill KenStart KenDwn KenDwn KenTrill KenStart KenDwn
		      KenTrill KenStart KenDwn KenTrill))
   (ampf :initform 'Bird_Amp)
   (args :initform '(2 1 1 2 .03))
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart rufoussided-towhee (bird bird-data-1)
         ()
  ((events :initform 44)
   (names :accessor bird-names :initform '(Bigbird Bigbird Bigbird Bigbird
					   Bird Bird Bird Bird Bird Bird Bird
					   Bird Bird Bird Bird Bird Bird Bird
					   Bird Bird Bird Bird Bird Bird Bird
					   Bird Bird Bird Bird Bird Bird Bird
					   Bird Bird Bird Bird Bird Bird Bird
					   Bird Bird Bird Bird Bird))
   (rhys :initform '(.2 .150 .150 .130 .015 .015 .02 .015 .015 .015 .02 .015 
		     .015 .015 .02 .015 .015 .015 .02 .015 .015 .015 .02 .015 
		     .015 .015 .02 .015 .015 .015 .02 .015 .015 .015 .02 .015 
		     .015 .015 .02 .015 .015 .015 .02))
   (durs :initform '(.13 .13 .13 .10 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01
		     .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01 .01
		     .01 .01))
   (frqs :initform '(1400 1400 1400 1400 5100 5100 5100 3000 5100 5100 5100
		     3000 5100 5100 5100 3000 5100 5100 5100 3000 5100 5100
		     5100 3000 5100 5100 5100 3000 5100 5100 5100 3000 5100
		     5100 5100 3000 5100 5100 5100 3000 5100 5100 5100 3000))
   (skws :initform '(1100 1100 1100 1100 2000 1600 1000 1200 2000 1600 1000
		     1200 2000 1600 1000 1200 2000 1600 1000 1200 2000 1600
		     1000 1200 2000 1600 1000 1200 2000 1600 1000 1200 2000
		     1600 1000 1200 2000 1600 1000 1200 2000 1600 1000 1200))
   (amps :initform '(.2 .2 .2 .2 .1 .1 .1 .1 .09 .09 .09 .09 .1 .1 .1 .1 .09
		     .09 .09 .09 .08 .08 .08 .08 .08 .08 .08 .08 .07 .07 .07
		     .07 .06 .06 .06 .06 .05 .05 .05 .05 .03 .03 .03 .03))
   (frqfs :initform '(Towhee_One Towhee_One Towhee_One Towhee_One Fas_Up
		      Fas_Up Fas_Up Fas_Down Fas_Up Fas_Up Fas_Up Fas_Down
		      Fas_Up Fas_Up Fas_Up Fas_Down Fas_Up Fas_Up Fas_Up
		      Fas_Down Fas_Up Fas_Up Fas_Up Fas_Down Fas_Up Fas_Up
		      Fas_Up Fas_Down Fas_Up Fas_Up Fas_Up Fas_Down Fas_Up
		      Fas_Up Fas_Up Fas_Down Fas_Up Fas_Up Fas_Up Fas_Down
		      Fas_Up Fas_Up Fas_Up Fas_Down))
   (ampf :initform 'Bird_Amp)
   (argsn :accessor bird-argsn :initform '((3 1 .03 2 1 3 .03)
					   (3 1 .03 2 1 3 .03)
					   (3 1 .03 2 1 3 .03)
					   (3 1 .03 2 1 3 .03)))
   (composer :initform #'(lambda (p) 
			   (setf (event-name p) (pop (bird-names p))
				 (event-rhythm p) (pop (bird-rhys p))
				 (event-dur p) (pop (bird-durs p))
				 (event-frq p) (pop (bird-frqs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-amp p) (pop (bird-amps p))
				 (event-frqf p) (pop (bird-frqfs p))
				 (event-args p) (pop (bird-argsn p))))))
  :define-resource nil)

(defpart prothonotary-warbler (bird bird-data-2)
         ()
  ((events :initform 14)
   (name :initform 'Bird)
   (rhys :initform '(.09 .17 .1 .14 .09 .19 .09 .17 .09 .14 .09 .18 .09))
   (durs :initform '(.08 .05 .09 .05 .08 .05 .08 .05 .08 .05 .08 .05 .08 .05))
   (frqs :initform '(3000 4000 3000 4000 3000 4000 3000 4000 3000 4000 3000
		     4000 3000 4000))
   (skws :initform '(3000 2500 3000 2500 3000 2500 3000 2500 3000 2500 3000
		     2500 3000 2500))
   (amps :initform '(.05 .06 .1 .1 .15 .16 .2 .19 .2 .16 .15 .1 .1 .06))
   (frqfs :initform '(Pro_One Fas_Up Pro_One Fas_Up Pro_One Fas_Up Pro_One
		      Fas_Up Pro_One Fas_Up Pro_One Fas_Up Pro_One Fas_Up))
   (ampfs :initform '(Pro_Amp Bird_Amp Pro_Amp Bird_Amp Pro_Amp Bird_Amp
		      Pro_Amp Bird_Amp Pro_Amp Bird_Amp Pro_Amp Bird_Amp
		      Pro_Amp Bird_Amp))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart audubons-warbler (bird bird-data-1)
         ()
  ((events :initform 20)
   (name :initform 'Bird)
   (rhys :initform '(.08 .07 .07 .05 .04 .07 .09 .03 .1 .03 .09 .03 .05 .01
		     .09 .05 .09 .07 .16))
   (durs :initform '(.04 .03 .04 .04 .03 .04 .05 .02 .08 .02 .07 .03 .03 .01
		     .06 .03 .07 .06 .14 .12))
   (frqs :initform '(2400 3200 2500 2300 3500 2300 2300 3200 2400 2200 2400
		     3000 2500 2300 2200 3100 2800 2400 3100 3200))
   (skws :initform '(200 200 300 600 400 1200 1200 800 600 400 1400 800 400
		     100 1400 800 800 1000 900 800))
   (amps :initform '(.05 .1 .15 .15 .2 .1 .15 .25 .2 .1 .15 .2 .1 .05 .15 .1
		     .15 .1 .25 .2))
   (frqfs :initform '(Fas_Down Fas_Up Fas_Up Fas_Down Fas_Up Fas_Up Fas_Down
		      Fas_Up W_UpDown Fas_Up Fas_Down Fas_Up W_UpDown Fas_Up
		      Fas_Down Fas_Up W_UpDown Fas_Down W_End W_End))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart lark-bunting (bird bird-data-1)
         ()
  ((events :initform 25)
   (name :initform 'Bird)
   (rhys :initform '(.1 .2 .05 .06 .09 .05 .06 .09 .05 .06 .09 .05 .06 .09 .05
		     .06 .09 .05 .06 .09 .05 .06 .06 .235))
   (durs :initform '(.03 .12 .03 .05 .03 .03 .05 .03 .03 .05 .03 .03 .05 .03
		     .03 .05 .03 .03 .05 .03 .03 .05 .03 .23 .28))
   (frqs :initform '(1800 3700 4100 2000 1800 4100 2000 1800 4100 2000 1800
		     4100 2000 1800 4100 2000 1800 4100 2000 1800 4100 2000
		     1800 6000 6000))
   (skws :initform '(100 400 500 400 100 500 400 100 500 400 100 500 400 100
		     500 400 100 500 400 100 500 400 100 600 600))
   (amps :initform '(.1 .2 .15 .2 .1 .15 .2 .1 .15 .2 .1 .15 .2 .1 .15 .2 .1
		     .15 .2 .1 .15 .2 .1 .15 .15))
   (frqfs :initform '(Fas_Up Fas_Up Fas_Down Fas_Down Fas_Up Fas_Down Fas_Down
		      Fas_Up Fas_Down Fas_Down Fas_Up Fas_Down Fas_Down Fas_Up
		      Fas_Down Fas_Down Fas_Up Fas_Down Fas_Down Fas_Up 
		      Fas_Down Fas_Down Fas_Up B_Trill_One B_Trill_Two))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart eastern-bluebird (bird bird-data-1)
         ()
  ((events :initform 8)
   (name :initform 'Bird)
   (rhys :initform '(.15 .06 .04 .2 .480 .04 .240))
   (durs :initform '(.02 .02 .02 .13 .240 .03 .1 .15))
   (frqs :initform '(2000 2000 2000 2000 2000 2200 1950 2000))
   (skws :initform '(1600 1600 1600 1400 800 400 100 600))
   (amps :initform '(.1 .1 .1 .2 .2 .1 .15 .2))
   (frqfs :initform '(Fas_Up Fas_Up Fas_Up Fas_Down Blue_Three Fas_Up Fas_Mid
		      Blue_Five))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart chuck-wills-widow (bird bird-data-1)
         ()
  ((events :initform 3)
   (name :initform 'Bird)
   (rhys :initform '(.270 .240))
   (durs :initform '(.03 .2 .290))
   (frqs :initform '(1000 1000 900))
   (skws :initform '(800 1000 1100))
   (amps :initform '(.1 .2 .2))
   (frqfs :initform '(Fas_Down Wid_One Wid_Two))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)

(defpart bluegray-gnatcatcher (bird bird-data-1)
         ()
  ((events :initform 6)
   (name :initform 'Bigbird)
   (rhys :initform '(.3 .600 .4 .2 .2))
   (durs :initform '(.2 .13 .25 .17 .17 .17))
   (frq :initform 4000)
   (skws :initform '(1000 800 800 900 700 800))
   (amp :initform .2)
   (frqfs :initform '(GSkw1 GSkw2 GSkw2 GSkw1 GSkw1 GSkw2))
   (ampf :initform 'Bird_Amp)
   (args :initform '(3 1 .4 2 1 3 .1))
   (composer :initform #'(lambda (p)
			   (setf (event-rhythm p) (pop (bird-rhys p))
				 (event-dur p) (pop (bird-durs p))
				 (event-skw p) (pop (bird-skws p))
				 (event-frqf p) (pop (bird-frqfs p))))))
  :define-resource nil)

(defpart blackthroated-sparrow (bird bird-data-2)
         ()
  ((events :initform 31)
   (name :initform 'Bird)
   (rhys :initform '(.03 .13 .04 .04 .11 .1 .270 .08 .06 .03 .02 .03 .02 .02
		     .02 .03 .02 .02 .02 .03 .02 .02 .02 .03 .02 .02 .02 .03
		     .03 .03))
   (durs :initform '(.02 .01 .02 .02 .1 .05 .25 .05 .04 .01 .01 .03 .02 .01
		     .01 .03 .02 .01 .01 .03 .02 .01 .01 .03 .02 .01 .01 .03
		     .02 .01 .03))
   (frqs :initform '(2200 3000 5800 4000 2100 5700 2000 5600 3900 1900 3600
		     3900 5000 1900 3600 3900 5000 1900 3600 3900 5000 1900
		     3600 3900 5000 1900 3600 3900 5000 1900 3800))
   (skws :initform '(1000 200 500 200 1700 400 900 400 1100 100 300 1000 100
		     100 300 1000 100 100 300 1000 100 100 300 1000 100 100
		     300 1000 100 100 300))
   (amps :initform '(.1 .05 .05 .05 .15 .25 .2 .15 .15 .1 .1 .15 .2 .1 .1 .15
		     .2 .1 .1 .15 .2 .1 .1 .15 .2 .1 .1 .15 .2 .1 .1))
   (frqfs :initform '(Fas_Down Fas_Up Fas_Up Fas_Up Fas_Down Fas_Up Black_Trill
		      Black_Up_Down Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up))
   (ampfs :initform '(Bird_Amp Bird_Amp Bird_Amp Bird_Amp Black_Down_Amp
		      Bird_Amp Bird_Amp Bird_Amp Bird_Amp Fas_Mid Fas_Mid
		      Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid
		      Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid
		      Fas_Mid Fas_Mid Fas_Mid Fas_Mid Fas_Mid Bird_Amp))
   (composer :initform #'bird-song-2))
  :define-resource nil)

(defpart blackchinned-sparrow (bird bird-data-1)
         ()
  ((events :initform 16)
   (name :initform 'Bird)
   (rhys :initform '(.4 .25 .15 .1 .15 .09 .08 .07 .08 .07 .06 .05 .04 .03 
		     .02))
   (durs :initform '(.2 .09 .08 .08 .11 .07 .07 .07 .07 .05 .04 .03 .03 .02 
		     .01 .01))
   (frqs :initform '(4200 3800 3900 3600 3100 2900 2900 3000 3200 3200 3400 
		     3600 3800 3900 3900 3900))
   (skws :initform '(100 2000 1700 2300 2800 2700 2700 2300 2000 1500 1000 700
		     300 100 100 100))
   (amps :initform '(.1 .1 .12 .13 .14 .15 .15 .13 .1 .1 .07 .05 .05 .03 .01 
		     .01))
   (frqfs :initform '(Fas_Up Chin_Up2 Chin_Up2 Fas_Up Fas_Up Fas_Up Fas_Up 
		      Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up Fas_Up
		      Fas_Up))
   (ampf :initform 'Bird_Amp)
   (composer :initform #'bird-song-1))
  :define-resource nil)
