;;; -*- Syntax: Common-Lisp; Package: CL-MUSIC-USER; Base: 10; Mode: Lisp -*-

(in-package "CL-MUSIC-USER")

(export '(bird bigbird))

(defInstrument bird (start-time duration frequency 
		     freq-skew amplitude Freq-envelope Amp-envelope)
  (multiple-value-bind (beg end) (get-beg-end start-time duration)
    (let* ((amp-env (make-env :envelope amp-envelope
			      :scaler amplitude 
			      :start-time start-time 
			      :duration duration))
	   (gls-env (make-env :envelope freq-envelope
			      :scaler (* two-pi 
		        		 (/ freq-skew sampling-rate))
			      :start-time start-time 
			      :duration duration))
	   (s (make-oscil :frequency frequency)))
      (Run
       (loop for i from beg to end do
	 (outa i (* (env amp-env) (oscil s (env gls-env)))))))))

(defInstrument BigBird (start-time duration frequency freq-skew
			amplitude Freq-envelope Amp-envelope Partials)
  (multiple-value-bind (beg end) (get-beg-end start-time duration)
    (let* ((waveform (load-synthesis-table partials (make-table)))
	   (s (make-table-lookup :frequency frequency 
				 :wave-table waveform))
	   (amp-env (make-env :envelope amp-envelope
			      :scaler amplitude 
			      :start-time start-time 
			      :duration duration))
	   (gls-env (make-env :envelope freq-envelope
			      :scaler (in-Hz freq-skew) 
			      ;;interpret amplitude as a frequency
			      :start-time start-time 
			      :duration duration)))
      (Run
       (loop for i from beg to end do
	 (outa i (* (env amp-env) (table-lookup s (env gls-env)))))))))

(export '(FAS_UP FAS_MID BIRD_TAP RONE RTWO RTHREE RFOUR RFIVE BIRD_AMP ORIUP 
	  ORIDWN ORIUPDWNA ORIUPDWNB ORIBIGA ORIMID ORIDWNUP ORIAMP KINGFIRST
	  KINGSECOND CHIP_UP BOBUP1 BOBUP2 NO_SKW DOWN_SKW FAS_DOWN SCISSOR 
	  OWLUP OWLDOWN GRAYONE GRAYTWO GRAYTHREE GRAYFOUR YELLOW_UP 
	  YELLOW_SWIRL YELLOW_DOWN YELLOW_LAST SWIRL_AMP UPAMP RAMPUP YCURVE 
	  VCURVE WCURVE UPCURVE DOWNCURVE LOUDER WAMP GRASSONE GRASSTWO 
	  SWAMP_UP SWAMP_DOWN GOLDONE GOLDTWO GOLDTRILL BUNTDWN BUNTV BUNTY 
	  BUNTN BUNTX BUNTUP HOODUP HOODDOWN WIDGEON WATER_ONE WATER_TWO 
	  WATER_THREE WATER_FOUR WATER_FIVE WATER_AMP WATER_DAMP R_ONE R_TWO 
	  R_THREE R_FOUR R_FIVE R_SIX BIGSKEW HUPDOWN W_DOWN TRILL W_UP 
	  NASH_BLIP NASH_DOWN NASH_UP NASH_AMP PHOEBE_ONE PHOEBE_TWO 
	  PHOEBE_THREE PHOEBE_FOUR PHOEBE_AMP B_ONE B_TWO B_THREE B_FOUR 
	  B_FIVE B_SIX B_SEVEN B_EIGHT B_NINE B_TEN B_ELEVEN B_TWELVE 
	  B_THIRTEEN B_FOURTEEN B_FIFTEEN F_ONE A_ONE F_TWO A_TWO SOPENING 
	  SUP SDWN SUPN SLAST CEDAR CEDAMP BAIRDEND BAIRDSTART KENSTART 
	  KENDWN KENUP KENTRILL TOWHEE_ONE TOWHEE_TWO TOWHEE_THREE PRO_ONE 
	  PRO_TWO PRO_AMP W_UP W_DOWN W_END W_UPDOWN B_DOWN B_UP B_TRILL_ONE 
	  B_TRILL_TWO BLUE_ONE BLUE_TWO BLUE_THREE BLUE_FOUR BLUE_FIVE 
	  WID_DOWN WID_ONE WID_TWO GSKW1 GSKW2 BLACK_UP BLACK_DOWN 
	  BLACK_DOWN_AMP BLACK_TRILL BLACK_UP_DOWN BLACK_AMP CHIN_UP CHIN_UP2 
	  GULLSTART GULLMIDDLE GULLEND))

(defvar FAS_UP '(0 0 100 1))
(defvar FAS_MID '(0 0 50 1 100 0))
(defvar BIRD_TAP '(0 0 5 1 91 1 100 1))
(defvar RONE '(0 .2 25 1 75 .8 100 0))
(defvar RTWO '(0 1 90 0 100 0))
(defvar RTHREE '(0 .3 10 .3 25 0 40 .3 50 1 60 .3))
(defvar RFOUR '(0 0 10 1 25 .8 40 .8 60 0 100 .1))
(defvar RFIVE '(0 0 10 .2 25 .6 35 .3 90 1 100 0))

(defvar BIRD_AMP '(0 0 25 1 75 1 100 0 ))
(defvar ORIUP '(0 0 100 1 ))
(defvar ORIDWN '(0 1 100 0 ))
(defvar ORIUPDWNA '(0 0 60 1 100 .6000 ))
(defvar ORIUPDWNB '(0 .5000 30 1 100 0 ))
(defvar ORIBIGA '(0 .9000 15 1 40 .3000 60 .6000 85 0 100 0 ))
(defvar ORIMID '(0 1 5 .5000 10 1 25 0 85 .5000 100 0 ))
;COMMENT TWICE
(defvar ORIDWNUP '(0 .3000 25 0 100 1 ))
(defvar ORIAMP '(0 0 10 1 100 0 ))
(defvar KINGFIRST '(0 .3000 45 1 90 .1000 100 0 ))
(defvar KINGSECOND '(0 0 2 .5000 4 0 6 .5500 8 .0500 10 .6000 12 .0500 14 .6500 16 .1000 18 .7000 20 .1000 22 .7500 24 .1500 26 .8000 28 .2000 30 .8500 32 .2500 34 .9000 36 .3000 38 .9500 40 .4000 42 1 44 .5000 46 1 48 .4500 50 1 52 .5000 54 1 56 .4000 58 .9500 60 .4000 62 .9000 64 .4000 66 .8500 68 .3500 70 .8000 72 .3000 74 .7500 76 .2500 78 .7000 80 .2000 82 .6500 84 .1000 86 .6000 88 0 90 .5500 92 0 94 .5000 96 0 100 .4000 ))
(defvar CHIP_UP '(0 .8000 15 1 75 .3000 100 0 ))
(defvar BOBUP1 '(0 0 40 1 100 1 ))
(defvar BOBUP2 '(0 0 65 .5000 100 1 ))
(defvar NO_SKW '(0 0 100 0 ))
;COMMENT WESTERN MEADOWLARK
(defvar DOWN_SKW '(0 1 40 .4000 100 0 ))
(defvar FAS_DOWN '(0 1 100 0 ))
(defvar SCISSOR '(0 0 40 1 60 1 100 0 ))
(defvar OWLUP '(0 0 30 1 100 1 ))
(defvar OWLDOWN '(0 1 100 0 ))
(defvar GRAYONE '(0 .5000 2 .6000 4 .4500 6 .6200 8 .4000 10 .6500 12 .3500 14 .7000 18 .3000 20 .7000 22 .3000 24 .7000 25 .2000 30 .8000 35 .1000 40 .9000 45 0 50 1 55 0 60 1 65 0 70 1 75 0 80 1 85 0 90 1 95 0 100 .5000 ))
(defvar GRAYTWO '(0 0 1 .4000 2 0 3 .4000 4 0 5 .4000 6 0 7 .4000 8 0 9 .4000 10 0 25 .8000 40 .3000 55 1 70 0 85 .8000 100 .4000 ))
(defvar GRAYTHREE '(0 1 1 .6000 2 1 3 .6000 4 1 5 .6000 6 1 7 .6000 8 1 9 .6000 10 1 11 .6000 12 1 13 .6000 14 1 15 .6000 16 1 17 .6000 18 1 19 .6000 20 1 21 .5500 22 1 23 .5000 24 1 25 .5000 26 1 27 .5000 28 1 29 .5000 30 1 31 .5000 32 1 33 .5000 34 1 35 .5000 36 1 37 .5000 38 1 39 .5000 40 1 41 .5000 42 1 43 .5000 44 1 45 .5000 46 1 47 .5000 48 1 49 .5000 50 1 51 .5000 52 1 53 .5000 54 1 55 .5000 56 1 57 .5000 58 1 59 .5000 60 1 100 0 ))
(defvar GRAYFOUR '(0 0 100 1 ))
(defvar YELLOW_UP '(0 0 60 1 100 .5000 ))
(defvar YELLOW_SWIRL '(0 1 5 1 60 0 80 .3000 100 .1000 ))
(defvar YELLOW_DOWN '(0 1 100 0 ))
(defvar YELLOW_LAST '(0 0 30 .2000 80 .7000 100 1 ))
(defvar SWIRL_AMP '(0 0 90 1 100 0 ))
(defvar UPAMP '(0 0 90 1 100 0 ))
(defvar RAMPUP '(0 0 50 1 100 .2000 ))
(defvar YCURVE '(0 1 30 .5000 60 1 80 .2000 100 0 ))
(defvar VCURVE '(0 .2000 50 1 100 0 ))
(defvar WCURVE '(0 .5000 15 0 45 .1000 60 1 70 .9000 100 .9000 ))
(defvar UPCURVE '(0 0 95 1 100 1 ))
(defvar DOWNCURVE '(0 1 25 .3000 60 .1500 100 0 ))
(defvar LOUDER '(0 0 90 1 100 0 ))
(defvar WAMP '(0 0 10 1 40 .1000 50 .9000 60 .1000 70 1 100 0 ))
(defvar GRASSONE '(0 .5000 2 .8000 4 .3000 6 .8000 7 .1000 8 .9000 10 0 11 .9000 12 0 13 .9000 14 .1000 15 1 16 .1000 17 1 18 .1000 19 1 20 .1000 21 1 22 .1000 23 1 24 .1000 25 1 26 .1000 27 1 28 .1000 29 1 30 .1000 31 1 32 .1000 33 1 34 .1000 35 1 36 .1000 37 1 38 .1000 39 1 40 .1000 41 1 42 .1000 43 1 44 .1000 45 1 46 .1000 47 1 48 .1000 49 1 50 .1000 51 1 52 .1000 53 1 54 .1000 55 1 56 .1000 57 1 58 .1000 59 1 60 .1000 61 1 62 .1000 63 1 64 .1000 65 1 66 .1000 67 1 68 .1000 69 1 70 .1000 71 1 72 .1000 73 1 74 .1000 75 1 76 .1000 77 1 78 .1000 79 1 80 .1000 81 1 82 .1000 83 1 84 .1000 85 1 86 .1000 87 1 88 .1000 89 1 90 .1000 91 1 92 .1000 93 1 94 .1000 95 1 96 .1000 97 1 98 .1000 100 1 ))
(defvar GRASSTWO '(0 0 10 1 20 0 30 1 40 0 50 1 60 0 70 1 80 0 90 1 100 0 ))
(defvar SWAMP_UP '(0 0 60 .7000 100 1 ))
(defvar SWAMP_DOWN '(0 1 50 .5000 60 .6000 100 0 ))
(defvar GOLDONE '(0 1 25 .2000 100 0 ))
;COMMENT TWICE
(defvar GOLDTWO '(0 .9000 5 1 10 .4000 100 0 ))
(defvar GOLDTRILL '(0 .5000 10 0 20 1 30 0 40 1 50 0 60 1 70 0 80 1 90 0 100 .5000 ))
(defvar BUNTDWN '(0 1 100 0 ))
(defvar BUNTV '(0 0 50 1 100 0 ))
(defvar BUNTY '(0 1 50 0 100 .9000 ))
(defvar BUNTN '(0 .8000 30 1 70 .2000 100 0 ))
(defvar BUNTX '(0 1 10 .5000 25 .9000 100 0 ))
(defvar BUNTUP '(0 0 100 1 ))
(defvar HOODUP '(0 0 100 1 ))
(defvar HOODDOWN '(0 1 100 0 ))
(defvar WIDGEON '(0 0 50 1 100 0 ))
(defvar WATER_ONE '(0 .8000 35 .4000 45 .9000 50 1 75 1 100 .1000 ))
(defvar WATER_TWO '(0 1 40 0 60 .1000 100 .8000 ))
(defvar WATER_THREE '(0 1 95 0 100 0 ))
(defvar WATER_FOUR '(0 0 100 1 ))
(defvar WATER_FIVE '(0 1 100 0 ))
(defvar WATER_AMP '(0 0 35 1 50 .2000 90 1 100 0 ))
(defvar WATER_DAMP '(0 0 90 1 100 0 ))
(defvar R_ONE '(0 .1000 8 .7000 30 0 35 1 40 .3000 100 .3000 ))
(defvar R_TWO '(0 0 10 1 20 .7000 35 .7000 65 .3000 70 .5000 80 0 90 .2000 100 0 ))
(defvar R_THREE '(0 .2000 25 1 60 .7000 90 0 100 .1000 ))
(defvar R_FOUR '(0 1 100 0 ))
(defvar R_FIVE '(0 .5000 10 0 20 1 30 0 40 1 50 0 60 1 70 .5000 100 .2000 ))
(defvar R_SIX '(0 0 12 .7000 30 0 70 1 100 .5000 ))
(defvar BIGSKEW '(0 .2000 3 .3000 6 .1000 10 .5000 13 .4000 16 .8000 19 .5000 22 .9000 25 .6000 28 1 31 .6000 34 1 37 .5000 41 .9000 45 .4000 49 .8000 51 .4000 54 .7500 57 .3500 60 .7000 63 .3000 66 .6000 69 .2500 72 .5000 75 .2000 78 .3000 82 .1000 85 .3000 88 .0500 91 .3000 94 0 95 .3000 99 0 100 .1000 ))
(defvar HUPDOWN '(0 0 30 1 70 1 100 0 ))
(defvar W_DOWN '(0 1 100 0 ))
(defvar TRILL '(0 .8000 10 1 25 .5000 40 1 55 .5000 70 1 100 0 ))
(defvar W_UP '(0 0 100 1 ))
(defvar NASH_BLIP '(0 .6000 35 1 100 0 ))
(defvar NASH_DOWN '(0 .9000 5 1 10 .9000 65 .5000 100 0 ))
(defvar NASH_UP '(0 0 15 .2000 25 .0500 90 .9500 100 1 ))
(defvar NASH_AMP '(0 0 80 1 100 0 ))
(defvar PHOEBE_ONE '(0 0 30 .3000 35 .5000 55 .4000 70 .8000 75 .7000 80 1 95 .9000 100 0 ))
(defvar PHOEBE_TWO '(0 0 50 1 100 0 ))
(defvar PHOEBE_THREE '(0 0 10 .4000 80 1 100 .1000 ))
(defvar PHOEBE_FOUR '(0 1 50 .7000 100 0 ))
(defvar PHOEBE_AMP '(0 0 10 1 100 0 ))
(defvar B_ONE '(0 0 100 1 ))
(defvar B_TWO '(0 0 90 1 100 0 ))
(defvar B_THREE '(0 1 100 0 ))
(defvar B_FOUR '(0 0 50 1 100 0 ))
(defvar B_FIVE '(0 .7000 15 0 40 1 80 1 100 .5000 ))
(defvar B_SIX '(0 0 10 .5000 15 0 40 1 90 1 100 0 ))
(defvar B_SEVEN '(0 1 25 .4000 75 .5000 100 0 ))
(defvar B_EIGHT '(0 .3000 40 .4000 50 1 60 .2000 100 0 ))
(defvar B_NINE '(0 0 5 1 30 1 50 .3000 90 1 100 0 ))
(defvar B_TEN '(0 .4000 25 0 35 1 50 0 65 1 75 0 85 1 100 0 ))
(defvar B_ELEVEN '(0 1 100 0 ))
(defvar B_TWELVE '(0 0 50 1 100 .5000 ))
(defvar B_THIRTEEN '(0 0 5 1 30 .2000 60 .2000 90 1 100 0 ))
(defvar B_FOURTEEN '(0 .3000 30 1 60 .3000 100 0 ))
(defvar B_FIFTEEN '(0 0 10 .5000 50 .5000 90 1 100 0 ))
(defvar F_ONE '(0 0 10 1 20 .4000 95 .1000 100 0 ))
(defvar A_ONE '(0 0 10 .2000 20 .1000 30 1 90 1 100 0 ))
(defvar F_TWO '(0 .5000 25 1 50 0 60 0 95 .3000 100 .6000 ))
(defvar A_TWO '(0 0 10 1 20 1 50 .1000 60 .1000 90 1 100 0 ))
(defvar SOPENING '(0 1 10 .5000 90 .5000 100 0 ))
(defvar SUP '(0 .1000 35 0 100 1 ))
(defvar SDWN '(0 1 40 .5000 100 0 ))
(defvar SUPN '(0 0 100 1 ))
(defvar SLAST '(0 1 25 0 75 .4000 100 .5000 ))
(defvar CEDAR '(0 0 25 .7000 70 1 90 1 100 .2000 ))
(defvar CEDAMP '(0 0 20 1 40 1 100 0 ))
(defvar BAIRDEND '(0 0 25 1 50 0 75 1 100 0 ))
(defvar BAIRDSTART '(0 .5000 5 1 10 0 15 1 20 0 25 1 30 0 35 1 40 0 45 1 50 0 55 1 60 0 65 1 70 0 75 1 80 0 85 1 90 0 95 1 100 0 ))
(defvar KENSTART '(0 .3000 50 1 100 0 ))
(defvar KENDWN '(0 .9000 10 1 100 0 ))
(defvar KENUP '(0 0 100 1 ))
(defvar KENTRILL '(0 1 25 0 50 0 75 1 100 0 ))
(defvar TOWHEE_ONE '(0 .1000 2 .0500 4 .1500 6 .0500 8 .2000 10 .0400 12 .2500 14 .0300 16 .3000 18 .0200 20 .3500 22 .0100 24 .4000 26 0 28 .4500 30 0 32 .5000 34 0 36 .5000 80 1 100 0 ))
(defvar TOWHEE_TWO '(0 0 100 1 ))
(defvar TOWHEE_THREE '(0 1 100 0 ))
(defvar PRO_ONE '(0 .1000 20 0 100 1 ))
(defvar PRO_TWO '(0 0 100 1 ))
(defvar PRO_AMP '(0 0 20 1 40 .5000 100 0 ))
(defvar W_UP '(0 0 100 1 ))
(defvar W_DOWN '(0 1 100 0 ))
(defvar W_END '(0 0 15 1 45 .9000 50 0 55 1 90 .9000 100 .1000 ))
(defvar W_UPDOWN '(0 .1000 50 1 100 0 ))
(defvar B_DOWN '(0 1 100 0 ))
(defvar B_UP '(0 0 100 1 ))
(defvar B_TRILL_ONE '(0 0 6 .8000 12 0 18 .8500 24 .0500 36 .9000 42 .1000 48 .9500 54 .2000 60 1 66 .2000 72 1 78 .2000 84 1 90 .2000 100 1 ))
(defvar B_TRILL_TWO '(0 0 5 .8000 10 0 15 .8500 20 0 25 .9000 30 0 35 .9500 40 0 45 1 50 0 55 1 60 0 65 1 70 0 75 1 80 0 85 1 90 0 95 1 100 0 ))
(defvar BLUE_ONE '(0 0 100 1 ))
(defvar BLUE_TWO '(0 1 100 0 ))
(defvar BLUE_THREE '(0 .6000 10 1 20 0 25 1 30 0 35 1 40 0 45 1 50 0 75 1 100 0 ))
(defvar BLUE_FOUR '(0 0 50 1 100 0 ))
(defvar BLUE_FIVE '(0 .5000 10 1 20 0 35 1 50 0 65 1 80 0 95 1 100 .5000 ))
(defvar WID_DOWN '(0 1 100 0 ))
(defvar WID_ONE '(0 0 10 .1000 25 1 50 .3000 80 .7000 100 0 ))
(defvar WID_TWO '(0 .2000 30 1 50 .3000 60 .7000 90 .1000 100 0 ))
(defvar GSKW1 '(0 0 15 1 75 .8000 90 1 100 .7000 ))
(defvar GSKW2 '(0 0 25 1 75 .7000 100 0 ))
(defvar BLACK_UP '(0 0 100 1 ))
(defvar BLACK_DOWN '(0 1 100 0 ))
(defvar BLACK_DOWN_AMP '(0 0 75 1 100 0 ))
(defvar BLACK_TRILL '(0 0 3 .7000 6 0 9 .7500 12 0 15 .8000 18 .0500 21 .8500 24 .1000 27 .9000 30 .1000 33 1 36 .1000 39 1 42 .1000 45 1 48 .1000 51 1 54 .1000 57 1 60 .1000 63 1 66 .1000 69 1 72 .1000 75 1 78 .1000 81 1 84 .1000 87 1 90 0 93 .9500 96 0 100 .9000 ))
(defvar BLACK_UP_DOWN '(0 0 50 1 100 .2000 ))
(defvar BLACK_AMP '(0 0 50 1 100 0 ))
(defvar CHIN_UP '(0 0 100 1 ))
(defvar CHIN_UP2 '(0 0 30 .2000 100 1 ))
(defvar GULLSTART '(0 0 10 1 20 .5000 40 .6000 60 .5000 100 0 ))
(defvar GULLMIDDLE '(0 0 10 1 30 .5000 80 .5000 100 0 ))
(defvar GULLEND '(0 0 5 1 10 .5000 90 .4000 100 0 ))
