;;; -*- Mode: Lisp; Syntax: Common-lisp; Package: common-music; Base: 10 -*-
;;; **********************************************************************
;;; Copyright (c) 89, 90, 91, 92, 93 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; address electronic correspondence to: hkt@zkm.de
;;; **********************************************************************


(in-package :common-music)

;;;
;;; transpose a scale reference by some interval.
;;;

(defmethod transpose ((degree integer) (interval integer) &optional scale)
  (declare (optimize (speed 3) (safety 0))
	   #-aclpc (ignore scale))
  (+ (the integer degree)
     (the integer interval)))

(defmethod transpose ((name symbol) (interval integer) 
		      &optional (scale *standard-scale*))
  (declare (optimize (speed 3) (safety 0)))
  (scale-note (+ (the integer (scale-degree name scale))
		 (the integer interval))
	      scale))

(defmethod transpose ((pitch float) (interval integer) 
		      &optional (scale *standard-scale*))
  (declare (optimize (speed 3) (safety 0)))
  (scale-pitch (+ (the integer (scale-degree pitch scale)) 
		  (the integer interval))
	       scale))

;;;
;;; invert a scale reference around some point.
;;;
  
(defmethod invert ((note symbol) point &optional (scale *standard-scale*))
  (let ((off (scale-degree point scale)))
    (scale-note (+ off (* (- (scale-degree note scale) off) -1))
                scale)))

(defmethod invert ((note integer) point &optional (scale *standard-scale*))
  (let ((off (scale-degree point scale)))
    (scale-degree (+ off (* (- (scale-degree note scale) off) -1))
                  scale)))

(defmethod invert ((note float) point &optional (scale *standard-scale*))
  (let ((off (scale-degree point scale)))
    (scale-pitch (+ off (* (- (scale-degree note scale) off) -1))
                 scale)))
;;;
;;; random selection between a range. value will not equal exception value,
;;; if supplied. this forces no direct repeats, but between does not check
;;; to see if there are no other choices.
;;; 

(defun between (lb ub &optional exception (state *cm-state*))
  (let ((range (- ub lb)))
    (if (not (> range 0))
	lb
      (if exception
	  (loop with num 
	   when (/= exception (setf num (+ lb (random range state))))
	   return num)
	(+ lb (random range state))))))


(defun header (&rest strings)
  (let ((newline (string #\newline)))
    (apply #'concatenate 'string (loop for s in strings 
				       collect s into l
                                       collect newline into l 
                                       finally (return l)))))
  