;;; **********************************************************************
;;; Copyright (c) 89-93, 94 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; address email to: hkt@zkm.de
;;; **********************************************************************

(in-package :common-music)

;;;
;;; Low level interface to Window's midi manager, implemented by Joe Fosco,
;;; email address is b38669@anl.gov. This file assumes that windmidi.dll
;;; can be loaded from the common music midi subdirectory.  If it doesn't
;;; exist, build it from the C sources: windmidi.def and winmidi.c.
;;; 

(defconstant *ff-midilib* 
  (format nil "~Amidi\\winmidi.dll" *common-music-directory*))
(defconstant +wndw-midi-status+  (byte 8 0))
(defconstant +wndw-midi-data1+   (byte 8 8))
(defconstant +wndw-midi-data2+   (byte 8 16))
(defconstant +wndw-midi-extra+    (byte 8 24))

(defconstant +ff-midi-success+ 0
  "Foreign function success value.")

(defvar *port-names* '())

(defun ff-midi-find-port (name)
     (when (eq nil *port-names*) (set-port-names))
     (and (find name *port-names* :test #'member)
             name))

(defun ff-midi-port-id (port)
     (when (eq nil *port-names*) (set-port-names))
     (position port *port-names* :test #'member))

(eval-when (compile load eval)
(ct:defcstruct total-midi-ports-struct
     ((total-midi-in ct:short)
      (total-midi-out ct:short)))
)

(defun set-port-names ()
  (let ((total-midi-ports (ct:callocate total-midi-ports-struct 
                                        total-midi-in 0 total-midi-out 0)))
    (ff-midi-get-no-ports total-midi-ports)
    (setf m-in (ct:cref total-midi-ports-struct 
                        total-midi-ports total-midi-in))
    (dotimes (port-no m-in)
      (setf *port-names* (append *port-names* (list (list port-no)))))))

(defun ff-midi-get-time (time-args)
  (setf (aref time-args 0) (ff-midi-get-time2))
  (setf (aref time-args 1) *quanta-size*)
  (if (= (aref time-args 0) 0) 1 +ff-midi-success+))

(defun ff-midi-set-quanta-size (usec)
  (let ((flg))
    (setf flg (ff-midi-set-quanta-size2 usec))
    (if ( = 0 flg)
        (progn (setf *quanta-size* usec) +ff-midi-success+)
      flg)))

(defun ff-midi-close ()
  (let ((rtn))
    (if (equalp (setf rtn (ff-midi-close2)) +ff-midi-success+)
        (progn (setf *quanta-time* 0)
               (setf *quanta-size* 1000)))
      rtn))

#|
(defun-callback midi-read-callback ((cevent ct:long))
     (let (event)
         (declare (special *midi-read-hook*)
                       (bignum event)
                       (optimize (speed 3) (safety 0)))
         (setf event cevent)
         (when *midi-read-hook*
              (funcall (the function *midi-read-hook*)
                           (the bignum event) ) ) ) )
|#

(ct:defun-callback midi-read-hook-func ((event ct:long))
  (declare (optimize (speed 3) (safety 0)))
  (print event)
  (print "In callback!")
  (print (the integer event)))

(defun ff-midi-read-messages ()
  (ff-midi-read-messages2 (ct:get-callback-procinst 'midi-read-hook-func)))

(ct:defun-dll ff-midi-start-timer ()
  :entry-name "midistarttimer"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-stop-timer ()
  :entry-name "midistoptimer"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-get-time2 ()
  :entry-name "midigettime"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:long)

(ct:defun-dll ff-midi-set-time ((new-time ct:long))
  :entry-name "midisettime"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-set-quanta-size2 ((new-quanta-size ct:long))
  :entry-name "midisetquantasize"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-open ((portnum ct:short))
  :entry-name "midiopen"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-close2 ()
  :entry-name "midiclose"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-read-messages2 ((lisp-function (ct:void *)))
  :entry-name "midireadmessages"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-write-message ((message ct:long ) (qtime ct:long))
  :entry-name "midiwritemessage"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-flush-transmit ()
  :entry-name "midiflushtransmit"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-flush-receive ()
  :entry-name "midiflushreceive"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-hush ()
  :entry-name "midihush"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-all-notes-off ((qtime ct:long))
  :entry-name "midiallnotesoff"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-midi-get-no-ports ((no-ports (total-midi-ports-struct *)))
  :entry-name "miditotalports"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:short)

(ct:defun-dll ff-total-open ()
  :entry-name "totalopen"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:long)

(ct:defun-dll ff-check-read ()
  :entry-name "checkread"
  :library-name *ff-midilib*
  :call-mode :pascal
  :return-type ct:long)
