#pragma once


#include <sys/ipc.h>
#include <sys/sem.h>
#include <midi.h>
#include "unix-flavors.h"
#include "SA_stack.h"

typedef struct {
  struct sembuf *semops;
  struct sigaction *act;
  struct sigaction *old_act;
  sigaction_stack *actions;  
  sigset_t mask;
  sigset_t old_mask;         /* Warning: No nested undo_on_signal support */
  int retval;
} std_task_block;

typedef struct {
  MIevent       *event;
  struct sembuf *semops;
  struct sigaction *act;
  struct sigaction *old_act;
  sigset_t mask;
  sigset_t old_mask;         /* Warning: No nested undo_on_signal support */
  sigaction_stack *actions;
  int retval;
} player_task_block;

typedef struct {
  MIevent       *event;
  int smpte[4];
  BOOL smpteok[8];
  struct sembuf *semops;
  struct sigaction *act;
  struct sigaction *old_act;
  sigset_t mask;
  sigset_t old_mask;         /* Warning: No nested undo_on_signal support */
  sigaction_stack *actions;
  int retval;
} ipc_task_block;

extern std_task_block *STB_new(void);
extern player_task_block *PTB_new(void);
extern ipc_task_block *ITB_new(void);
