#include <midi.h>

#define CHANNEL_MESSAGE(x)  ((x).mm.msgbuf)
#define SYSEX_MESSAGE(x)    ((x).mm.sysexbuf)

#define MIprogramNr MIbyte1
#define MIbend(msg) (((MIbyte2(msg) << 2) | (MIbyte1(msg) >> 5)) + (MIbyte1(msg) & 0x1))

#define SMPTEnibble(msg) ((MIbyte1(msg) >> 4) & 0xF)
#define SMPTEvalue(msg)	 (MIbyte1(msg) & 0xF)
#define SMPTEfprintf(s,smpte) fprintf(s, "SMPTE %d %d %d %d", (int)smpte[3], (int)smpte[2], (int)smpte[1], (int)smpte[0])


extern void MIfree(MIevent*);

typedef struct MIevent_ref {
  long refcount;
  MIevent* event;
} MIevent_ref;


typedef struct MIlist {
  MIevent_ref* event;
  struct MIlist* next;
} MIevent_cell, *MIevent_list;

extern MIevent_list cdr(MIevent_list);
extern MIevent*     car(MIevent_list);

typedef struct MIqueue {
  MIevent_list  events;
  MIevent_list  first_event;
  MIevent_list  last_event;
  MIevent_list  first_free;
  MIevent_list  first_recyclable;
} MIevent_queue;
     


MIevent_list MIlist_alloc();

extern MIevent_queue *MIQnew(int);
extern MIevent_list   MIQpush(MIevent_queue *, MIevent *);
extern MIevent       *MIQpop(MIevent_queue *);
extern MIevent       *MIQhead(MIevent_queue *);
extern MIevent       *MIQreserve(MIevent_queue *);
extern MIevent_list   MIQrecycle(MIevent_queue *, MIevent *);
extern MIevent_list   MIQextend(MIevent_queue *);
extern int            MIQlength(MIevent_queue *);

MIevent_list MIQalloc(MIevent_queue *);
