#include "midi_threads.h"

#include <malloc.h>
#include <stdlib.h>

#include <sys/file.h>
#include <sys/mman.h>
#include <stdio.h> 

#include "unix-flavors.h"

#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) > (b) ? (b) : (a))
#define A_MIDI_PORT "/dev/ttyd1"
#define B_MIDI_PORT "/dev/ttyd2"
#define DEFAULT_MIDI_PORT  B_MIDI_PORT 

extern MIevent_queue     *midi_in_queue,*midi_out_queue;

#include "MIPortedQueue.h"

extern int midistarttimer();
extern int midistoptimer();
extern int midiopen(MIevent_queue *port);
extern int midiclose(MIPortedQueue *q);
extern void send_midi_message(int message, int time);
extern int midiwritemessage(int message, int qtime);
extern int midiallnotesoff(int time);
extern int midihush ();
extern int midireadmessages();
extern int midiflushxmit();
extern int midiflushrecv();
extern int midigettime(int *time);
extern int midisettime(int time);
extern int midisetquantasize(int usec);
extern int myMIDIPrintEvent(FILE *s, MIevent *event);

