;;; -*- mode: lisp; syntax: common-lisp; package: common-music; base: 10 -*-

(in-package :common-music)

;;(require :foreign)
;;(eval-when (:compile-toplevel
;;	    :load-toplevel
;;	    :execute)
;; (lw:do-demand-pre-loads :c++))

(defconstant +ff-midi-success+ 0
  "Foreign function success value.")

(defvar *port-names*  '((:a a 1 :ttyd1 ttyd1) (:b b 2 :ttyd2 ttyd2)))

(defun ff-midi-find-port (name)
  (and (find name *port-names* :test #'member)
       name))

(defun ff-midi-port-id (port)
  #-lispworks
  (position port *port-names* :test #'member)
  #+lispworks
  (ffi:make-alien-object 0 'alien) ; This is just a hack until midiopen
                                   ; is reprogrammed so you can open an
                                   ; arbitrary MIDI queue which can be
                                   ; connected to another process.
                                   ; Anyway, SGI's MIports are logical
                                   ; devices which can write/read on any
                                   ; physical port without being 
                                   ; configured. You choose a particular
                                   ; one via the startmidi shell command.
                                   ; But be warned that midi-read/write-
                                   ; message do not know about devices
                                   ; for now, which limits you effectively
                                   ; to 16 channels (and write will actually
                                   ; send them to port 1 only). 
)


(foreign:foreign-callable *midi-read-hook* (:fixnum :fixnum)
			  :foreign-name "MIDI_INPUT_HOOK")

(defun *midi-read-hook* (event time)
  (declare (type fixnum event time))
  (declare (ignore  event time))
  )

(FOREIGN:DEFINE-FOREIGN-FUNCTION 
 (ff-midi-open "midiopen" :SOURCE)
                          ;((ARG-1 (:ALIEN |MIevent_queue|)))
			  ((ARG-1 :ALIEN))
			  :RESULT-TYPE :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION 
 (ff-midi-close-port "midiclose" :SOURCE)
                                 ;((ARG-1 (:ALIEN |MIPortedQueue|)))
				 ((ARG-1 :ALIEN))
                                 :RESULT-TYPE :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-start-timer "midistarttimer" :SOURCE) NIL :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-stop-timer "midistoptimer" :SOURCE) NIL :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION 
 (ff-midi-get-time "midigettime" :SOURCE)
                                 ((ARG-1 :ALIEN)) :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION 
 (ff-midi-set-time "midisettime" :SOURCE)
                                 ((ARG-1 :INTEGER)) :RESULT-TYPE
                                 :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-set-quanta-size "midisetquantasize" :SOURCE) ((ARG-1 :INTEGER))
                                 :RESULT-TYPE :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-read-messages "midireadmessages" :SOURCE) NIL :RESULT-TYPE
                                 :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-write-message "midiwritemessage" :SOURCE)
 ((ARG-1 :INTEGER) (ARG-2 :INTEGER)) :RESULT-TYPE :INTEGER :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-flush-transmit "midiflushxmit" :SOURCE) NIL :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-flush-receive "midiflushrecv" :SOURCE) NIL :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION 
(ff-midi-hush "midihush" :SOURCE)
                                 NIL :RESULT-TYPE :INTEGER
                                 :LANGUAGE :C) 
(FOREIGN:DEFINE-FOREIGN-FUNCTION
 (ff-midi-all-notes-off "midiallnotesoff" :SOURCE) ((ARG-1 :INTEGER))
                                 :RESULT-TYPE :INTEGER :LANGUAGE :C) 

(defun ff-midi-close ()
  (ff-midi-close-port (ffi:make-alien-object 0 'alien)))
