;;; -*- mode: lisp; syntax: common-lisp; package: common-music; base: 10 -*-

(in-package :common-music)

(require :foreign)

(defun fortran-entry-point (string)
  (ff:convert-to-lang string :language :fortran))

(defun c-entry-point (string)
  (ff:convert-to-lang string :language :c))

(defconstant +ff-midi-success+ 0
  "Foreign function success value.")

(defvar *port-names*  '((:a a 1 :ttyd1 ttyd1) (:b b 2 :ttyd2 ttyd2)))

(defun ff-midi-find-port (name)
  (and (find name *port-names* :test #'member)
       name))

(defun ff-midi-port-id (port)
  (position port *port-names* :test #'member))

(defconstant +midi-read-hook-index+ 0)

(ff:defun-c-callable ff-midi-read-hook ((event :fixnum) (time :fixnum))
  (declare (special *midi-read-hook*)(optimize (speed 3)(safety 0)))
  (when *midi-read-hook*
      (funcall (the function *midi-read-hook*)
               (the fixnum event) (the fixnum time))))

(ff:register-function 'ff-midi-read-hook +midi-read-hook-index+)

(ff:defforeign 'ff-midi-open :entry-point (c-entry-point "midiopen") :prototype t
               :arg-checking nil :arguments '(fixnum) :return-type :fixnum)
(ff:defforeign 'ff-midi-close-port :entry-point (c-entry-point "midiclose")
               :arg-checking nil :arguments '(integer) :return-type :fixnum)
(ff:defforeign 'ff-midi-start-timer :entry-point (c-entry-point "midistarttimer")
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-stop-timer :entry-point (c-entry-point "midistoptimer")
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-get-time :entry-point (c-entry-point "midigettime")
               :arg-checking nil :prototype t :arguments '(array)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-set-time :entry-point (c-entry-point "midisettime")
               :arg-checking nil :prototype t :arguments '(fixnum)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-set-quanta-size :entry-point (c-entry-point "midisetquantasize")
               :arg-checking nil :prototype t :arguments '(fixnum) 
               :return-type :fixnum)
(ff:defforeign 'ff-midi-read-messages :entry-point (c-entry-point "midireadmessages")
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-write-message :entry-point (c-entry-point "midiwritemessage")
               :arg-checking nil :prototype t :arguments '(fixnum fixnum)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-flush-transmit :entry-point (c-entry-point "midiflushxmit")
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-flush-receive :entry-point (c-entry-point "midiflushrecv")
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-hush :entry-point (c-entry-point "midihush")
               :arg-checking nil :arguments '() :return-type :fixnum)	       
(ff:defforeign 'ff-midi-all-notes-off :entry-point (c-entry-point "midiallnotesoff")
               :prototype t :arg-checking nil :arguments '(fixnum)
               :return-type :fixnum)

(defun ff-midi-close ()
  (ff-midi-close-port 0))