#pragma once

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <signal.h>

extern void semdec(int semid, ushort semnr, char* errorstr, struct sembuf *ops);
extern void seminc(int semid, ushort semnr, char* errorstr, struct sembuf *ops); 

#define wait_request_1(type,ops) semdec(semid,type,"Sender request check",ops)
#define lock_1(object,ops) semdec(semid,object,"Lock",ops)
#define request_1(type,ops) seminc(semid,type,"Sender request",ops)
#define unlock_1(object,ops) seminc(semid,object,"Unlock",ops)

#define wait_request(type) wait_request_1(type,my->semops)
#define lock(object)       lock_1(object,my->semops) 
#define request(type)      request_1(type,my->semops)
#define unlock(object)     unlock_1(object,my->semops)

#define mutex_lock   lock
#define mutex_unlock unlock

/*
       Semaphore 0 : Nr. of outstanding MIDI send requests
       Semaphore 1 : Nr. of outstanding MIDI messages received
       Semaphore 2 : MIDI printout stream busy;
       
*/

#define SEND_MIDI        0
#define RECEIVE_MIDI     1
#define PRINTMIDI        2

extern int	semid;
extern int	procgroup;
