#include "semaphores.h"
#include <stdio.h>
#include "unix-flavors.h"

int	semid;
int	procgroup;

static char *semaphore_name[] = {

   "SEND_MIDI",
   "RECEIVE_MIDI",
   "PRINTMIDI",
   "SEND_IPC",
   "PLAY_SND",
   "PLAY_MIDI_SOUND",
   "SEND_REMOTE_MIDI"
};

void semdec(int semid, ushort semnr, char* errorstr, struct sembuf *ops) 
{

#ifdef DEBUG
  int opresult;
  fprintf(stderr,"%s - ID: %d Nr: %u\n", errorstr, semid, semnr);
#endif
  ops[0].sem_num = semnr;
  ops[0].sem_op = -1;
  ops[0].sem_flg = SEM_UNDO;
#ifdef DEBUG
  if ((opresult = semop (semid, ops, 1)) == -1) {
#else
  if (semop (semid, ops, 1) == -1) {
#endif
    fprintf(stderr,"%s semop\n", errorstr);
    killpg (procgroup, 2);
    exit (1);
  }
#ifdef DEBUG_WAIT
  else
    fprintf(stderr,"%s %s\n", errorstr,semaphore_name[semnr]); /*, opresult);*/
#endif
}

void seminc(int semid, ushort semnr, char* errorstr, struct sembuf *ops) 
{

#ifdef DEBUG
  int opresult;
  fprintf(stderr,"%s - ID: %d Nr: %u\n", errorstr, semid, semnr);
#endif
  ops[0].sem_num = semnr;
  ops[0].sem_op = 1;
  ops[0].sem_flg = SEM_UNDO;
#ifdef DEBUG
  if ((opresult = semop (semid, ops, 1)) == -1) {
#else
  if (semop (semid, ops, 1) == -1) {
#endif
    fprintf(stderr,"%s semop\n", errorstr);
    killpg (procgroup, 2);
    exit (1);
  }
#ifdef DEBUG_REQUEST
  else
    fprintf(stderr,"%s %s\n", errorstr,semaphore_name[semnr]); /*, opresult);*/
#endif
}
