#pragma once
#include <midi.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include "unix-flavors.h"

#define CHANNEL_MESSAGE(x)  ((x).mm.msgbuf)
#define SYSEX_MESSAGE(x)    ((x).mm.sysexbuf)

#define MIprogramNr MIbyte1
#define MIbend(msg) (((MIbyte2(msg) << 2) | (MIbyte1(msg) >> 5)) + (MIbyte1(msg) & 0x1))

#define SMPTEnibble(msg) ((MIbyte1(msg) >> 4) & 0xF)
#define SMPTEvalue(msg)	 (MIbyte1(msg) & 0xF)
#define SMPTEfprintf(s,smpte) fprintf(s, "SMPTE %d %d %d %d", (int)smpte[3], (int)smpte[2], (int)smpte[1], (int)smpte[0])


extern void MIfree(MIevent*);

typedef struct MIlist {
  MIevent* event;
  struct MIlist* next;
} MIevent_cell, *MIevent_list;

extern MIevent_list cdr(MIevent_list);
extern MIevent*     car(MIevent_list);

typedef struct MIqueue {
  struct sembuf  lock_op;
  struct sembuf  unlock_op;
  int           MIq_lock;
  MIevent_list  events;
  MIevent_list  first_event;
  MIevent_list  last_event;
  MIevent_list  first_free;
  MIevent_list  first_recyclable;
  int           length;
  BOOL          close;
  char          *name;
} MIevent_queue;
     


MIevent_list MIlist_alloc();

extern MIevent_queue *MIQnew(int,BOOL shared);
extern MIevent_list   MIQpush(MIevent_queue *, MIevent *);
extern MIevent       *MIQpop(MIevent_queue *);
extern void           MIQpopfree(MIevent_queue *);
extern MIevent       *MIQhead(MIevent_queue *);
extern MIevent       *MIQreserve(MIevent_queue *);
extern MIevent_list   MIQrecycle(MIevent_queue *, MIevent *);
extern MIevent_list   MIQextend(MIevent_queue *);
extern int            MIQlength(MIevent_queue *);
extern BOOL           MIQlock(MIevent_queue *);
extern BOOL           MIQunlock(MIevent_queue *);
extern void           MIQrelease(MIevent_queue *);
extern char          *MIQname(MIevent_queue *q);
extern void           MIQset_name(MIevent_queue *q, char *name);

#define  MIQclose(q)  (q->close = YES)
#define  MIQclosed(q) (q->close == YES)
#define  MIQclose_done(q)  (q->close = NO)
MIevent_list MIQalloc(MIevent_queue *);
