#include "midibuffer.h"
#include <stdio.h>

MIevent_list MIcdr(MIevent_list list)
{
  if (list)
    return list->next;
}

MIevent *MIcar(MIevent_list list)
{
  if (list)
    return list->event;
  else {
    perror("Attempt to take the CAR of NIL\n");
    exit(-1);
  }
}

MIevent *MIcons(MIevent *msg,MIevent_list list)
{
  MIevent_list  result;

  result = MIlist_alloc();
  result->event = msg;
  result->next  = list;
  return result;
}


MIevent *MIQhead(MIevent_queue *q)
{
  if (q->first_event) {
#ifdef DEBUG0
   fprintf(stderr,"MIQhead: %ld\n", q->first_event->event);
#endif    
   return q->first_event->event;
 }
}

void MIfree (MIevent *event)
{
  if ((event->t == MISYSEX) && SYSEX_MESSAGE(*event)) 
    free(SYSEX_MESSAGE(*event));
  free(event);
}

MIevent *MIQpop(MIevent_queue *q)
{
  MIevent_list  fe,next,last;
  MIevent *ev;

#ifdef DEBUG0
   fprintf(stderr,"IN MIQpop - length: %d\n",MIQlength(q));
#endif
  fe = q->first_event;
  if (fe) {
    if (fe == q->last_event) {
#ifdef DEBUG0
   fprintf(stderr,"Popped event was the only one\n");
#endif
      q->first_event = (MIevent_list) NULL;
      q->last_event  = (MIevent_list) NULL;
    } else 
      q->first_event = fe->next;
    fe->next = q->first_free;
    q->first_free = fe;
    ev = fe->event;
    fe->event = (MIevent *) NULL;
    q->length--;
  }
#ifdef DEBUG0
   fprintf(stderr,"OUT MIQpop - length: %d\n",MIQlength(q));
#endif    
#ifdef DEBUG_BUFFER
   fprintf(stderr,"MIQpop: %ld\n", fe);
#endif
   if (fe) 
     return ev;
   else
     return (MIevent *) NULL;
}

void MIQpopfree(MIevent_queue *q)
{
  MIevent_list  fe,next,last;
  MIevent       *recycle;
  
#ifdef DEBUG0
   fprintf(stderr,"IN MIQpopfree - length: %d\n",MIQlength(q));
#endif
  fe = q->first_event;
  if (fe) {
    if (fe == q->last_event) {
#ifdef DEBUG0
   fprintf(stderr,"Popped event was the only one\n");
#endif
      q->first_event = (MIevent_list) NULL;
      q->last_event  = (MIevent_list) NULL;
    } else 
      q->first_event = fe->next;
    fe->next = q->first_recyclable;
    q->first_recyclable = fe;
    recycle = fe->event;
    if (recycle->t == MISYSEX && SYSEX_MESSAGE(*recycle)) 
      free(SYSEX_MESSAGE(*recycle));
    q->length--;
  }
#ifdef DEBUG0
   fprintf(stderr,"OUT MIQpopfree - length: %d\n",MIQlength(q));
#endif    
}

MIevent_list MIlist_alloc()
{
   MIevent_list  result;

   result = (MIevent_list) malloc(sizeof(MIevent_cell));
   /*result->event = (MIevent *) malloc(MSGBUFFERSIZE); */
   /*result->next = (MIevent_list) NULL;*/
}

MIevent_list MIQextend(MIevent_queue *q)
{ 
  MIevent_list  next;

  next = MIlist_alloc();
  next->next = q->first_free;
  q->first_free = next;
  /*q->last_event->next = next for moebius */
  return next;
} 

MIevent_list MIQrecycle(MIevent_queue *q, MIevent* event)
{
  MIevent_list  recycle_cell;
    
  recycle_cell = q->first_free;
  if (recycle_cell) {
    recycle_cell->event = event;
    q->first_free = recycle_cell->next;
    recycle_cell->next = q->first_recyclable;
    q->first_recyclable = recycle_cell;
    if ((event->t == MISYSEX) && SYSEX_MESSAGE(*event)) 
      free(SYSEX_MESSAGE(*event));    
  } else
    MIfree(event);
  return recycle_cell;
}

MIevent *MIQreserve(MIevent_queue *q)
{
  MIevent       *recycle;
  MIevent_list  recycle_cell;
  
#ifdef DEBUG
   fprintf(stderr,"IN MIQreserve - length: %d\n",MIQlength(q));
#endif
  recycle_cell = q->first_recyclable;
  if (recycle_cell) {
    recycle = recycle_cell->event;
    q->first_recyclable = recycle_cell->next;
    recycle_cell->next = q->first_free;
    q->first_free = recycle_cell;
  } else
    recycle = (MIevent *) malloc(sizeof(MIevent));
#ifdef DEBUG_BUFFER
  fprintf(stderr,"OUT MIQreserve - length: %d buffer: %ld\n",MIQlength(q), recycle);
#endif    
  return recycle;
}

int MIQlength(MIevent_queue *q) 
{
  int i = 0;
  MIevent_list  cell;

  for(cell = q->first_event;cell; cell= cell->next)
    i++;
  return i;
}
  

MIevent_list MIQpush(MIevent_queue *q, MIevent* event)
{
   MIevent_list  fe,newfirst,oldlast;

#ifdef DEBUG
   fprintf(stderr,"IN MIQpush - length: %d\n",MIQlength(q));
#endif
   fe = q->first_free;
   if (fe)
      q->first_free = fe->next;
   else
     fe = MIlist_alloc();
/*   fe->next = (MIevent_list) NULL;*/
   fe->event = event;
   oldlast = q->last_event;
   if (oldlast)
     oldlast->next = fe;
   else 
     q->first_event = fe;
   q->last_event = fe;
   q->length++;
#ifdef DEBUG
   fprintf(stderr,"OUT MIQpush - length: %d\n",MIQlength(q));
#endif
   return fe;
 }
/*
MIevent_list MIQalloc(MIevent_queue *q)
{
  MIevent_list  fe;
  
  fe = q->first_event;
  if (fe) {
    if (fe->next == q->first_free) 
      q->first_event = (MIevent_list) NULL;
    else
       q->first_event = fe->next;
    return q->first_event->event;
  }
}
*/

void MIQrelease(MIevent_queue *q)
{
  MIevent_list nextcell,cell;

  
  for(cell=q->first_free;cell;cell=nextcell) {
    nextcell = cell->next;
    free(cell);
  }
  for(cell=q->first_recyclable;cell;cell=nextcell) {
    nextcell = cell->next;
    MIfree(cell->event);
    free(cell);
  }
  q->first_free = (MIevent_list) NULL;
  q->first_recyclable = (MIevent_list) NULL;
}

static struct sembuf lock_op   = { 0, -1, 0};
static struct sembuf unlock_op = { 0,  1, 0};

MIevent_queue *MIQnew(int size, BOOL shared) 
{
  MIevent_list prevcell,nextcell = (MIevent_list) NULL;
  MIevent_queue *result;
  int i;
  static short lock_initial_state = 1;
  result = (MIevent_queue *) malloc(sizeof(MIevent_queue));
  result->name = "";
  result->first_event = (MIevent_list) NULL;
  result->last_event = (MIevent_list) NULL;
  result->first_recyclable = (MIevent_list) NULL;
  prevcell =  MIlist_alloc();
  result->first_free =  prevcell;
/*  result->last_free =  prevcell;*/
  
  for(i=1;i<size;i++) {
    nextcell = MIlist_alloc();
    prevcell->next = nextcell;
    prevcell = nextcell;
  }
  prevcell->next = (MIevent_list) NULL;

  if (shared) {
    if ((result->MIq_lock = semget (IPC_PRIVATE, 1, (SEM_A | SEM_R))) == -1) {
      perror ("Could not create a lock for a MIQueue ");
      MIQrelease(result);
      free(result);
      return (MIevent_queue *) 0;
    }
    if (semctl (result->MIq_lock, 0, SETALL, (ushort *) &lock_initial_state) == -1) {
      perror ("Could not set the initial value of a MIQueue lock ");
      MIQrelease(result);
      free(result);
      return (MIevent_queue *) 0;      
    } 
  }
  MIQclose_done(result);
  return result;
}

char *
MIQname(MIevent_queue *q)
{
  return q->name;
}

void MIQset_name(MIevent_queue *q, char *name)
{
  q->name = name;
}

BOOL           MIQlock(MIevent_queue *q)
{
  #ifdef DEBUG
  int opresult;
  fprintf(stderr,"Locking MIQueue %s(%ld)\n", q->name, q);
  if ((opresult = semop (q->MIq_lock, &lock_op, 1)) == -1) {
#else
  if (semop (q->MIq_lock, &lock_op, 1) == -1) {
#endif
    fprintf(stderr,"Could not lock MIQueue %s(%ld)\n", q->name,q);
    return -1;
  }
#ifdef DEBUG_WAIT
  else
    fprintf(stderr,"Lock of MIQueue %s(%ld) suceeded\n", q->name, q);
#endif
  return KERN_SUCCESS;
}

BOOL           MIQunlock(MIevent_queue *q)
{
  #ifdef DEBUG
  int opresult;
  fprintf(stderr,"Unlocking MIQueue %s(%ld)\n", q->name, q);
  if ((opresult = semop (q->MIq_lock, &unlock_op, 1)) == -1) {
#else
  if (semop (q->MIq_lock, &unlock_op, 1) == -1) {
#endif
    fprintf(stderr,"Could not unlock MIQueue %s(%ld)\n", q->name,q);
    return  -1;
  }
#ifdef DEBUG_WAIT
  else
    fprintf(stderr,"Unlock of MIQueue %s(%ld) suceeded\n", q->name, q);
#endif
  return KERN_SUCCESS;
}
