#pragma once

#include "semaphores.h"
#include <sys/time.h>
#include <unistd.h>
#include <task.h>
#include "taskblocks.h"
/* #include <midi.h> */
#include <midiio.h>
#include "MIPortedQueue.h"

typedef struct {
  MIPortedQueue *queue;
  fd_set        fdset;
  int nready;
  kern_return_t result;  
} midi_notifier_block;

typedef struct  midi_daemon_block {
  MIPortedQueue *queue;
  MIevent       *event;
  fd_set        fdset;
  int nready;
  kern_return_t result; 
  int i;
  BOOL must_close;
  BOOL *to_close;
  int smpte[4];
  BOOL smpteok[8];
  struct sembuf *semops;
  struct sigaction *act;
  struct sigaction *old_act;
  sigset_t mask;
  sigset_t old_mask;         /* Warning: No nested undo_on_signal support */
  sigaction_stack *actions;
  int retval;
} midi_daemon_block;

extern BOOL send_midi(MIevent_queue *q,MIevent *the_event);
extern void midi_sender_process_request(midi_daemon_block *my);
extern void midi_sender(midi_daemon_block *my);
extern void midi_receiver(midi_daemon_block *my);
extern void midi_receive_callback(midi_daemon_block *my);
extern midi_daemon_block *MTB_new(MIPortedQueue *q);

extern void **taskblocks;
extern volatile int kids;
extern volatile int  ntasks;
extern void init_threads();
extern std_task_block *my;
extern int maxtasks;

# if defined(_BSD_COMPAT) || defined(_BSD_SIGNALS) 
#define HANDLER_RETURN_TYPE  int
#else
#define HANDLER_RETURN_TYPE  void
#endif

#define HANDLER_TYPE   HANDLER_RETURN_TYPE (*)(int)
#define HANDLER(x)     HANDLER_RETURN_TYPE (*x)(int)

#define next_handler(sig) ((* ((HANDLER_TYPE) (SASpop(my->actions)->sa_handler)))(sig))
extern tid_t create_task (char *name, void (*entry)(), void *arg,int sched);
extern HANDLER_RETURN_TYPE sighup_handler (int sig);

#define MASK_ALL ((sigset_t) -1)

extern void init_std_sigaction(struct sigaction *act,int sig,HANDLER_TYPE);

extern int std_sigaction(int sig,HANDLER_TYPE, struct sigaction *act);
#define push_sigaction(sig,act) {                                         \
				 my->old_act = SASreserve(my->actions);   \
				 for(;sigaction(sig,act,my->old_act);     \
				     sigaction(sig,act,my->old_act));     \
				 SASpush(my->actions,my->old_act);        \
				   }

#define push_handler(sig,handler) {                                       \
				 my->act = SASreserve(my->actions);       \
				 init_std_sigaction(my->act,sig,handler); \
				 push_sigaction(sig,my->act);             \
				  }

#define pop_sigaction(sig,act) {                                          \
			        my->old_act = SASpop(my->actions);        \
			        for(;sigaction(sig,my->old_act,act);      \
			            sigaction(sig,my->old_act,act));      \
			       } 

#define undo_on_signal_masking(sig,handler,handler_sigmask_var,mask_var,expr) {   \
        my->act = SASreserve(my->actions);                                \
	my->act->sa_handler = handler;                                    \
        my->act->sa_mask    = sigmask(sig) || (handler_sigmask_var);      \
        my->act->sa_flags   = 0;                                          \
        my->mask = sigmask(sig) || (mask_var);				  \
	for(;sigprocmask(SIG_BLOCK,&(my->mask),&(my->old_mask));          \
             sigprocmask(SIG_BLOCK,&(my->mask),&(my->old_mask)))          \
	  perror("Problem with sigprocmask, trying again...\n");          \
	expr;                                                             \
	push_sigaction(sig,my->act)                                       \
	for(;sigprocmask(SIG_SETMASK,&(my->old_mask),NULL);               \
             sigprocmask(SIG_SETMASK,&(my->old_mask),NULL))               \
	  perror("Problem with sigprocmask, trying again...\n");          \
  }                        

#define undo_on_signal(sig,handler,expr) \
        undo_on_signal_masking(sig,handler,0,MASK_ALL,expr)

#define undo_on_sighup(handler,expr) undo_on_signal(SIGHUP,handler,expr);

#define unhandling_signal_masking(sig,mask_var,expr) {                    \
        my->mask = sigmask(sig) || (mask_var);	                          \
	for(;sigprocmask(SIG_BLOCK,&(my->mask),&(my->old_mask));          \
             sigprocmask(SIG_BLOCK,&(my->mask),&(my->old_mask)))          \
	  perror("Problem with sigprocmask, trying again...\n");          \
	expr;                                                             \
	pop_sigaction(sig,my->act)                                        \
	for(;sigprocmask(SIG_SETMASK,&(my->old_mask),NULL);               \
             sigprocmask(SIG_SETMASK,&(my->old_mask),NULL))               \
	  perror("Problem with sigprocmask, trying again...\n");          \
        SASrecycle(my->actions,my->act);		                  \
  }   

#define unhandling_signal(sig,expr) unhandling_signal_masking(sig,MASK_ALL,expr)

#define unhandling_sighup(expr) unhandling_signal(SIGHUP,expr)
