#include <sys/types.h>
#include <sys/SA.h>
#include <sys/sem.h>
#include <signal.h>
#include "unix-flavors.h"

typedef struct sigaction_list {
  struct sigaction *action;
  struct sigaction_list  *next;
} sigaction_cell, *sigaction_list;

extern sigaction_list SAcdr(sigaction_list);
extern sigaction *SAcar(sigaction_list);

typedef struct SAqueue {
  sigaction_list  actions;
  sigaction_list  first_action;
  sigaction_list  last_action;
  sigaction_list  first_free;
  sigaction_list  first_recyclable;
} sigaction_queue;
     


sigaction_list SAlist_alloc();

extern struct sigaction_queue *SAQnew(int,BOOL shared);
extern struct sigaction       *SAQhead(sigaction_queue *);
extern sigaction_list          SAQpush(sigaction_queue *, struct sigaction *);
extern struct sigaction       *SAQpop(sigaction_queue *);
extern struct sigaction       *SAQpopkeep(sigaction_queue *);
extern struct sigaction       *SAQreserve(sigaction_queue *);
extern sigaction_list          SAQrecycle(sigaction_queue *, struct sigaction *);
extern sigaction_list          SAQextend(sigaction_queue *);
extern int                     SAQlength(sigaction_queue *);
extern void                    SAQrelease(sigaction_queue  *q);

sigaction_list SAQalloc(sigaction_queue *);
