#pragma once

#include <signal.h>
#include "unix-flavors.h"

typedef struct SA_list {
  struct sigaction *action;
  struct SA_list  *next;
} sigaction_cell, *sigaction_list;

extern sigaction_list SAcdr(sigaction_list);
extern struct sigaction *SAcar(sigaction_list);

typedef struct SAstack {
  sigaction_list  actions;
  sigaction_list  first_action;
  sigaction_list  last_action;
  sigaction_list  first_free;
  sigaction_list  first_recyclable;
} sigaction_stack;
     


sigaction_list SAlist_alloc();

extern sigaction_stack        *SASnew(int);
extern struct sigaction       *SAShead(sigaction_stack *);
extern sigaction_list          SASpush(sigaction_stack *, struct sigaction *);
extern struct sigaction       *SASpop(sigaction_stack *);
extern struct sigaction       *SASpopkeep(sigaction_stack *);
extern struct sigaction       *SASreserve(sigaction_stack *);
extern sigaction_list          SASrecycle(sigaction_stack *, struct sigaction *);
extern sigaction_list          SASextend(sigaction_stack *);
extern int                     SASlength(sigaction_stack *);
extern void                    SASrelease(sigaction_stack  *q);

sigaction_list SASalloc(sigaction_stack *);
