#include "SA_stack.h"
#include <stdio.h>

sigaction_list SAcdr(sigaction_list list)
{
  if (list)
    return list->next;
}

struct sigaction *SAcar(sigaction_list list)
{
  if (list)
    return list->action;
  else {
    perror("Attempt to take the CAR of NIL\n");
    exit(-1);
  }
}

struct sigaction *SAcons(struct sigaction *msg,sigaction_list list)
{
  sigaction_list  result;

  result = SAlist_alloc();
  result->action = msg;
  result->next  = list;
  return result;
}


struct sigaction *SAShead(sigaction_stack *q)
{
  if (q->first_action) {
#ifdef DEBUG0
   fprintf(stderr,"SAShead: %ld\n", q->first_action->action);
#endif    
   return q->first_action->action;
 }
}

void SAfree (struct sigaction *action)
{
  free(action);
}

struct sigaction *SASpop(sigaction_stack *q)
{
  sigaction_list  fe,next,last;
  struct sigaction       *recycle;
  
#ifdef DEBUG0
   fprintf(stderr,"IN SASpop - length: %d\n",SASlength(q));
#endif
  fe = q->first_action;
  if (fe) {
    if (fe == q->last_action) {
      q->first_action = (sigaction_list) NULL;
      q->last_action  = (sigaction_list) NULL;
    } else 
      q->first_action = fe->next;
    fe->next = q->first_recyclable;
    q->first_recyclable = fe;
    return fe->action;
  }
#ifdef DEBUG0
   fprintf(stderr,"OUT SASpop - length: %d\n",SASlength(q));
#endif
}

struct sigaction *SASpopkeep(sigaction_stack *q)
{
  sigaction_list  fe,next,last;
  struct sigaction       *recycle;
  
#ifdef DEBUG0
   fprintf(stderr,"IN SASpop - length: %d\n",SASlength(q));
#endif
  fe = q->first_action;
  if (fe) {
    if (fe == q->last_action) {
      q->first_action = (sigaction_list) NULL;
      q->last_action  = (sigaction_list) NULL;
    } else 
      q->first_action = fe->next;
    fe->next = q->first_free;
    q->first_free = fe;
    return fe->action;
  }
#ifdef DEBUG0
   fprintf(stderr,"OUT SASpop - length: %d\n",SASlength(q));
#endif
}

sigaction_list SAlist_alloc()
{
   sigaction_list  result;

   result = (sigaction_list) malloc(sizeof(sigaction_cell));
   /*result->action = (struct sigaction *) malloc(sizeof(struct sigaction)); */
   /*result->next = (sigaction_list) NULL;*/
}

sigaction_list SASextend(sigaction_stack *q)
{ 
  sigaction_list  next;

  next = SAlist_alloc();
  next->next = q->first_free;
  q->first_free = next;
  /*q->last_action->next = next for moebius */
  return next;
} 

sigaction_list SASrecycle(sigaction_stack *q, struct sigaction* action)
{
  sigaction_list  recycle_cell;
    
  recycle_cell = q->first_free;
  if (recycle_cell) {
    recycle_cell->action = action;
    q->first_free = recycle_cell->next;
    recycle_cell->next = q->first_recyclable;
    q->first_recyclable = recycle_cell;
  } else
    free(action);
  return recycle_cell;
}

struct sigaction *SASreserve(sigaction_stack *q)
{
  struct sigaction       *recycle;
  sigaction_list  recycle_cell;
  
#ifdef DEBUG
   fprintf(stderr,"IN SASreserve - length: %d\n",SASlength(q));
#endif
  recycle_cell = q->first_recyclable;
  if (recycle_cell) {
    recycle = recycle_cell->action;
    q->first_recyclable = recycle_cell->next;
    recycle_cell->next = q->first_free;
    q->first_free = recycle_cell;
  } else
    recycle = (struct sigaction *) malloc(sizeof(struct sigaction));
#ifdef DEBUG_BUFFER
  fprintf(stderr,"OUT SASreserve - length: %d buffer: %ld\n",SASlength(q), recycle);
#endif    
  return recycle;
}

int SASlength(sigaction_stack *q) 
{
  int i = 0;
  sigaction_list  cell;

  for(cell = q->first_action;cell; cell= cell->next)
    i++;
  return i;
}
  

sigaction_list SASpush(sigaction_stack *q, struct sigaction* action)
{
   sigaction_list  fe,newfirst,oldfirst;

#ifdef DEBUG
   fprintf(stderr,"IN SASpush - length: %d\n",SASlength(q));
#endif
   fe = q->first_free;
   if (fe)
      q->first_free = fe->next;
   else
     fe = SAlist_alloc();
/*   fe->next = (sigaction_list) NULL;*/
   fe->action = action;
   oldfirst = q->first_action;
   fe->next = oldfirst;
   if (!oldfirst)
     q->last_action = fe;
   q->first_action = fe;
#ifdef DEBUG
   fprintf(stderr,"OUT SASpush - length: %d\n",SASlength(q));
#endif
   return fe;
 }
/*
sigaction_list SASalloc(sigaction_stack *q)
{
  sigaction_list  fe;
  
  fe = q->first_action;
  if (fe) {
    if (fe->next == q->first_free) 
      q->first_action = (sigaction_list) NULL;
    else
       q->first_action = fe->next;
    return q->first_action->action;
  }
}
*/

void SASrelease(sigaction_stack  *q)
{
  sigaction_list nextcell,cell;

  for(cell=q->first_free;cell;cell=nextcell) {
    nextcell = cell->next;
    free(cell);
  }
  for(cell=q->first_recyclable;cell;cell=nextcell) {
    nextcell = cell->next;
    free(cell->action);
    free(cell);
  }
  q->first_free = (sigaction_list) NULL;
  q->first_recyclable = (sigaction_list) NULL;
}


sigaction_stack *SASnew(int size)
{
  sigaction_list prevcell,nextcell = (sigaction_list) NULL;
  sigaction_stack *result;
  int i;
  static short lock_initial_state = 1;

  result = (sigaction_stack *) malloc(sizeof(sigaction_stack));
  result->first_action = (sigaction_list) NULL;
  result->last_action = (sigaction_list) NULL;
  result->first_recyclable = (sigaction_list) NULL;
  prevcell =  SAlist_alloc();
  result->first_free =  prevcell;
/*  result->last_free =  prevcell;*/
  
  for(i=1;i<size;i++) {
    nextcell = SAlist_alloc();
    prevcell->next = nextcell;
    prevcell = nextcell;
  }
  prevcell->next = (sigaction_list) NULL;

  return result;
}

