#include "MIPortedQueue.h"

MIPortedQueue *
MIPortedQNew(MIevent_queue *q)
{
  MIPortedQueue *result = (MIPortedQueue *) malloc(sizeof(MIPortedQueue));

  if(q)
    result->queue = q;
  else
    result->queue =  MIQnew(1,GUARDED);

  result->nports       = 0;
  return result;
}

void
add_port(MIPortedQueue *q, MIMultiPort *port)
{
  int nports = q->nports;
  
  if (nports) {
    q->midi_port = (MIMultiPort **) realloc(q->midi_port,(nports+1) *  sizeof(MIport   *));
    q->midi_fd   = (int *)     realloc(q->midi_fd, (nports+1) *  sizeof(int));
  } else {
    q->midi_port    = (MIMultiPort **) malloc(sizeof(MIMultiPort   *));
    q->midi_fd      = (int *)  malloc(sizeof(int));
  }
  q->midi_port[nports] = port;
  q->midi_fd[nports] = MIgetfd(port->port);
  q->nports++;
}

char *
MIPQname(MIPortedQueue *q)
{
  return MIQname(q->queue);
}

void           
MIPQset_name(MIPortedQueue *q, char *name)
{
  MIQset_name(q->queue, name);
}

