#include "MIMultiPort.h"
#include "stdio.h"
#include "unix-flavors.h"

MIMultiPort *
MIMPortNew(MIport *port) 
{
  MIMultiPort *result = (MIMultiPort *) malloc(sizeof(MIMultiPort));
  
  if (port)
    result->port = port;
  else
    result->port = MInewport();
#ifdef DEBUG0
    fprintf(stderr,"New Multiport with MIDI Port: %ld\n",result->port);
#endif
  result->n_users = 0;
  return result;
}

int MImulti_open(MIMultiPort *port, char* mode, MIconfig* config)
{ 
  kern_return_t r;

  port->n_users++;
  if(port->n_users == 1) {
#ifdef DEBUG
    fprintf(stderr,"%Opening MIDI port\n");
#endif    
    r = MIopen(port->port,mode,config);
    if (r < 0) {
      perror("Cannot open MIDI port\n");
      suicide(-2);
    }
  } else
    r = KERN_SUCCESS;
  return r;
}

void MImulti_close(MIMultiPort *port)
{
  port->n_users--;
  if(port->n_users == 0) 
    MIclose(port->port);
}
