;;; -*- mode: lisp; syntax: common-lisp; package: common-music; base: 10 -*-

(in-package :common-music)

(require :foreign)

(defconstant +ff-midi-success+ 0
  "Foreign function success value.")

(defvar *port-names*  '((:a a 1) (:b b 2)))

(defun ff-midi-find-port (name)
  (and (find name *port-names* :test #'member)
       name))

(defun ff-midi-port-id (port)
  (position port *port-names* :test #'member))

(defconstant +midi-read-hook-index+ 0)

(ff:defun-c-callable ff-midi-read-hook ((event :fixnum) (time :fixnum))
  (declare (special *midi-read-hook*)(optimize (speed 3)(safety 0)))
  (when *midi-read-hook*
      (funcall (the function *midi-read-hook*)
               (the fixnum event) (the fixnum time))))
	    
(ff:register-function 'ff-midi-read-hook +midi-read-hook-index+)

(ff:defforeign 'ff-midi-open :entry-point "_midiopen" :prototype t
               :arg-checking nil :arguments '(fixnum) :return-type :fixnum)
(ff:defforeign 'ff-midi-close :entry-point "_midiclose"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-start-timer :entry-point "_midistarttimer"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-stop-timer :entry-point "_midistoptimer"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-get-time :entry-point "_midigettime"
               :arg-checking nil :prototype t :arguments '(array)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-set-time :entry-point "_midisettime"
               :arg-checking nil :prototype t :arguments '(fixnum)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-set-quanta-size :entry-point "_midisetquantasize"
               :arg-checking nil :prototype t :arguments '(fixnum) 
               :return-type :fixnum)
(ff:defforeign 'ff-midi-read-messages :entry-point "_midireadmessages"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-write-message :entry-point "_midiwritemessage"
               :arg-checking nil :prototype t :arguments '(fixnum fixnum)
               :return-type :fixnum)
(ff:defforeign 'ff-midi-flush-transmit :entry-point "_midiflushxmit"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-flush-receive :entry-point "_midiflushrecv"
               :arg-checking nil :arguments '() :return-type :fixnum)
(ff:defforeign 'ff-midi-hush :entry-point "_midihush"
               :arg-checking nil :arguments '() :return-type :fixnum)	       
(ff:defforeign 'ff-midi-all-notes-off :entry-point "_midiallnotesoff" 
               :prototype t :arg-checking nil :arguments '(fixnum)
               :return-type :fixnum)
