(in-package :common-music)

;;;
;;; Note: this clines form causes the NeXT mididriver C code to be source 
;;; included into this file.  the next-midi.c file is actually a LINK to
;;; either next-2-0-midi.c or next-3-0-midi.c, depending on what was
;;; specified in build/build.lisp. the build script will automatially
;;; remove the link file once this file is compiled.
;;; 

(clines "
#define AKCL
#include \"next-midi.c\"
")

(defconstant +ff-midi-success+ 0
  "Foreign function success value.")

(defvar *port-names*  '((:a a 1) (:b b 2)))

(defun ff-midi-find-port (name)
  (and (find name *port-names* :test #'member)
       name))

(defun ff-midi-port-id (port)
  (position port *port-names* :test #'member))

(defun midi-hook (event time)
 (declare (special *midi-read-hook*) (optimize (speed 3)(safety 0)))
 (when *midi-read-hook*
   (funcall (the function *midi-read-hook*)
            (the fixnum event) (the fixnum time))))

(defcfun "MIDI_INPUT_HOOK (msg,tim) int msg,tim;" 0
  ((midi-hook (int msg) (int tim))))

(defentry ff-midi-open (int) (int midiopen))
(defentry ff-midi-close () (int midiclose))
(defentry ff-midi-start-timer () (int midistarttimer))
(defentry ff-midi-stop-timer () (int midistoptimer))
(defentry ff-midi-get-time (object) (int midigettime))
(defentry ff-midi-set-time (int) (int midisettime))
(defentry ff-midi-set-quanta-size (int) (int midisetquantasize))
(defentry ff-midi-read-messages () (int midireadmessages))
(defentry ff-midi-write-message (int int) (int midiwritemessage))
(defentry ff-midi-flush-transmit () (int midiflushxmit))
(defentry ff-midi-flush-receive () (int midiflushrecv))
(defentry ff-midi-hush () (int midihush))
(defentry ff-midi-all-notes-off (int) (int midiallnotesoff))
