;;; -*- Syntax: Common-Lisp; Mode: Lisp; Package: common-music; Base: 10 -*-

(in-package :common-music)

;;;
;;; This example assumes that you have already compiled and loaded 
;;; real-time.lisp.  Compile and load this file and then call the
;;; function simp with some number of notes to perform, ie:  (simp 20)
;;;

(defun simp (len &optional (rhythm 250))
  (unless (integerp rhythm)
    (error "Rhythm ~s not integer milliseconds!" rhythm))
  (with-real-time-scheduling ()
    (schedule-message (make-note-on 0 60 60)          ; message
                      0                               ; time
                      (let ((n 0))                    ; function
                        #'(lambda (message time)
                            (values message
                                   (if (< (incf n) len)
                                       (+ time rhythm)
                                     nil)))))
    (schedule-message (make-note-off 0 60 127)        ; message
                      250                             ; time
                      (let ((n 0))                    ; function
                        #'(lambda (message time)
                            (values message
                                   (if (< (incf n) len)
                                       (+ time rhythm)
                                     nil)))))))