;;; **********************************************************************
;;; Copyright (c) 89, 90, 91, 92, 93 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; send to: hkt@zkm.de
;;; **********************************************************************

(in-package :common-music)

;;;
;;; an expr holds a lisp form to be evaluated by Item.
;;;

(defclass expr ()
  ((function :initarg :function)))  ; funcalled to return value

(defmethod item ((object expr))
  (values (funcall (slot-value object 'function))
          +end-of-stream-token+))

(defmacro expr (form)
  `(make-instance 'expr :function (function (lambda () ,form))))

(defmacro fn (form)
  `(make-instance 'expr :function ,form))

(defprop expr :item-expand t)     ; constructors should macroexpand expr and fn
(defprop fn   :item-expand t) 


#|
(let* ((x 0)
       (s (items 1 (expr (incf x)) )))
  (doitems (i s :periods 10)
    (print i)))
|#


