;;;
;;; split-channels splits midi data in the specified container into seperatly
;;; time lined threads according to the channel info. a merge of the resulting
;;; threads would therefore produce exactly the same output as the original
;;; thread itself, except now you have each channel in its own thread.  if
;;; recurse is true (the default), then  subthreads are recursively processed.
;;; 

(in-package :stella)

(defun split-channels (thread &key (copy t) (recurse t))
  (let ((channels (make-array 16 ))
        (timeinfo (make-array 16 :initial-element 0))
        (timeline 0.0)
        (results ())
        closure)
    (setf closure
      #'(lambda (x)
          (when (typep x 'midi-note)
            (when copy (setf x (copy-object x)))
            (let* ((chan (slot-value x 'channel))
                   (last (aref timeinfo chan)))
               (if (aref channels chan)
                   (let ((obj (car (aref channels chan))))
                     (setf (slot-value obj 'rhythm)
                           (- timeline last))
                     (push x (aref channels chan)))
                 (setf (aref channels chan)
                   (if (> timeline 0.0)
                       (list x (make-instance 'rest :rhythm timeline))
                     (list x))))
               (setf (aref timeinfo chan) timeline)))
          (incf timeline (slot-value x 'rhythm))))

    ;; do the work    
    (map-object closure thread :level recurse)

    ;; for each channel found, set last rhythm and make new thread
    (dotimes (i 16)
      (when (aref channels i)
        (let ((obj (car (aref channels i))))
          (setf (slot-value obj 'rhythm)
            (- timeline (aref timeinfo i))))
        (let* ((lab (gentemp (format nil "~A-chan-~A-" 
                                     (object-name thread) i)))
               (new (make-object (list 'thread lab))))
          (add-objects (nreverse (aref channels i)) new nil)
          (push new results))))
    (nreverse results)))
