(in-package :cm)

(export '(one-over-f-noise))

(when (find-package :Stella)
  (import (list (find-symbol "ONE-OVER-F-NOISE")) :Stella))

;;; Some helper functions -- should probably be in an flet or unfolded
;;; into one big function.

(defun one-over-f-aux3 (low-bound high-bound)
  (+ (random (- high-bound low-bound)) low-bound))

(defun one-over-f-aux2 (r i half-range)
  (setf (apply #'aref r (list i))
        (one-over-f-aux3 (- half-range) half-range)))

(defun one-over-f-aux (n power-of-2 r half-range)
  (let ((sum 0))
    (loop for i from 0 to (- power-of-2 1) do
          (let ((pow (expt 2 i)))
            (if (not (equal (/ n pow) (/ (- n 1) pow)))
                (one-over-f-aux2 r i half-range))
            (setf sum (+ sum (aref r i)))))
    sum))

;;; One over f noise generator. Returns a list of size 2^power-of-2 of
;;; numbers from -1 to 1
;;; Based on Gardner (1978) and Dick Moore (1988?)

(defun one-over-f-noise (power-of-2)
  (let*  ((rtn    nil)
          (length (expt 2 power-of-2))
          (half-range  (/ 1.0 power-of-2))
          (r (make-array (list power-of-2))))  ; bug: should free array
    (loop for n from 0 to (- length 1) do
          (push (one-over-f-aux n power-of-2 r half-range) rtn))
    rtn))


