(in-package :stella)

(defun naturalize (container)
  (flet
    ((naturalize-aux (note classes)
     (let* ((name (symbol-name note))
            (class (elt name 0))
            (accidental (car (member (elt name 1) '(#\S #\F #\N))))
            (octave (or (subseq name (if accidental 2 1)) "4"))
            (spec (assoc class classes :test #'char=))
            (entry (assoc octave (cdr spec) :test #'string=)))
      (unless entry
        (setf entry (list octave))
        (push entry (cdr spec)))
      (if accidental
          (progn (setf (cdr entry) accidental)
                 note)
        (if (not (cdr entry))
            note
          (if (char= (cdr entry) #\N)
              note
            (progn
              (setf (cdr entry) #\N)
              (find-symbol (concatenate 'string (string class) 
                                        "N" octave)))))))))

    (let ((classes (loop for x in '(#\A #\B #\C #\D #\E #\F #\G) 
                         collect (list x)))
          (pos 0))
      (mapr #'(lambda (x)
                  (let ((y (careful-slot-value x 'note)))
                    (when (and y (symbolp y))
                      (let ((z (naturalize-aux y classes)))
                        (unless (eq z y)
                          (format t  "~S	~A -> ~A~%" pos y z)
                        (setf (slot-value x 'note) z))))
                     (incf pos)))
              container))
    container))