;;; **********************************************************************
;;; Copyright (c) 89-93, 94 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; address email to: hkt@zkm.de
;;; **********************************************************************

#+(or cltl2 lispworks clisp) 
(progn
  (defpackage :COMMON-MUSIC
    (:use #-(and clisp pcl) :COMMON-LISP #+(and clisp pcl) :LISP
         :TL
          #+(or pcl mcl lispworks clisp) :WALKER
          #+pcl :PCL
          #+(or (and excl cltl2) lispworks) :CLOS
          #+clm :CLM
    ) 
    #+(and clisp pcl) (:import-from "PCL" "PRINTING-RANDOM-THING")
    (:nicknames :cm)
    #+clisp (:shadow "SHELL"))
  (in-package :common-music))

#-(or cltl2 lispworks clisp) 
(in-package :common-music
            :use (list (find-package ':lisp)
                       (find-package ':walker)
                 #+pcl (find-package ':pcl)  ; aclpc has clos but not walk
                       (find-package ':tl)
                 #+clm (find-package ':clm))
            :nicknames '(:cm))

(defvar *common-music-directory* 
  #+excl (directory-namestring excl::*source-pathname*)
  #+mcl  (directory-namestring ccl:*loading-file-source-file*)
  #+akcl (directory-namestring si:*load-pathname*)
  #+lispworks (directory-namestring *load-pathname*)
  ;; this horrible hack is our last ditch effort at finding cm's source
  ;; directory. works if the user is loading via build.lisp, the normal case.
  #+clisp (directory-namestring *load-pathname*)
  #-(or excl akcl mcl lispworks clisp)
  (let ((dir (find-symbol "CM-DIRECTORY"
                          (or (find-package :user)
                              (find-package :common-lisp-user)))))
    (if dir 
        (symbol-value dir)
      (error "~%The system cannot automatically determine the source directory for Common Music in this Lisp port.  Edit the file common-music.lisp and set the variable *common-music-directory* to the appropriate directory namestring."))))
  
(defvar *common-music-package* (find-package :common-music))
(defvar *common-music-version* "Common Music 30-April-94")

#+cmn
(import '(cmn::size cmn::metronome))

#+(and excl cltl2)
(import '(clos::walk-form clos::variable-lexical-p clos::variable-special-p
	  clos::variable-globally-special-p))
	  
#+aclpc
(import '(walker::walk-form walker::variable-lexical-p 
          walker::variable-special-p walker::variable-globally-special-p))
	  
#+pcl
(eval-when (compile load eval)
  #-clisp (import '(pcl::printing-random-thing))
  (cond ((string= pcl::*pcl-system-date* "March 92 PCL (2c)")
         (import '(pcl::class-prototype pcl::class-slots
                   pcl::allocate-instance pcl::standard-class 
                   pcl::validate-superclass pcl::class-precedence-list	    
                   pcl::class-direct-superclasses pcl::class-direct-subclasses 
                   pcl::class-direct-slots pcl::finalize-inheritance	    
                   pcl::class-finalized-p pcl::class-direct-slots	    
                   pcl::slot-value-using-class pcl::slot-boundp-using-class
                   pcl::slot-makunbound-using-class pcl::slot-definition-name
                   pcl::slot-definition-readers	pcl::slot-definition-writers
                   pcl::slot-definition-initargs pcl::slot-definition-initform
                   pcl::slot-definition-initfunction 
                   pcl::slot-definition-allocation
                   pcl::slot-definition-type)
                 (find-package :cm)))
        ((string= pcl::*pcl-system-date* "September 16 92 PCL (f)")
         nil)
        (t
         (error "~&Common Music has only been tested in March 92 PCL (2c) and September 16 92 PCL (f). It may work in your version of PCL, but then again it may not.  The easiest thing to do is to ftp March 92 PCL from guido.zkm.de and install that.  Otherwise, edit the files: common-music.lisp and stella/pkg.lisp to get rid of this error message code, and then figure out the import statements that you need for your version of pcl.")))
)

#+mcl
(progn
  (import '(ccl:class-direct-superclasses ccl:class-direct-subclasses 
            ccl:class-prototype ccl:class-precedence-list
            ccl:slot-definition-name))
  (defun class-slots (class) (ccl:class-instance-slots class))
  (defun class-direct-slots (class) (ccl:class-direct-instance-slots class))
  (defun slot-definition-initargs (slot) (third slot))
  (defun slot-definition-initform (slot) 
    (and (second slot) 
         (if (functionp (second slot))
             (funcall (second slot))
           (if (consp (second slot))
               (car (second slot))
            nil))))
  (defun slot-definition-readers (slot)
    (declare (ignore slot))
    (error "slot-definition-readers undefined in mcl"))
  (defun slot-definition-writers (slot) 
    (declare (ignore slot))
    (error "slot-definition-writers undefined in mcl"))
  (defmacro slot-value-using-class (class instance slot)
    (declare (ignore class))
    `(slot-value ,instance (ccl:slot-definition-name ,slot)))
  (defmacro slot-boundp-using-class (class instance slot)
    (declare (ignore class))
    `(slot-boundp ,instance (ccl:slot-definition-name ,slot)))
  (defmacro slot-makunbound-using-class (class instance slot)
    (declare (ignore class))
    `(slot-makunbound ,instance (ccl:slot-definition-name ,slot)))
)

#+(and clisp (not pcl))
(progn
  (defun allocate-instance (class)
    (clos::std-allocate-instance class))
  (defun class-slots (class)
    (clos::class-slots class))
  (defun class-precedence-list (class)
    (clos::class-precedence-list class))
  (defun class-direct-superclasses (class)
    (clos::class-direct-superclasses class))     
  (defun slot-definition-name (slot)
    (clos::slotdef-name slot))
  (defun slot-definition-initargs (slot)
    (clos::slotdef-initargs slot))
  (defun slot-definition-initform (slot)
    (let ((? (clos::slotdef-initer slot)))
      (and ? (if (car ?) (funcall (car ?)) (cdr ?)))))
  (defun slot-definition-readers (slot)
    (declare (ignore slot))
    (error "slot-definition-readers undefined in CLISP"))
  (defun slot-definition-writers (slot) 
    (declare (ignore slot))
    (error "slot-definition-writers undefined in CLISP"))
  (defmacro slot-value-using-class (class object slot)
    (declare (ignore class))
    `(slot-value ,object (slot-definition-name ,slot)))
  (defun slot-boundp-using-class (class object slot)
    (declare (ignore class))
    (slot-boundp object (slot-definition-name slot)))
  (defun slot-makunbound-using-class (class object slot)
    (declare (ignore class))
    (slot-makunbound object (slot-definition-name slot)))
  (defun change-class (object)
    (declare (ignore object))
    (error "CLISP's CLOS does not implement change-class."))
  (defvar %clisp-prototypes% (make-hash-table))
  (defun class-prototype (class)
    (or (gethash class %clisp-prototypes% )
        (setf (gethash class %clisp-prototypes% )
              (clos::std-allocate-instance class))))
)

#+(and clisp dos)
(progn
  (defun user-homedir-pathname () (pathname "C:\\"))
)

(export '(*common-music-directory*

          ;; utilities.lisp
          quotify *common-music-readtable* save-cm defprop
          +source-type+ +binary-type+ +midi-type+ +text-type+
          +stella-type+ +sound-type+

          ;; scores.lisp
          *common-music-output* *syntax* in-syntax *score*
          *default-scorefile-pathname* *default-scorefile-header*
          *default-scorefile-after* defscorefile defsoundfile defsequence 

          ;; parts.lisp
          *part* event part find-part allocate-score-resource
          make-score-event score-event enqueue-score-event
          dequeue-score-event require-part +killed+
          +ending+ +resting+ +chording+ +unqueued+
          +removed+ +normal-mask+

          ;; score-utilities.lisp
          unless-chording when-chording unless-resting when-resting
          unless-ending when-ending status? with-part

          ;; defpart.lisp
          class-with-parameters defpart describe-part

          ;; item-streams.lisp
          item +end-of-stream-token+ +eop+ +eod+ read-items doitems
          last-item last-state
          ;; expr.lisp
          expr fn

          ;; rhythm-streams.lisp
          *standard-tempo* in-tempo rhythm

          ;; functions.lisp
          *coordinates-are-x-y-pairs* interpolation interpl
          lookup function-value

          ;; scales.lisp
          general-scale equal-tempered-scale gapped-scale find-scale
          list-all-scales cents centify *standard-scale* 
          *respect-note-spelling*
          in-scale standard-chromatic-scale *standard-chromatic-scale*
          make-scale scale-pitch scale-degree scale-note octave-and-interval
          note pitch degree restp scale> scale< scale= scale<= scale>=
          scale/= scale- defscale
	  ; scale degrees of standard scale
          EN8 CF5 CS2 DF0 DS8 GS7 GF1 GN7 EF00 AS1 F1 A1 DN6 C7 FF9 FS0 BF0 
          BN5 CS3 CN0 DS9 GS8 FN1 GN8 DN00 AS2 A2 F2 EF6 DF7 EN9 FS1 CS00 AN0 
          D3 CF6 CS4 B9 FF0 GS9 GF2 GN9 F3 A3 EF7 CN7 FS2 BF1 D4 BN6 CS5 C1 EN0 
          FN2 G00 AS3 F4 A4 C8 DN7 BF00 FS3 D00 AN1 BN7 D5 DF1 CS6 A00 FN3 AS4 
          F5 A5 D0 EF8 AN00 FS4 BF2 D6 CF7 CN1 CS7 FF1 GF3 GF00 AS5 A6 F6 DN8 
          DF8 FS5 ES00 AN2 BN8 C2 CS8 EN1 FN4 FN00 F7 A7 CN8 EF9 ES0 FS6 AN3 
          CF8 D7 DF2 FF2 GF4 AF0 AS6 F8 A8 C9 DN9 FS7 E00 BF3 D8 BN9 CS9 CN2 
          EN2 FN5 AF1 AS7 B0 G0 D1 R ES1 FS8 AN4 E0 CF9 DS00 FF3 GF5 AF2 AS8 A9 
          F9 DF9 ES2 FS9 BF4 D9 BS0 EF0 C3 EN3 FN6 AF3 AS9 G1 B1 CN9 DS0 ES3 
          GS00 AN5 BS1 E1 DN0 DF3 EN4 GF6 AF4 BN0 G2 B2 D2 DS1 ES4 FF00 AF00 
          BF5 BS00 BS2 CN3 EF1 FF4 GF7 AF5 CF0 B3 G3 DS2 ES5 EN00 AN6 BS3 E2 C4 
          DN1 EN5 FN7 B00 AF6 BN1 B4 G4 FS00 GS0 ES6 GN0 BF6 BS4 E3 EF2 CN4 FF5 
          GF8 AF7 CF1 G5 DS3 GS1 ES7 GN1 BF7 BS5 E4 DN2 DF4 EN6 FN8 AF8 BN2 G6 
          B5 GS2 ES8 GN2 F00 AN7 BS6 E5 EF3 C5 FF6 GF9 AF9 CF2 B6 G7 DS4 GN00 
          ES9 GN3 BN00 BF8 BS7 E6 CN5 DN3 FN9 CF3 G8 DS5 GS3 GN4 AN8 E7 DF5 DN4 
          FF7 DF00 C00 BN3 B7 CS0 DS6 GS4 BF9 E8 EF4 C6 EN7 CN00 AS00 CF4 G9 B8 
          GS5 GF0 GN5 AN9 F0 A0 CN6 DN5 FF8 BN4 CS1 C0 DS7 GS6 FN0 GN6 AS0 BS8 
          E9 DF6 EF5 R A B C D E F G AN BN CN DN EN FN GN AF BF CF DF EF FF GF
          AS BS CS DS ES FS GS

          ;; amplitude-streams.lisp
          amplitude *amplitude-minimum* *amplitude-maximum* *amplitude-power*
          niente pppp ppp pp p mp mf f ff fff ffff

	  ;; multiple-items.lisp
          defmultiple-item defmultiple-item-parser defmultiple-item-filter
          multiple-item-bind

          ;; music-utilities.lisp
          transpose invert between header

          ;; constructors.lisp
          make-item-stream items notes pitches degrees rhythms intervals 
          steps amplitude amplitudes series numbers chord motive mirror
          repeat idsel crescendo diminuendo tempo changes
          ; patterns
          cycle sequence accumulation palindrome random heap graph
          function rotation
          ; options
          above args below by change counting downto for elided forming from in
          initially-from linked-to loudest modulus multiple named of on power
          previous props returning softest tempo to traversing using with
          ; option constants
          id weight min max yes no start end p i r ri prime inversion step
          width retrograde retrograde-inversion idsel depth breadth periods
          values
          ; item stream classes
          cyclic-item-stream random-item-stream heap-item-stream
          palindromic-item-stream graph-item-stream sequential-item-stream
          functional-item-stream rotational-item-stream
          accumulating-item-stream cyclic-note-stream random-note-stream
          heap-note-stream palindromic-note-stream graph-note-stream
          sequential-note-stream functional-note-stream rotational-note-stream 
          accumulating-note-stream cyclic-pitch-stream random-pitch-stream
          heap-pitch-stream palindromic-pitch-stream graph-pitch-stream
          sequential-pitch-stream functional-pitch-stream 
          rotational-pitch-stream accumulating-pitch-stream
          cyclic-degree-stream random-degree-stream heap-degree-stream
          palindromic-degree-stream graph-degree-stream
          sequential-degree-stream functional-degree-stream
          rotational-degree-stream accumulating-degree-stream
          cyclic-interval-stream random-interval-stream heap-interval-stream
          palindromic-interval-stream graph-interval-stream 
          sequential-interval-stream functional-interval-stream
          rotational-interval-stream  accumulating-interval-stream
          cyclic-step-stream random-step-stream heap-step-stream
          palindromic-step-stream graph-step-stream sequential-step-stream
          functional-step-stream rotational-step-stream
          accumulating-step-stream cyclic-rhythm-stream random-rhythm-stream
          heap-rhythm-stream palindromic-rhythm-stream graph-rhythm-stream
          sequential-rhythm-stream functional-rhythm-stream
          rotational-rhythm-stream accumulating-rhythm-stream
          cyclic-amplitude-stream random-amplitude-stream heap-amplitude-stream
          palindromic-amplitude-stream graph-amplitude-stream
          sequential-amplitude-stream functional-amplitude-stream
          rotational-amplitude-stream accumulating-amplitude-stream
          series-stream linear-number-stream random-number-stream

          ;; clm.lisp
          *default-scorefile-with-sound*

          ;; messages.lisp
          make-channel-message channel-message-p channel-message-status
          channel-message-channel channel-message-data1 channel-message-data2
          make-note-on note-on-p note-on-channel note-on-key note-on-velocity 
          make-note-off note-off-p note-off-channel note-off-key
          note-off-velocity make-key-pressure key-pressure-p
          key-pressure-channel key-pressure-key key-pressure-pressure
          make-control-change control-change-p control-change-channel
          control-change-control control-change-change make-program-change
          program-change-p program-change-channel program-change-program
          make-channel-pressure channel-pressure-p channel-pressure-channel
          channel-pressure-pressure make-pitch-bend pitch-bend-p
          pitch-bend-channel pitch-bend-lsb pitch-bend-msb
          make-channel-mode-message channel-mode-p channel-mode-channel
          channel-mode-control channel-mode-change make-system-message
          system-message-p system-message-status system-message-data1
          system-message-data2 make-song-position song-position-p
          song-position-lsb song-position-msb make-song-select
          song-select-p song-select-song make-tune-request tune-request-p
          make-sysex-message sysex-message-p sysex-message-id 
          make-meta-message meta-message-p meta-message-type
          make-time-signature time-signature-p make-tempo-change
          tempo-change-p make-eot eot-p make-midi-data midi-data-p
          midi-data-size midi-data-data1 midi-data-data2
          midi-data-data3 make-midi-message

          ;; midi.lisp
          *default-midi-pathname* midi-open midi-open-p midi-port-reference-p
          ask-port midi-close midi-hush midi-print-message midi-write-message
          midi-read-messages midi-get-time midi-set-time midi-set-quanta-size
          quanta-time real-time midi-stop-time midi-start-time
          *midi-read-hook* with-midi-open midi-receive-messages
  	  
          ;; midifile.lisp
          midifile-play midifile-print midifile-map midifile-parse
          write-message write-midi-file-header read-midi-file-header
          midifile-to-vector
	  ))

(pushnew ':common-music *features*)
