;;; Edit the site parameters marked *** Begin Site *** below.  Be sure 
;;; include the directory character at the end of directory specifications, 
;;; and don't use relative pathnames. 
;;;
;;; cm-directory   - The Common Music source directory.
;;; cm-image-name  - The lisp image file to save Common Music in.  Be
;;;                  sure that you have write permission and enough free
;;;                  space in the directory you write to.
;;; syntaxes       - The list of output syntaxes to build into Common Music,
;;;                  any of '(:MusicKit :CLM :CMN :MIDI :CSound :RT)
;;;                  The first syntax in the list becomes the default syntax
;;;                  when the system boots up.
;;; pcl-directory  - If you use PCL (public domain CLOS), set to the PCL
;;;                  source directory, otherwise NIL.  You must compile
;;;                  PCL before building Common Music.
;;; clm-directory  - If you use CLM (Common Lisp Music) set to the CLM 
;;;                  source directory, otherwise NIL. You must compile CLM
;;;                  before building Common Music.
;;; cmn-directory  - If you use CMN, set to the CMN source directory, 
;;;                  otherwise NIL. You must compile CMN before building
;;;                  Common Music.
;;;
;;; By default this build script assumes the following:
;;; (1) You want to save the complied files together with the sources.
;;; (2) If you use a NeXT, you are running NeXStep 3.0 or later.
;;; (3) If you use an SGI, your G0 libs are in /usr/lib.
;;; (4) You don't want the old runtime system.
;;; If any of these assumptions are incorrect, search for "other parameters"
;;; later in this file and fix. 
;;;

(let              ;  *** Begin Site *** 
   ( 
   (cm-directory                "/dist/cm/")
   (cm-image-name               "/ZKM/Lisp/clisp/cm.mem") 
   (clm-directory               nil) 
   (cmn-directory               nil)
   (pcl-directory               nil) 
   (syntaxes                    '(:midi)) 
   )
                  ;  *** End Site *** 

  (declare #-(or mcl excl kcl lispworks clisp) (special cm-directory))

  #+irix (pushnew :sgi *features*)

  #+(and excl cltl2)
  (setf (excl:package-definition-lock (find-package ':common-lisp)) nil)

  #+aclpc
  (progn (setf top::*warn-on-redefinition* nil)
         (pushnew ':dos *features*))

  #+(and clisp (not pcl))
  (unless (find-symbol "SYMBOL-MACROLET" "LISP")
    (error "Common Music's code walker assumes that CLISP stores environments ~
           as 2 element vectors, but this version of CLISP doesn't. The ~
           easiest thing to do is to replace utils/walk.lisp with the ~
           version in the PCL archive stored at the CLISP ftp site in the ~
           directory clisp/packages."))

  (flet ((filename (&rest path)
           #+(and clisp dos)
           (setf path (mapcar #'string-upcase path))
           (let ((directory (butlast path))
                 (file (car (last path))))
            #+(or aclpc dos)
            (when (> (length file) 8)
              (setf file (subseq file 0 8)))

             (if directory
               (let ((m (subseq (first directory) 
                                (1- (length (first directory))))))
                 (apply #'concatenate 'string 
                        (append (cons (car directory) 
                                      (mapcan #'(lambda (d)(list d m))
                                              (cdr directory)))
                                (list file))))
               file))) 
         (checkdir (dir)
           (unless (char= #+:apple #\: 
                          #+unix #\/ 
                          #+(or aclpc dos) #\\ 
                          (elt dir (1- (length dir))))
             (error "~A is missing a trailing directory delimiter" dir)))
         (shell (string) 
           #-unix (error "Calling shell without UNIX?")
           #+excl (excl:shell string)
           #+akcl (lisp:system string)
	   #+lispworks (foreign:call-system string "/bin/csh")
	   #+clisp (lisp:shell string)
           #-(or excl akcl lispworks clisp) 
             (error "SHELL not implemented in this port!")
           ))

    ;; simple error checks up front
    (checkdir cm-directory)
    (when pcl-directory (checkdir pcl-directory))
    (when clm-directory (checkdir clm-directory))
    (when cmn-directory (checkdir cmn-directory))
    
    (unless (listp syntaxes) (setf syntaxes (list syntaxes)))
    (dolist (s syntaxes)
      (unless (find s '(:midi :clm :cmn :csound :rt :musickit))
        (error "~S is not a common music syntax" s)))
    ;; other parameters
    (let (
          ;; if you want the old runtime, change NIL to T
          (defscorefile NIL)
          ;; if you dont keep binaries with sources set the dir.
          (bin-directory NIL)
          ;; if running NextStep < 3.0 change to NIL
          #+(or next |NeXT|) (next-3-0 T)
          ;; if the sgi G0 libs are not in /usr/lib set the dir
          #+sgi  (G0-directory "/usr/lib")

          (source-type #+(or aclpc dos) "LSP"
                       #-(or aclpc dos) "lisp" 
                       )
          (binary-type #+(or excl mcl) "fasl"
                       #+kcl "o"
                       #+aclpc "fsl"
	               #+(and lispworks mips) "mfasl"
                       #+(and clisp dos) "FAS"
                       #+(and clisp (not dos)) "fas"
                       )
          (compiled? nil)
          )
      (when bin-directory (checkdir bin-directory))
      (flet ((dofile (&rest args)
               (let* ((sargs #-lispworks
			     (apply #'filename args)
                             #+lispworks
                             (pathname (apply #'filename args)))
	              (bargs (if (null bin-directory) 
		                 sargs
                               (apply #'filename (cons bin-directory
		                                       (cdr args)))))
		      (source (make-pathname :defaults sargs 
                                             :type (or (pathname-type sargs)
                                                       source-type)))
                      (binary (make-pathname :defaults bargs
                                             :type binary-type)))
                 (when (or (not (probe-file binary))
                           (if (probe-file source)
                               (< (file-write-date binary)
                                  (file-write-date source))
                             (error "Can't find source file: ~S" source)))
                   #+mcl (compile-file source :output-file binary :verbose t)
                   #-mcl (compile-file source :output-file binary)
                   #+clisp ; clean up compiler doo doo file
                   (let ((stupid (make-pathname :defaults bargs
                                                :type #+dos "LIB"
                                                      #-dos "lib")))
                     (when (probe-file stupid) (delete-file stupid)))
                   (setf compiled? t))
                 (load binary :verbose t))))

        ;; maybe load loop
        (unless (find ':loop *features*)
          #+excl (require :loop)
          #+akcl (dofile cm-directory "utils" "loop")
          ;; can't use mcl's auto loading feature in saved images...
          #+mcl (progn (load "ccl:library;loop" :verbose t)
                       (pushnew ':loop *features*))
          #+clisp
          (handler-bind ((t
                          #'(lambda (c)
	                      (when (find-restart 'continue)
                                (invoke-restart 'continue)))))
            (dofile cm-directory "utils" "loop"))
          )

        #+mcl (load (filename cm-directory "pathname-translations"))    
        ;; either load pcl or just code walker. we place this after clm
        ;; loading so we can check to see if clm loaded walker.
        #-(or lispworks         ; lispworks 3.1 has clos and walker pkgs.
              (and excl cltl2)) ; excl 4.1 has walker internal to clos pkg.
        (when (not (find ':pcl *features*))
          (if (not pcl-directory)
              (unless (find-package ':walker)
                (dofile cm-directory "utils" "walk"))
            (let ((binary (format nil "~Adefsys.~A" 
                                  pcl-directory binary-type))
                  (source (format nil "~Adefsys.~A" 
                                  pcl-directory source-type)))
              (if (probe-file binary)
                  (load binary)
                 (load source))
              (funcall (find-symbol "LOAD-PCL" :pcl))
              (set (find-symbol "*DEFCLASS-TIMES*" :pcl) 
                   '(compile load eval))
              (set (find-symbol "*DEFMETHOD-TIMES*" :pcl) 
                   '(load eval))
              ))
          (when (find-symbol "WALK-FORM-EXPAND-MACROS-P" :walker)
            (set (find-symbol "WALK-FORM-EXPAND-MACROS-P" :walker) t)))

        ;; maybe load CLM
        (when clm-directory
          (let (#-lispworks
                (*default-pathname-defaults* #-(or mcl lispworks)
                                             clm-directory
                                             #+mcl ""
                                             #+lispworks "")
	       )
            (load (filename clm-directory "all.lisp"))))

        ;; maybe load CMN
        (when cmn-directory
          (let (#-lispworks
                (*default-pathname-defaults* #-(or mcl lispworks)
                                             clm-directory
                                             #+mcl ""
                                             #+lispworks "")
	       )
            (load (filename cmn-directory "cmn-all.lisp"))))

        ;; load command interpreter. this is after clm because
        ;; we want to clobber clm's version, if it was loaded.
	
        (dofile cm-directory "utils" "tl") 
        (dofile cm-directory "utils" "defresource") 
        
        ;; load cm kernel        
        (let ((kern '("common-music"
                      "utilities" 
                      "functions"
                      "item-streams"
                      "expr"
                      "number-streams"
                      "scales"
                      "note-streams"
                      "interval-streams"
                      "rhythm-streams"
                      "amplitude-streams"
                      "multiple-items"
                      "constructors"
                      "music-utilities"
                      "score-utilities")))
          (dolist (f kern) (dofile cm-directory f)))

         (when defscorefile
          ;; define scores and parts
          (dolist (f '("scores" "parts" "defpart" "with-part"))
            (dofile cm-directory "oldsys" f))
          ;; maybe load clm syntax
          (when (find ':clm syntaxes)
            (let ((clm '("clm" ))) ;"fm-violin"
              (dolist (f clm) (dofile cm-directory "oldsys" "clm" f))))
          ;; maybe load music kit syntax
          (when (find ':musicKit syntaxes)
            (let ((mk '("mk" "mixins" 
                        "dbfm1vi" "dbwave1vi" 
                        "dbwave2vi" "fm1i" "fm1vi" 
                        "fm2cnvi" "fm2cnvipoly" #-akcl "fm2cnvimono" 
                        "fm2cvi" 
                        "fm2pnvi" "fm2pnvipoly" #-akcl "fm2pnvimono" 
                        "fm2pvi" "pluck"
                        "wave1i" "wave1vi" "midi" "mixsounds")))
              (dolist (f mk) (dofile cm-directory "oldsys" "mk" f))))
          ;; maybe load csound syntax
          (when (find ':CSound syntaxes)
            (let ((csound '("csound")))
             (dolist (f csound) (dofile cm-directory "oldsys" "csound" f))))
          (when syntaxes 
            (set (find-symbol "*SYNTAX*" :cm) (first syntaxes)))
          )

        ;; maybe load midi syntax
        (when (find ':midi syntaxes)
          (dofile cm-directory "midi" "messages")
          #+(or Next |NeXT|)
          ;; fucking 3.0 nonsense. we need to use to the new mididriver
          ;; and the easiest way is to make a link.
          (unless (probe-file (filename cm-directory "midi" "next-midi.c"))
            (shell (format nil "ln -s ~A ~A"
                          (filename cm-directory "midi" 
                                    (if next-3-0 "next-3-0-midi.c"
                                        "next-2-0-midi.c"))
                          (filename cm-directory "midi" "next-midi.c"))))
	  #+(or SGI |SGI|)
	  (let ((midi-version-file (filename cm-directory "midi/sgi"
                                            "midi-version")))
	      (shell (format nil "versions mididev | sed -f ~A > ~A"
			     (filename cm-directory "midi/sgi" 
                             "find-midi-version.sed")
			     midi-version-file))
	      (with-open-file (s midi-version-file)
		(setq sgi-midi-version (read s)))
	      (setq sgi-midi-lib (format nil "sgi-midi-~S.a"
                                         sgi-midi-version))
	      (let ((c (filename cm-directory "midi/sgi"
				 (format nil 
					 #+excl "sgi-excl-midi-~S.c" 
					 #+lispworks "sgi-lw-midi-~S.c"
					 sgi-midi-version))))
                (setq sgi-midi-o
                  (format nil #+excl "sgi-excl-midi-~S.o" 
                              #+lispworks "sgi-lw-midi-~S.o"
                              sgi-midi-version))
                (unless (probe-file c)
                  (shell (format nil "ln -s ~A ~A"
                                 (filename cm-directory "midi/sgi"
                                           (format nil "sgi-midi-~S.c" 
                                                   sgi-midi-version))
                                 c)))))
          #+(and excl next)
          (let ((o (filename (or bin-directory cm-directory)
	              "midi" "next-midi.o"))
                (c (filename cm-directory "midi" "next-midi.c")))
            (unless (probe-file o)
              (shell (format nil "/bin/cc -DEXCL -c ~A -O -o ~A~&"
                                  (namestring c) (namestring o))))
	    (if next-3-0 (load o) 
              (load o :foreign-files '("/usr/lib/libmidi.a") 
                    :system-libraries '("sys_s")))
            (dofile cm-directory "midi" "next-excl-midi"))
	  #+SGI
          (let ((o (filename (or bin-directory cm-directory)
			     "midi/sgi" sgi-midi-o))
		(a (filename (or bin-directory cm-directory)
			     "midi/sgi" "sgi-midi.a"))
		(midi-dir (filename cm-directory "midi/sgi")))
	    (shell (format nil "cd ~A ; make ~A" midi-dir sgi-midi-lib))
	    #+excl
	    (shell (format nil "cd ~A ; setenv LISP EXCL; make ~A"
                           midi-dir sgi-midi-o))
	    #+lispworks
	    (shell (format nil "cd ~A ; setenv LISP LISPWORKS; make ~A"
                           midi-dir sgi-midi-o))
	    (shell (format nil "ln -s ~A ~A"
			   (filename cm-directory "midi/sgi"
                                             sgi-midi-lib)
			   (filename cm-directory "midi/sgi"
                                             "sgi-midi.a")))
	    
	    #+lispworks
	    (progn
	      (dofile cm-directory "midi/sgi" "sgi-lw-midi")
	      (foreign:read-foreign-modules o a
		(filename G0-directory "libmidi_G0.a") ; "-lmidi_G0"
                "-lmpc_G0"
                "-lmalloc_G0"
                "-lm_G0"
                 ))
	    #+excl
	    (progn	
	      (ff:remove-entry-point (ff:convert-to-lang "abort"))
	      (load o :foreign-files `(,a "/usr/lib/libmidi_G0.a"
					  ;;"/usr/lib/libmpc_G0.a" 
					  "/usr/lib/libmalloc_G0.a"
					  "/usr/lib/libC_G0.a")
		    :update-entry-points t)
	      (dofile cm-directory "midi/sgi" "sgi-excl-midi")))

          #+(and akcl |NeXT|) (dofile cm-directory "midi" "next-akcl-midi")
          #+(and akcl |SGI|) (dofile cm-directory "midi" "sgi-akcl-midi")
          #+(or Next |NeXT|) (shell (format nil "rm ~A" 
                                            (filename cm-directory "midi"
                                                      "next-midi.c")))
	  #+mcl (dofile cm-directory "midi" "mcl-midi")
	  #+aclpc (dofile cm-directory "midi" "winmidi")
	  
	  #-(or aclpl mcl (and excl next) (and akcl |NeXT|) 
                (and excl SGI) (and lispworks SGI))
	  (warn "~%Midi real time not implemented for this lisp ~
                 and machine.")
	  (dofile cm-directory "midi" "midi")
	  (dofile cm-directory "midi" "midifile")
          ;; uncomment if you use defscorefile
	  (when defscorefile
            (dofile cm-directory "oldsys"  "midi" "midiscore"))
          )
        
        (let ((l '("pkg" "utils" "classes" "edit" "select" "constructors"
                   "sysio" "ask" "syntax" "io" "doobject" "files" "archive" 
                   "references" "record" "copy" "map" "stella")))
          (dolist (f l) (dofile cm-directory "stella" f))
	      ; midi before other syntaxs for compile time method building
          (when (find :midi syntaxes)
            (dofile cm-directory "stella" "midi"))
          (when (find :clm syntaxes)
            (dofile cm-directory "stella" "clm"))
          (when (find :cmn syntaxes)
            (dofile cm-directory "stella" "cmn"))
          (when (find :csound syntaxes)	
            (dofile cm-directory "stella" "csound" ))
          (when (find :rt syntaxes)	
            (dofile cm-directory "stella" "rt" ))
          #+(or next |NeXT|)
          (when (find :musicKit syntaxes)
            (let (s)
              (dofile cm-directory "stella" "mk")
              (unless (probe-file (filename cm-directory "stella"
                                            "mk2stella"))
                (setf s 
                  (format nil "cc ~:[-DNeXT_2~;-DNeXT_3~] -g -c ~A -o ~A~%" 
                          next-3-0   
                          (filename cm-directory "stella" "mk2stella.m")
                          (filename cm-directory "stella" "mk2stella.o")))
                (format t "Shelling: ~S~%" s)
                (shell s)
                (setf s 
                  (format nil 
                         (if next-3-0 
                             "cc -o ~A ~A -lmusickit -lNeXT_s -lsys_s~%" 
                           "cc -o ~A ~A -lmusic_s -ldsp_s -lNeXT_s -lsys_s~%")
                     (filename cm-directory "stella" "mk2stella")
                     (filename cm-directory "stella" "mk2stella.o")))
                (format t "Shelling: ~S~%" s)
                (shell s))))
          ) 
     )

      ;; save image if possible    
      (if compiled?
          (format t 
"~%~%A recompile occured while building Common Music, so no image file will
be saved this pass. Quit and restart lisp, then reload build.lisp to save the final lisp image.~&")
        (let ((path cm-image-name))
          #+kcl (si:chdir (directory-namestring path)) 
          #+(or excl mcl aclpc lispworks)
            (progn (format t "Doing a full gc before save.~%")
                   #+excl (excl:gc t)
                   #+mcl  (ccl:gc)
                   #+aclpc (allegro:gc) 
		   #+lispworks (lispworks:mark-and-sweep 3)
                   )
          (format t "Saving Common Music in ~A~&" path)
          (funcall (find-symbol "SAVE-CM" :cm) 
                   path :stella (first syntaxes)))))

  ))
