;;; -*- Mode: LISP; Base: 10; Vsp: 1; Syntax: Rhet; Package: RPRS -*-
;;;;;
;;;;; Copyright (C) 1989 by the University of Rochester. All rights reserved.
;;;;; See your Rhet license agreement and file RPRS:rprs;copyright.text for more details.
;;;;;
;;; Copyright 1987 by Henry A. Kautz
;;; This software may be freely distributed in original or modified
;;; form, under the condition that this copyright notice is included.
;;; No warranty as to the correctness or usefulness of this software
;;; is given or implied.
;;;
;;; The author may be contacted at the following addresses:
;;; :uucp:	allegra!kautz		
;;; :arpa: or :csnet:	kautz@allegra.att.com
;;; :old style csnet: 	kautz%allegra@btl.csnet
;;; :mail:	AT&T Bell Laboratories	
;;;		Room 3C-402A
;;;		600 Mountain Ave.	
;;;		Murray Hill, N.J. 07974	
;;; This software was not produced while the author was employee of 
;;; AT&T Bell Laboratories, and that organization has no legal 
;;; claim or responsibility for this software.
;;;
(in-package RPRS)

(add-UTYPE 'T-TIME [THE-WHOLE-DAY])	;a maximum time interval, used in demo to assert something is always true (or false).

(DEFINE-ACTION-TYPE 'T-TIMED-ACTION :ROLES '((R-TIME T-TIME))
		    :CONSTRAINTS '([TIME-CONTAINS THE-WHOLE-DAY [F-TIME ?SELF]])	; make sure everything is a subtime of
		    )									; wholeday.

(DEFINE-ACTION-TYPE 'T-CAN :PARENT 'T-TIMED-ACTION
		    :ROLES '((R-ACTION-OBJECT T-TIMED-ACTION)))

(TDISJOINT 'T-CAN 'T-AGENT-IS-SPEAKER-ACTION)
  
(DEFINE-CONJUNCTION 'T-AGENT-IS-SPEAKER-ACTION '(T-TIMED-ACTION) :ROLES '((R-SPEAKER R-AGENT)))

(DEFINE-SUBTYPE 'T-two-party-action 'T-AGENT-IS-SPEAKER-ACTION
  :ROLES '((R-HEARER T-ANIMATE))
  :CONSTRAINTS '([NOTEQ? [F-SPEAKER ?SELF] [F-HEARER ?SELF]]))

(DEFINE-SUBTYPE 'T-UTTERANCE-ACT 'T-TWO-PARTY-ACTION)

(DEFINE-ACTION-TYPE 'T-surface-question :PARENT 'T-UTTERANCE-ACT
		    :ROLES '((R-CONTENT T-TIMED-ACTION)))

(DEFINE-ACTION-TYPE 'T-GIVE :PARENT 'T-TWO-PARTY-ACTION
		    :ROLES '((R-OBJECT T-U)))

(DEFINE-ACTION-TYPE 'T-INFORMIF :PARENT 'T-TWO-PARTY-ACTION
		    :ROLES '((R-CONTENT T-TIMED-ACTION)))

(TDISJOINT 'T-INFORMIF 'T-GIVE)

(DEFINE-SUBTYPE 'T-TIMED-CPLAN 'T-CPLAN :ROLES '((R-TIME T-TIME))
		:CONSTRAINTS '([TIME-CONTAINS THE-WHOLE-DAY [F-TIME ?SELF]]))

(DEFINE-CONJUNCTION 'T-AGENT-IS-SPEAKER-CPLAN '(T-TIMED-CPLAN) :ROLES '((R-SPEAKER R-AGENT)))

(DEFINE-SUBTYPE 'T-TWO-PARTY-PLAN 'T-AGENT-IS-SPEAKER-CPLAN
  :ROLES '((R-HEARER T-ANIMATE))
  :CONSTRAINTS '([NOTEQ? [F-SPEAKER ?SELF] [F-HEARER ?SELF]]))
		   
(DEFINE-SUBTYPE 'T-SPEECH-ACT 'T-TWO-PARTY-PLAN)

(DEFINE-CPLAN-TYPE 'T-REQUEST :PARENT 'T-SPEECH-ACT :ROLES '((R-REQGOAL T-TIMED-ACTION)))

(DECLARE-FN-TYPE 'REQGOAL-TIME '(T-REQUEST T-TIME))

(DEFINE-CPLAN-TYPE 'T-direct-request :PARENT 'T-REQUEST :ROLES '((R-REQGOAL T-INFORMIF))
  :STEPS '((:S-1 . [C-surface-question [F-SPEAKER ?SELF]
				       [F-TIME ?SELF]
				       [F-HEARER ?SELF]
				       ?CONTENT*T-TIMED-ACTION]))
  :CONSTRAINTS #[ '([TIME-CONTAINS THE-WHOLE-DAY [REQGOAL-TIME ?SELF]]
		    [EQ? [F-REQGOAL ?SELF]
			 [C-INFORMIF [F-HEARER ?SELF] [REQGOAL-TIME ?SELF] [F-SPEAKER ?SELF] [F-CONTENT [S-1 ?SELF]]]]) #] )

(DEFINE-CPLAN-TYPE 'T-indirect-request :PARENT 'T-REQUEST
  :STEPS '((:S-1 . [C-surface-question [F-SPEAKER ?SELF]
				       [F-TIME ?SELF]
				       [F-HEARER ?SELF]
				       [C-CAN [F-HEARER ?SELF] [F-TIME [F-CONTENT [S-1 ?SELF]]] [F-REQGOAL ?SELF]]])))

(DEFINE-SUBTYPE 'T-TIMED-RPLAN 'T-RPLAN
  :ROLES '((R-TIME T-TIME))
  :CONSTRAINTS '([TIME-CONTAINS THE-WHOLE-DAY [F-TIME ?SELF]]))

(DECLARE-FN-TYPE 'PLAN-PRETIME '(T-TIMED-RPLAN T-TIME))

(DEFINE-RPLAN-TYPE 'T-OBTAIN :PARENT 'T-TIMED-RPLAN
  :ROLES '((R-OBJECT T-U))
  :CONSTRAINTS '#[ ([FT [PLAN-PRETIME ?SELF] [HAVE [F-AGENT ?SELF] [F-OBJECT ?SELF]]]
		    [TIME-MEETS [PLAN-PRETIME ?SELF] [F-TIME ?SELF]]
		    [TIME-CONTAINS THE-WHOLE-DAY [PLAN-PRETIME ?SELF]]) #] )	;ft is a TEMPOS builtin!

(DEFINE-RPLAN-TYPE 'T-FINDOUT :PARENT 'T-TIMED-RPLAN
  :ROLES '((R-INFO T-TIMED-ACTION))
  :CONSTRAINTS '#[ ([FT [PLAN-PRETIME ?SELF] [KNOWIF [F-AGENT ?SELF] [F-INFO ?SELF]]]
		    [TIME-MEETS [PLAN-PRETIME ?SELF] [F-TIME ?SELF]]
		    [TIME-CONTAINS THE-WHOLE-DAY [PLAN-PRETIME ?SELF]]) #] )

(TDISJOINT 'T-OBTAIN 'T-FINDOUT)

(DEFINE-RPLAN-TYPE 'T-obtain-by-asking :PARENT 'T-OBTAIN
		   :ROLES '((R-OBTAINEE T-ANIMATE))
		   :STEPS '#[ ((:S-2 . [C-give [F-OBTAINEE ?SELF] ?TIME-2*T-TIME [F-AGENT ?SELF] [F-OBJECT ?SELF]])
			       (:S-1 . [C-request [F-AGENT ?SELF]
						  ?TIME-1*T-TIME
						  [F-OBTAINEE ?SELF]
						  [C-GIVE [F-OBTAINEE ?SELF]
							  [F-TIME [S-2 ?SELF]]
							  [F-AGENT ?SELF]
							  [F-OBJECT ?SELF]]])) #]
		   :CONSTRAINTS '#[ ([TIME-SUBINT [F-TIME [S-1 ?SELF]] [F-TIME ?SELF]]
				     [TIME-SUBINT [F-TIME [S-2 ?SELF]] [F-TIME ?SELF]]
				     [TIME-FINISHES-EARLIER [F-TIME [S-1 ?SELF]] [F-TIME [S-2 ?SELF]]]
				     [NOT-EQ? [F-AGENT ?SELF] [F-OBTAINEE ?SELF]]) #] )

(DEFINE-RPLAN-TYPE 'T-findout-by-asking :PARENT 'T-FINDOUT
		   :ROLES '((R-ASKEE T-ANIMATE))
		   :STEPS '#[ ((:S-2 . [C-informif [F-ASKEE ?SELF] ?TIME-2*T-TIME [F-AGENT ?SELF] [F-INFO ?SELF]])
			       (:S-1 . [C-request [F-AGENT ?SELF]
						  ?TIME-1*T-TIME
						  [F-ASKEE ?SELF]
						  [C-INFORMIF [F-ASKEE ?SELF]
							      [F-TIME [S-2 ?SELF]]
							      [F-AGENT ?SELF]
							      [F-INFO ?SELF]]])) #]
				:CONSTRAINTS '#[ ([TIME-SUBINT [F-TIME [S-1 ?SELF]] [F-TIME ?SELF]]
						  [TIME-SUBINT [F-TIME [S-2 ?SELF]] [F-TIME ?SELF]]
						  [TIME-FINISHES-EARLIER [F-TIME [S-1 ?SELF]] [F-TIME [S-2 ?SELF]]]
						  [NOT-EQ? [F-AGENT ?SELF] [F-ASKEE ?SELF]]) #] )

;; and some agent instances
(add-UTYPE 'T-ANIMATE [JOE] [SALLY])
