;;; -*- Mode: LISP; Base: 10; Vsp: 1; Syntax: Rhet; Package: RPRS -*-
;;;;;
;;;;; Copyright (C) 1989 by the University of Rochester. All rights reserved.
;;;;; See your Rhet license agreement and file RPRS:rprs;copyright.text for more details.
;;;;;
(in-package rprs)

;;; Portions Copyright 1987 by Henry A. Kautz
;;; This software may be freely distributed in original or modified
;;; form, under the condition that this copyright notice is included.
;;; No warranty as to the correctness or usefulness of this software
;;; is given or implied.
;;;
;;; The author may be contacted at the following addresses:
;;; :uucp:	allegra!kautz		
;;; :arpa: or :csnet:	kautz@allegra.att.com
;;; :old style csnet: 	kautz%allegra@btl.csnet
;;; :mail:	AT&T Bell Laboratories	
;;;		Room 3C-402A
;;;		600 Mountain Ave.	
;;;		Murray Hill, N.J. 07974	
;;; This software was not produced while the author was employee of 
;;; AT&T Bell Laboratories, and that organization has no legal 
;;; claim or responsibility for this software.
;;;


;;;; cook test 2
;;;;    more complete cooking hierarchy
;;;;    as described in chapters 2 and 3

(TSUBTYPE 'T-U 'T-NOODLE-DISH)

(DEFINE-SUBTYPE 'T-NON-END 'T-ACTION
  :ROLES '((R-TIME T-TIME)))	;all actions have agent roles, btw.

(DEFINE-ACTION-TYPE 'T-MAKE-SAUCE :PARENT 'T-NON-END)

(DEFINE-ACTION-TYPE 'T-MAKE-MARINARA :PARENT 'T-MAKE-SAUCE)

(DEFINE-ACTION-TYPE 'T-MAKE-ALFREDO :PARENT 'T-MAKE-SAUCE)

(DEFINE-ACTION-TYPE 'T-MAKE-NOODLES :PARENT 'T-NON-END :ROLES '((R-RESULT T-NOODLE-DISH)))

(DEFINE-ACTION-TYPE 'T-MAKE-SPAGHETTI :PARENT 'T-MAKE-NOODLES)

(DEFINE-ACTION-TYPE 'T-MAKE-FETTUCINI :PARENT 'T-MAKE-NOODLES)

(DEFINE-ACTION-TYPE 'T-BOIL :PARENT 'T-NON-END :ROLES '((R-INPUT T-NOODLE-DISH)))

(DEFINE-SUBTYPE 'T-END 'T-RPLAN)	;use this to capture what our own subtypes need

(DEFINE-RPLAN-TYPE 'T-prepare-meaL :PARENT 'T-END 
  :ROLES '((R-TIME T-TIME))	;all plans have agent roles, btw.
  :CONSTRAINTS '([INKITCHEN [F-TIME ?SELF] [F-AGENT ?SELF]]))

(DEFINE-RPLAN-TYPE 'T-make-pasta-dish :PARENT 'T-PREPARE-MEAL 
		   :STEPS '#[ ((:S-1 . [C-make-noodles [F-AGENT ?SELF] ?TIME-S-1*T-TIME ?RESULT*T-NOODLE-DISH])
			       (:S-2 . [C-make-sauce [F-AGENT ?SELF] ?TIME-S-2*T-TIME])
			       (:S-3 . [C-boil [F-AGENT ?SELF] ?TIME-S-3*T-TIME ?RESULT*T-NOODLE-DISH])) #]
		   :CONSTRAINTS '#[ ([TIME-DURING [F-TIME [S-1 ?SELF]] [F-TIME ?SELF]]
				     [TIME-DURING [F-TIME [S-2 ?SELF]] [F-TIME ?SELF]]
				     [TIME-DURING [F-TIME [S-3 ?SELF]] [F-TIME ?SELF]]
				     [TIME-RELN [F-TIME [S-1 ?SELF]] (:B :M) [F-TIME [S-3 ?SELF]]]
				     [EQ? [F-RESULT [S-1 ?SELF]] [F-INPUT [S-3 ?SELF]]]
				     [ITALIAN [F-AGENT ?SELF]]) #] )
 

(DEFINE-RPLAN-TYPE 'T-make-spaghetti-marinara :PARENT 'T-MAKE-PASTA-DISH
		   :STEPS '#[((:S-1 . [C-make-spaghetti [F-AGENT ?SELF] ?TIME-S-1*T-TIME ?RESULT*T-NOODLE-DISH])
			      (:S-2 . [C-make-marinara [F-AGENT ?SELF] ?TIME-S-2*T-TIME]))#])

(DEFINE-RPLAN-TYPE 'T-make-fettucini-alfredo :PARENT 'T-MAKE-PASTA-DISH
		   :STEPS '#[((:S-1 . [C-make-fettucini [F-AGENT ?SELF] ?TIME-S-1*T-TIME ?RESULT*T-NOODLE-DISH])
			      (:S-2 . [C-make-alfredo [F-AGENT ?SELF] ?TIME-S-2*T-TIME]))#])

(DEFINE-RPLAN-TYPE 'T-MAKE-MEAT-DISH :PARENT 'T-PREPARE-MEAL)

(DEFINE-RPLAN-TYPE 'T-make-chicken-marinara :PARENT 'T-make-meat-dish
		   :STEPS '((:S-5 . [C-make-marinara [F-AGENT ?SELF] ?TIME-S-5*T-TIME]))
		   :CONSTRAINTS '([TIME-CONTAINS [F-TIME ?SELF] [F-TIME [S-5 ?SELF]]]))

;; and some agent instances
(add-UTYPE 'T-ANIMATE [JOE] [SALLY])

;; and some result instances
(add-UTYPE 'T-NOODLE-DISH [NOODLE-42])
