;;; -*- Mode: LISP; Base: 10; Vsp: 1; Syntax: Rhet; Package: RPRS -*-
;;;;;
;;;;; Copyright (C) 1989 by the University of Rochester. All rights reserved.
;;;;; See your Rhet license agreement and file RPRS:rprs;copyright.text for more details.
;;;;;

;;; portions Copyright 1987 by Henry A. Kautz

;;; Demonstrates UPDATE


;; Clear the database.
(reset-rprs)

;;;; Hunt-rob-test : demonstrates upward inference and matching, without parameters.
;; Load the hierarchy.
(load "rprs:test;hunt-rob-test")
;;
;; INCREMENTAL Solution
;;
(setq *update-type* 'i)
(init-hypoths)
;; First observation:  get-gun
(update '(get-gun))
;; There are two alternatives, with c1 as component of rob-bank or of hunt.
(display-hypoths)
;; Second observation: go-to-bank
(update '( go-to-bank))
;; Hypoths after second observation
(display-hypoths)
;;
;; NON-DICHRONIC Solution
;;
(setq *update-type* 'n)
(init-hypoths)
;; First observation:  get-gun
(update '(get-gun))
;; There are two alternatives, with c1 as component of rob-bank or of hunt.
(display-hypoths)
;; Second observation: go-to-bank
(update '( go-to-bank))
;; Hypoths after second observation
(display-hypoths)
;;
;; STICKY Solution
;;
(setq *update-type* 'n)
(init-hypoths)
;; First observation:  get-gun
(update '(get-gun))
;; There are two alternatives, with c1 as component of rob-bank or of hunt.
(display-hypoths)
;; Second observation: go-to-bank
(update '( go-to-bank))
;; Hypoths after second observation
(display-hypoths)


