;;; -*- Mode: LISP; Base: 10; Vsp: 1; Syntax: Rhet; Package: USER -*-
;;; Portions Copyright 1987 by Henry A. Kautz
;;; extensively modified 1989 by Bradford W. Miller for compatibility with RPRS.
;;;;;
;;;;; Copyright (C) 1991, 1989 by the University of Rochester. All rights reserved.
;;;;; See your Rhet license agreement and file RPRS:rprs;copyright.text for more details.
;;;;;

(IN-PACKAGE RHET-USER)

;; Clear the database.
(RESET-RPRS)

;;;; Hunt-rob-test : demonstrates upward inference and matching, without parameters.
;; Load the hierarchy.
(load "/s5/rprs/test/hunt-rob-test.lisp")
;; First observation:  get-gun(c1).  
(MAPCAR #'SHOW-EXPLANATION (explain-observations [C-GET-GUN AGENT1]))
;; Second observation: go-to-bank(c2)
(MAPCAR #'SHOW-EXPLANATION (explain-observations [C-go-to-bank AGENT1]))
;; Using both observations yields just the rob-bank alternative
(MAPCAR #'SHOW-EXPLANATION (EXPLAIN-OBSERVATIONS [C-GET-GUN AGENT2] [C-GO-TO-BANK AGENT2]))

;;;;; ****** END OF HUNTING EXAMPLES
(RESET-RPRS)

;;;; Cooking hierarchy tests : demonstrates multi-level hierarchy & constraints.

(load "/s5/rprs/test/cook-hierarchy-test.lisp")
;; Notice that the hierarchy has the constraint that the agent of make-pasta-dish must be Italian. (Henry had a
;; closed world assumption here about the Italian predicate that we can't deal with due to supporting
;; equality; instead, we run the example three times instead of Henry's two; once when we know the agent IS NOT
;; italian, once when we know he is, and once when we don't comment. Do this in three separate contexts.

;; some times are defined, hours last one hour starting at the specified hour.
;; define a time interval that starts between 4 and 5 oclock and ends between 6 and 7; etc.
(LOAD "/s5/rprs/test/time-definitions.lisp")

;; Create three contexts concerning our agent's status vis the ITALIAN predicate This is just a direct call to
;; the RHET lisp interface to create a user context.

(CREATE-UCONTEXT "IS-ITALIAN" "T")

;; Note how we will now ask RHET to assert a fact in a particular user context. 
;; This fact is not accessible from the root, thus we can create other user 
;; contexts that do not inherit from this one that have noncompatible assertions.

(ASSERT-AXIOMS [ITALIAN JOE] :RCONTEXT (UCONTEXT "IS-ITALIAN"))

;; Such as this one...

(CREATE-UCONTEXT "IS-not-ITALIAN" "T")

(ASSERT-AXIOMS [NOT [ITALIAN JOE]] :RCONTEXT (UCONTEXT "IS-not-ITALIAN"))

;; Also create a context where it isn't provable one way or the other. RPRS will 
;; make the assertion for us as needed when we try to explain the observations
;; from here.

(CREATE-UCONTEXT "DONT-KNOW" "T")

;; First observation is make-sauce(obs-sauce), with agent Joe, during
;; time interval beginning between 4 and 5, and ending between 6 and 7.

;; explain-observation returns a list of pairs of recognized plan instances 
;; and the context it created (as a subcontext of the passed user context)
;; in which they were recognized. We map the SHOW-EXPLANATION 
;; function over the result which gives us our pretty-printed output.

(MAPCAR #'SHOW-EXPLANATION (explain-observations [C-MAKE-SAUCE Joe TIME-STARTS-BETWEEN-4-5-ENDS-BETWEEN-6-7]
						 :UCONTEXT "IS-not-ITALIAN"))
;; Notice that we eliminated the possibility of make-pasta-dish.  Therefore the observation
;; had to be of make-marinara.
;; Now lets add the fact that Joe is Italian.  This fact does not take a temporal index.
;; Try the observation of make-sauce again.
(MAPCAR #'SHOW-EXPLANATION (explain-observations [C-make-sauce Joe TIME-STARTS-BETWEEN-4-5-ENDS-BETWEEN-6-7]
						 :UCONTEXT "IS-ITALIAN"))

;; This time make-pasta-dish WAS considered.  Note that when we don't know, we will assert the agent (JOE) to
;; be italian in those contexts that he is required to be italian
(LET ((PLAN-DOT-CONTEXTS (explain-observations [C-make-sauce Joe TIME-STARTS-BETWEEN-4-5-ENDS-BETWEEN-6-7]
						 :UCONTEXT "DONT-KNOW")))
  ;; also show status of italian predicate in each context
  (MAPC #'(LAMBDA (PLAN-DOT-CONTEXT)
	    (SHOW-EXPLANATION PLAN-DOT-CONTEXT)
	    (FORMAT T "~&Italian? ~S~%" (PROVE [ITALIAN JOE] :RCONTEXT (UCONTEXT (CADR PLAN-DOT-CONTEXT)))))
	PLAN-DOT-CONTEXTS))

;; The second observation is making noodles.
(MAPCAR #'SHOW-EXPLANATION
	(explain-observations [C-make-noodles Joe TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42]
						 :UCONTEXT "IS-ITALIAN"))
;; We can merge g2 and g3 together: they can be steps of the same action, a make-pasta-dish
(MAPCAR #'SHOW-EXPLANATION
 (EXPLAIN-OBSERVATIONS [C-make-sauce Joe TIME-STARTS-BETWEEN-4-5-ENDS-BETWEEN-6-7]
		       [C-make-noodles Joe TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42]
		       :UCONTEXT "IS-ITALIAN"))
;; Now consider an observation of make-noodles with a different agent.  Constants like agent
;; are considered unique names (via the ADD-INEQ function), and thus all are unequal.
(PROGN
  (ASSERT-AXIOMS [italian sally])
  (ADD-INEQ [JOE] [SALLY])
  (MAPCAR #'SHOW-EXPLANATION
	  (explain-observations [C-Make-noodles Sally TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42])))
;; Try to match this with the original make-sauce.  It will fail, because agent roles differ.
;;;; ACTUALLY, WHILE HENRY COULD DO THIS, we have to rerun the explanation proof.
(MAPCAR #'SHOW-EXPLANATION
	(explain-observations [C-MAKE-SAUCE Joe TIME-STARTS-BETWEEN-4-5-ENDS-BETWEEN-6-7]
			      [C-Make-noodles Sally TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42]
			      :UCONTEXT "IS-ITALIAN"))
;; Lets check out the temporal constraints, now.  We'll observe a boiling event, but the time
;; we be BEFORE the make-noodles event.  This conflict will prevent a match.
(MAPCAR #'SHOW-EXPLANATION
	(explain-observations [C-BOIL SALLY HOUR-1 NOODLE-42]
			      [C-Make-noodles Sally TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42]))

;; Now lets find a LATER boiling event.  It should match okay.
(MAPCAR #'SHOW-EXPLANATION
	(explain-observations [C-BOIL SALLY TIME-STARTS-BETWEEN-9-10-ENDS-BETWEEN-11-12 NOODLE-42]
			      [C-Make-noodles Sally TIME-STARTS-BETWEEN-6-8-ENDS-BETWEEN-7-9 NOODLE-42]))

;; ************* End of cooking examples
;(RESET-RPRS)
;
;;;; File System Example:  demonstrates multiple end events.
;;;;; These examples are uninteresting in light of Rhet port.
;(load "/s5/rprs/test/file-system-test.lisp")
;;; User enters:  copy foo bar.
;(explain-observations '(copy (old foo) (new bar)))
;;; Could be part of rename by copy, or of modify file
;(draw-graph t)
;;; User enters: copy jack sprat.
;(explain-observations '(copy (old jack) (new sprat)))
;;; Try (and fail) to unify these commands.
;(match-graphs [c1] [c2] [c1+c2])
;(draw-graph t)
;;; So, there must be two different plans going on.
;;; User enters: delete foo
;(explain-observations '(delete (file foo)))
;(draw-graph t)
;;; This delete can unify with command 1, but not command 2
;(match-graphs [c1] [c3] [c1+c3])
;(draw-graph t)
;(match-graphs [c2] [c3] [c2+c3])
;(draw-graph t)
;
;; End of file system tests

;;; Language Test : Shows inference up 2 levels of step hierarchy before alternatives are
;;  eliminated, and the use of temporally-dependent constraints.
;;
(RESET-RPRS)
(load "/s5/rprs/test/language-test.lisp")
(LOAD "/s5/rprs/test/time-definitions.lisp")

;; Joe says to Sally:  Can you give me the salt?
(MAPCAR #'(LAMBDA (PLAN-CONTEXT-PAIR)
	    (SHOW-EXPLANATION PLAN-CONTEXT-PAIR)
	    ;; step 1 is a subplan, so show that too.
	    (SHOW-EXPLANATION (CONS
				(UI:CONS-RHET-FORM 'S-1 (CAR PLAN-CONTEXT-PAIR))
				(CDR PLAN-CONTEXT-PAIR))))
	(explain-observations
	  [C-SURFACE-QUESTION JOE SOMETIME-IN-HOUR-4 SALLY
			      [C-can sally SOMETIME-IN-HOURS-4-5
				     [C-give sally SOMETIME-IN-HOUR-5 joe salt]]]))
;; The statement is ambiguous, as we saw:

;; There are 2 (of 4) alternatives not eliminated:  an attempt to find out if Sally can give Joe
;; the salt, or an attempt to obtain the salt.

;; Now lets add the fact that at all times, Joe knows if  Sally can give him the salt.
(ASSERT-AXIOMS [MT THE-WHOLE-DAY
		   [KNOWIF JOE
			   [C-CAN SALLY SOMETIME-IN-HOURS-4-5
				  [C-GIVE SALLY SOMETIME-IN-HOUR-5 JOE SALT]]]])
;; Try again, Joe says to Sally: Can you give me the salt?
(MAPCAR #'(LAMBDA (PLAN-CONTEXT-PAIR)
	    (SHOW-EXPLANATION PLAN-CONTEXT-PAIR)
	    ;; step 1 is a subplan, so show that too.
	    (SHOW-EXPLANATION (CONS
				(UI:CONS-RHET-FORM 'S-1 (CAR PLAN-CONTEXT-PAIR))
				(CDR PLAN-CONTEXT-PAIR))))
	(explain-observations
	  [C-SURFACE-QUESTION JOE SOMETIME-IN-HOUR-4 SALLY
			      [C-can sally SOMETIME-IN-HOURS-4-5
				     [C-GIVE SALLY SOMETIME-IN-HOUR-5 JOE SALT]]]))
;; The only interpretation is the indirect request.
;; You can try the other combinations!
;; End of language test.

