;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10; Vsp: 1 -*-
;;;;;
;;;;; Copyright (C) 1993, 1989 by the University of Rochester. All rights reserved.
;;;;; See your Rhet license agreement and file RPRS:rprs;copyright.text for more details.
;;;;;

;;; 3.0 /91 by miller
;;; 3.1 3/19/93 by miller - port to latest version of rhet and allegro.

(in-package cl-user)

#+SYMBOLICS
(DEFSYSTEM RPRS
    (:PRETTY-NAME "RHET Plan Recognition System"
     :DEFAULT-PATHNAME "RPRS:RPRS;"
     :MAINTAINING-SITES (:CS-ROCHESTER)
     :JOURNAL-DIRECTORY "RPRS:patch;"
     :PATCHABLE T
     :INITIAL-STATUS :EXPERIMENTAL
     :ADVERTISED-IN (:HERALD :FINGER)
     :BUG-REPORTS ("RPRS" "Report problems with RPRS.")
     :DISTRIBUTE-SOURCES T
     :DISTRIBUTE-BINARIES NIL)

  (:MODULE TEMPOS TEMPOS (:TYPE :SYSTEM))
  (:MODULE PACKAGE-DEFS "packages" (:IN-ORDER-TO (:COMPILE :LOAD) (:LOAD TEMPOS)))
  (:MODULE RPRS-CODE RPRS-CODE (:TYPE :SYSTEM)
	   (:IN-ORDER-TO (:COMPILE :LOAD) (:LOAD TEMPOS PACKAGE-DEFS)))
  (:MODULE DOC1 ("rprs;copyright")
	   (:TYPE :TEXT))
  (:MODULE DOC2 ("doc;rprs.tex")
	   (:TYPE :TEX))
  (:MODULE DOC3 ("doc;plan.bib")
	   (:TYPE :BIB))
  (:MODULE DEMOSTUFF ("demo;merge-test"
		      "demo;showoff"
		      "demo;update-showoff"
		      "test;cook-hierarchy-test"
		      "test;file-system-test"
		      "test;hunt-rob-test"
		      "test;language-test"
		      "test;merge-test"
		      "test;time-definitions")
	   (:TYPE :LISP-EXAMPLE)))

#+SYMBOLICS
(DEFSUBSYSTEM RPRS-CODE
    (:DEFAULT-PATHNAME "rprs:code;")

  (:MODULE MAIN ("user"))
  (:MODULE RHET-CODE ("rhet-code")
	   (:TYPE :LISP-EXAMPLE)))

(DEFSYSTEM :RPRS
    (:Default-PATHNAME "/s5/rprs/")
  (:MODULE PACKAGE-DEFS 
           ("packages"))
  (:MODULE CODE ("code/user")
           (:uses-definitions-from PACKAGE-DEFS)
           ))


