;;; -*- Mode: LISP; Syntax: Rhet; Base: 10; Vsp: 1; Package: RPRS -*-

(DEFRHETPRED HAS-STEP-RECURSIVE (&BOUND ?STEP-TYPE*T-TYPE ?STEP-CF*T-ANYTHING
                                        &ANY ?PLAN-TYPE*T-ATOM
                                        &UNBOUND ?ASSERTION-LIST*T-LIST)
  "True for a ?step-type in rplan ?plan-type making assertions in ?assertion-list,
whose CAR is a plan type, and CADR is the step number in the plan to be asserted equal to the step, 
and whose CDDR is another assertion-list (whose object is this just defined thing.)

i.e. (t-foo-plan s1 t-bar-plan s2) means that the passed step is s1 in t-foo-plan, and this t-foo-plan
instance is s2 of a t-bar-plan."
  )                                     ;nothing declared here, since our RHSs need different LHSs...
(ASSERT-AXIOMS
 [[HAS-STEP-RECURSIVE ?STEP-TYPE*T-TYPE ?STEP-CF*T-ANYTHING ?RPLAN-TYPE*T-ATOM ?A-LIST*T-LIST]
  <RPRS [HAS-STEP :CPLAN ?CPLAN-TYPE*T-LISP ?MATCHED-STEP-TYPE*T-LISP ?STEP*T-ATOM]
  [NOT [TYPE-RELATION ?STEP-TYPE :DISJOINT ?MATCHED-STEP-TYPE]]
  [SETVALUE ?CPLAN-TYPE-ITYPE*T-TYPE (MAKE-I-TYPE ?CPLAN-TYPE)]
  [HAS-STEP-RECURSIVE ?CPLAN-TYPE-ITYPE (?CPLAN-TYPE (?STEP*T-ATOM ?STEP-CF*T-ANYTHING)) ?RPLAN-TYPE ?A-LIST]]
 [[HAS-STEP-RECURSIVE ?STEP-TYPE*T-TYPE ?STEP-CF*T-ANYTHING ?RPLAN-TYPE*T-ATOM
                      (?RPLAN-TYPE*T-ATOM (?STEP*T-ATOM ?STEP-CF*T-ANYTHING))]
  <RPRS [HAS-STEP :RPLAN ?RPLAN-TYPE ?MATCHED-STEP-TYPE*T-LISP ?STEP]
  [NOT [TYPE-RELATION ?STEP-TYPE :DISJOINT ?MATCHED-STEP-TYPE]]]
 )


(DEFRHETPRED NULL (?TERM*T-LISP)
  <RPRS [UNIFY ?TERM NIL])

(DEFRHETPRED APPEND (?XS*T-LIST ?YS*T-LIST ?ZS*T-LIST)
  "?Zs is the result of appending ?Xs to ?Ys")

(ASSERT-AXIOMS
  [[APPEND () ?Ys*T-LIST ?Ys] <RPRS]
  [[APPEND (?X*T-ANYTHING . ?Xs) ?Ys*T-LIST (?X . ?Zs)] <RPRS [APPEND ?Xs ?Ys ?Zs]]
  )

#[		;keep ?step-type from being detected as "different".
(DEFRHETPRED COVER-INITIAL-OBSERVATION (?STEP*T-U ?PLAN-LIST*T-LIST)
  <RPRS [TYPE? ?STEP ?STEP-TYPE*T-TYPE]
	[SETVALUE ?PLAN-LIST-PROTOTYPE*T-LIST
		  (PROVE-ALL [HAS-STEP-RECURSIVE ?STEP-TYPE ?STEP ?RPLAN-TYPE*T-ATOM ?ASSERT-LIST*T-LIST] :MODE :SIMPLE)]
	[PROOF-LIST-TO-STEP-LIST ?PLAN-LIST-PROTOTYPE ?PLAN-LIST]
	)
#]

(ASSERT-AXIOMS
   [[PROOF-LIST-TO-STEP-LIST NIL NIL] <RPRS]
  [[PROOF-LIST-TO-STEP-LIST ([HAS-STEP-RECURSIVE ?STEP-TYPE*T-TYPE ?STEP*T-U ?RPLAN-TYPE*T-LISP ?ASSERT-LIST*T-LIST] . ?MORE-PROOFS)
	(?ASSERT-LIST . ?MORE-PLAN-LISTS)]
   <RPRS [PROOF-LIST-TO-STEP-LIST ?MORE-PROOFS ?MORE-PLAN-LISTS]]
)

(ASSERT-AXIOMS
   [[MERGE-PLAN-INSTANCES ?PLAN-TYPE*T-LISP ?PLAN-STEPS*T-LIST NIL NIL] <RPRS]
  [[MERGE-PLAN-INSTANCES ?PLAN-TYPE*T-LISP
			 ?PLAN-STEPS*T-LIST
			 ((?PLAN-TYPE . ?OLD-PLAN-STEPS*T-LIST) . ?MORE-OLD-PLANS*T-LIST)
			 ?MERGED-PLANS*T-LIST]
   <RPRS [COND ([MERGE-STEPS ?PLAN-STEPS ?OLD-PLAN-STEPS ?MERGED-STEPS*T-LIST]
		[UNIFY ((?PLAN-TYPE . ?MERGED-STEPS) . ?MORE-NEW-PLANS) ?MERGED-PLANS]
		[MERGE-PLAN-INSTANCES ?PLAN-TYPE ?PLAN-STEPS ?MORE-OLD-PLANS ?MORE-NEW-PLANS])
	       ([WIN]
		[MERGE-PLAN-INSTANCES ?PLAN-TYPE ?PLAN-STEPS ?MORE-OLD-PLANS ?MERGED-PLANS])]]

)

(ASSERT-AXIOMS
   [[MERGE-STEPS NIL ?OLD-STEPS*T-LIST ?OLD-STEPS] <RPRS]
  [[MERGE-STEPS ((?STEP*T-ATOM ?OBS*T-ANYTHING) . ?MORE-STEPS) ?OLD-PLAN-STEPS*T-LIST ?MERGED-STEPS*T-LIST]
   <RPRS [MERGE-STEP ?STEP ?OBS ?OLD-PLAN-STEPS ?UPDATED-STEPS*T-LIST]
	 [MERGE-STEPS ?MORE-STEPS ?UPDATED-STEPS ?MERGED-STEPS]]
)

(ASSERT-AXIOMS
   [[MERGE-STEP ?STEP*T-ATOM ?OBS*T-ANYTHING NIL (?STEP ?OBS)] <RPRS]
  [[MERGE-STEP ?STEP*T-ATOM
	       ?OBS*T-ANYTHING
	       ((?OLD-STEP*T-ATOM ?OLD-OBS*T-ANYTHING) . ?MORE-OLD-STEPS*T-LIST)
	       ((?OLD-STEP ?OLD-OBS) (?STEP ?OBS) . ?MORE-OLD-STEPS)]
   <RPRS ]	;may eventually want to check compatibility if ?old-step is eq to ?step
)


(ASSERT-AXIOMS
 [[COVER-OBSERVATION ?STEP NIL NIL] <RPRS]

  [ [COVER-OBSERVATION ?STEP ((?OLD-PLAN-TYPE*T-LISP . ?OLD-PLAN-STEPS) . ?MORE-OLD-PLANS) ?NEW-PLAN-LIST*T-LIST]
   <RPRS [TYPE? ?STEP ?STEP-TYPE*T-TYPE]
	 [SETVALUE ?NEW-PLAN-PROTOTYPES*T-LIST
		   (PROVE-ALL [HAS-STEP-RECURSIVE ?STEP-TYPE ?STEP ?OLD-PLAN-TYPE ?ASSERTIONS*T-LIST] :MODE :SIMPLE)]
	 [PROOF-LIST-TO-STEP-LIST ?NEW-PLAN-PROTOTYPES ?NEW-PLAN-LIST-1*T-LIST]
	 [MERGE-PLAN-INSTANCES ?OLD-PLAN-TYPE ?OLD-PLAN-STEPS ?NEW-PLAN-LIST-1 ?MERGED-PLAN-LIST*T-LIST]
	 [COVER-OBSERVATION ?STEP ?MORE-OLD-PLANS ?NEW-PLAN-LIST-2*T-LIST]
	 [APPEND ?MERGED-PLAN-LIST ?NEW-PLAN-LIST-2 ?NEW-PLAN-LIST]]
  
  )

#[
(DEFRHETPRED COVER-OBSERVATIONS ((?STEP*T-U . ?STEP-LIST*T-LIST) ?NEW-PLAN-LIST*T-LIST)
   <RPRS [COND									; we didn't really need the cond,
	   ([NULL ?STEP-LIST]							; but it's an example, after all.
	    [COVER-INITIAL-OBSERVATION ?STEP ?NEW-PLAN-LIST])
	   ([WIN]
	    [COVER-OBSERVATIONS ?STEP-LIST ?NEW-PLAN-LIST-1*T-LIST]
	    [COVER-OBSERVATION ?STEP ?NEW-PLAN-LIST-1 ?NEW-PLAN-LIST])]
	 )
#]
