;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? various macros to make life in lisp pleasanter

;;;    
;;;    
;; tools
;;	11/5/90 mts - added conditional code for me macro.


(eval-when (load eval compile)
  
(require 'pretools)

(provide 'tools)

(defmacro comment (&rest args) nil)



(comment defmacro tconc (&optional x y)
  (cond (y
	 `(mlet ((x ,x) (y ,y))
		(let ((tail (list y)))
		  (cond ((null x) (list tail tail))
			((null (cdr x))
			 (setf (car x) tail)
			 (setf (cdr x) (list tail)))
			(t (setf (cdr (cadr x)) tail)
			   (setf (cadr x) tail)))
		  )))
	(t `(list nil)))
  )

(defmacro tconc (&optional x (y nil yp))
  (let ((xvar (gensym "X"))
	(yvar (gensym "Y"))
	(tvar (gensym "TAIL")))
    (cond (yp
	   `(let ((,yvar ,y))
	      (let ((,xvar ,x)
		    (,tvar (list ,yvar)))
		(cond ((null ,xvar) (list ,tvar ,tvar))
		      ((null (cdr ,xvar))
		       (setf (car ,xvar) ,tvar)
		       (setf (cdr ,xvar) (list ,tvar)))
		      (t (setf (cdr (cadr ,xvar)) ,tvar)
			 (setf (cadr ,xvar) ,tvar)))
		)))
	  (x x)
	  (t `(list nil))))
  )

(defmacro rconc (&optional x (y nil yp))
  (let ((xvar (gensym "X"))
	(yvar (gensym "Y"))
	(tvar (gensym "TAIL")))
    (cond (yp
	   `(let ((,yvar ,y))
	      (let ((,xvar ,x)
		    (,tvar ,yvar))
		(cond ((null ,xvar) (list ,tvar ,tvar))
		      ((null (cdr ,xvar))
		       (setf (car ,xvar) ,tvar)
		       (setf (cdr ,xvar) (list ,tvar)))
		      (t (setf (cdr (cadr ,xvar)) ,tvar)
			 (setf (cadr ,xvar) ,tvar)))
		)))
	  (x x)
	  (t `(list nil))))
  )

(defmacro getd (symbol)
  (let ((svar (gensym "S")))
    `(let ((,svar ,symbol)) (and (symbolp ,svar) (fboundp ,svar) (symbol-function ,svar)))
    )
  )







(defmacro dbg-print (&rest items)
  `(print (list ,@items))
  )




(defmacro plist (x)
  `(mlet ((x ,x))
     (cond ((symbolp x) (symbol-plist x))
	   (t :not-symbol))
     )
  )


(defmacro while (condition &body statements)
  `(do nil ((not ,condition)) ,@statements)
  )



(defmacro tconc-unique (holder item)
  `(mlet ((holder ,holder)
	 (item ,item))
     (if (not (member item (car holder) :test #'equal)) (tconc holder item))
     )
  )


(defmacro lconc (&optional x y)
  (let ((xvar (gensym "X"))
	(yvar (gensym "Y"))
	(tvar (gensym "TAIL")))
    (cond (y
	   `(let ((,yvar ,y))
	      (let ((,xvar ,x)
		    (,tvar (copy-list ,yvar)))
		(cond ((null ,yvar)
		       (if (null ,xvar) (list nil) ,xvar))
		      ((null ,xvar) (list ,tvar (last ,tvar)))
		      ((null (cdr ,xvar))
		       (setf (car ,xvar) ,tvar)
		       (setf (cdr ,xvar) (list (last ,tvar))))
		      (t (setf (cdr (cadr ,xvar)) ,tvar)
			 (setf (cadr ,xvar) (last ,tvar))))
		)))
	  (x x)
	  (t `(list nil))))
  )
)


(eval-when (load compile eval)

(defmacro ifn (cond &body body)
  (do ((then (tconc nil))
       (bodyp body (cdr bodyp)))
      ((or (null bodyp) (eq (car bodyp) 'else)) `(if ,cond (progn ,@(car then)) (progn ,@(cdr bodyp))))
    (tconc then (car bodyp)))
  )

)



(defmacro neq (x y)
  `(not (eq ,x ,y))
  )



(defmacro neql (x y)
  `(not (eql ,x ,y))
  )


(defmacro ++ (arg &optional val)
  `(setf ,arg (+ ,arg ,(if val val 1)))
  )




(defmacro -- (arg &optional val)
  `(setf ,arg (- ,arg ,(if val val 1)))
  )



(defmacro doloop (&rest args)
  ;;- Thu Apr 18 08:47:08 1991 by kramer - added :gen keyword to :for loops to handle basic clos generators  
  ;;- Wed Apr 17 11:54:50 1991 by kramer - add :iter* :var* :for* , :for var :from expr :upto expr :by expr, also :else 
  ;;- Tue Apr 16 09:25:32 1991 by kramer - added :exists, :every, :all, :some keywords  
  ;;- Tue Apr 16 09:25:04 1991 by kramer - added :init keyword to :collect, :splice  
  (macrolet ((return-tag nil `(progn (if (not return-tag) (setq return-tag (gensym "ret"))) return-tag)))
    (let* ((body (if (consp (car args)) (cdr args) args))
	   (user-var (if (consp (car args)) (caar args)))
	   (user-list (if user-var (cadar args)))
	   (cdr-expr (if user-var (cddar args))))
      (let* ((tail-var (if user-var (gensym "tail-var")))
	     (tail-fn (or (car cdr-expr) 'cdr))
	     (vars (if tail-var (lconc nil `((,tail-var ,user-list) ,user-var)) (tconc nil)))
	     (result-expr nil)
	     (go-tag (gensym "go"))
	     (return-tag nil)
	     (real-body (lconc nil))
	     (final-body (tconc))
	     (for-var nil)
	     (for-var-iterate-p nil)
	     (iterate-body (lconc))
	     (init-body (lconc))
	     when-tag when-end when-extension)
	(while body
	  (setq when-extension nil)
	  (case (car body)
	    ((:for :vars :iter :iterate)
	     (cond ((not (listp (cadr body)))
		    (when (and for-var (not for-var-iterate-p))
		      (tconc iterate-body `(setq ,for-var (+ ,for-var 1))))
		    (setq for-var (cadr body))
		    (setq for-var-iterate-p nil)
		    (tconc vars (cadr body)))
		   (t (do ((varp (if (member (car body) '(:iter :iterate :for)) (list (cadr body)) (cadr body)) (cdr varp)))
			  ((null varp))		
			(when (and for-var (not for-var-iterate-p) (not (listp (car varp))))
			  (tconc iterate-body `(setq ,for-var (+ ,for-var 1))))	
			(setq for-var (if (not (listp (car varp))) (car varp) (caar varp)))
			(if (or
			     (not (eq (car body) :for))
			     (and (listp (car varp)) (cddr (car varp))))
			  (setq for-var-iterate-p t)
			  (setq for-var-iterate-p nil))
			(cond ((or (not (listp (car varp))) (= (length (car varp)) 2))
			       (tconc vars (car varp)))
			      ((member (car body) '(:iter :iterate))
			       (tconc vars (list (caar varp) (cadar varp)))
			       (tconc iterate-body `(setq ,(caar varp) ,@(cddar varp))))
			      (t
			       (tconc vars (list (caar varp) (cadar varp)))
			       (tconc real-body `(setq ,(caar varp) ,@(cddar varp))))))))
	     (setq body (cddr body)))
	    ((:var* :iter* :for*)
	     (if (not (listp (cadr body))) (error "Keyword ~a requires list" (car body)))
	     (do ((varp (cadr body) (cdr varp))
		  var)
		 ((null varp))
	       (setq var (car varp))
	       (cond ((not (listp var)) (tconc vars var))
		     (t (tconc vars (car var))
			(if (cdr var) (tconc init-body `(setq ,(car var) ,(cadr var))))
			(if (cddr var) (tconc iterate-body `(setq ,(car var) ,@(cddr var)))))
		     ))
	     (setq body (cddr body)))
	    ((:gen :generator :generate)
	     (if (not for-var) (error "DOLOOP: no for variable (:generate clause)"))
	     (let ((cvar (gensym "GENERATOR")))
	       (tconc vars `(,cvar ,(cadr body)))
	       (tconc iterate-body `(next ,cvar))     
	       (tconc real-body `(if (not (active ,cvar)) (go ,(return-tag))))
	       (tconc real-body `(setq ,for-var (value ,cvar)))
	       (setq for-var nil)
	       (setq body (cddr body))
	       (ifn (member (car body) '(:init :initialize))
		 (tconc init-body (subst cvar '*gen* (cadr body)))
		 (setq body (cddr body))
		 )
	       ))
	    ((:=)
	     (if (not for-var) (error "DOLOOP: no for variable (:= clause)"))
	     (if for-var-iterate-p (error "DOLOOP: variable has iterate clause '~a' (:= clause)" for-var))
	     (tconc real-body `(setq ,for-var ,(cadr body)))
	     (setq for-var-iterate-p t)
	     (setq body (cddr body)))
	    ((:set :set-to :setto :is)
	     (if (not for-var) (error "DOLOOP: no for variable (:from clause)"))
	     (tconc init-body `(setq ,for-var ,(cadr body)))
	     (setq for-var-iterate-p t)
	     (setq body (cddr body)))
	    ((:from)
	     (if (not for-var) (error "DOLOOP: no for variable (:from clause)"))
	     (tconc init-body `(setq ,for-var ,(cadr body)))
	     (setq body (cddr body)))
	    ((:upto :to)
	     (if (not for-var) (error "DOLOOP: no for variable (:upto clause)"))
	     (let ((cvar (gensym "FORLIMIT")))
	       (tconc vars `(,cvar ,(cadr body)))
	       (tconc real-body `(if (> ,for-var ,cvar) (go ,(return-tag)))))
	     (setq body (cddr body)))
	    ((:downto)
	     (if (not for-var) (error "DOLOOP: no for variable (:downto clause)"))
	     (let ((cvar (gensym "FORLIMIT")))
	       (tconc vars `(,cvar ,(cadr body)))
	       (tconc real-body `(if (< ,for-var ,cvar) (go ,(return-tag)))))
	     (setq body (cddr body)))
	    ((:by)
	     (if (not for-var) (error "DOLOOP: no for variable (:by clause)"))
	     (if for-var-iterate-p (error "DOLOOP: variable has iterate clause '~a' (:by clause)" for-var))
	     (setq for-var-iterate-p t)
	     (tconc iterate-body `(setq ,for-var (+ ,for-var ,(cadr body))))
	     (setq body (cddr body)))
	    ((:in)
	     (if (not for-var) (error "DOLOOP: no for variable (:in clause)"))
	     (if for-var-iterate-p (error "DOLOOP: variable has iterate clause '~a' (:in clause)" for-var))
	     (setq for-var-iterate-p t)
	     (let ((cvar (gensym "IN")))
	       (lconc init-body `((setq ,cvar ,(cadr body))
				  (setq ,for-var (if (listp ,cvar) (car ,cvar)))))
	       (tconc vars `(,cvar nil))
	       (lconc iterate-body `((setq ,cvar (cdr ,cvar))
				     (setq ,for-var (if (listp ,cvar) (car ,cvar)))))
	       )
	     (setq body (cddr body)))
	    ((:on)
	     (if (not for-var) (error "DOLOOP: no for variable (:on clause)"))
	     (if for-var-iterate-p (error "DOLOOP: variable has iterate clause '~a' (:on clause)" for-var))
	     (setq for-var-iterate-p t)
	     (lconc init-body `((setq ,for-var ,(cadr body))))
	     (tconc real-body `(if (null ,for-var) (go ,(return-tag))))
	     (lconc iterate-body `((if (consp ,for-var) (setq ,for-var (cdr ,for-var)))))
	     (setq body (cddr body)))
	    ((:then)
	     (if (not for-var) (error "DOLOOP: no for variable (:by clause)"))
	     (if for-var-iterate-p (error "DOLOOP: variable has iterate clause '~a' (:by clause)" for-var))
	     (setq for-var-iterate-p t)
	     (tconc iterate-body `(setq ,for-var ,(cadr body)))
	     (setq body (cddr body)))
	    ((:return :result)
	     (if when-end
	       (tconc real-body `(return ,(cadr body)))
	       (setq result-expr (cadr body)))
	     (setq body (cddr body)))
	    (:find (let ((rvar (gensym "v")))
		     (tconc vars rvar)
		     (lconc real-body `((setq ,rvar ,(cadr body)) (if ,rvar (return ,rvar))))
		     )
		   (setq body (cddr body)))
	    (:until (tconc real-body `(if ,(cadr body) (go ,(return-tag))))
		    (setq body (cddr body)))
	    (:while (tconc real-body `(if (not ,(cadr body)) (go ,(return-tag))))
	      (setq body (cddr body)))
	    ((:all :every) (setq result-expr t)
		    (tconc real-body `(when (not ,(cadr body)) (return nil)))
		    (setq body (cddr body)))
	    ((:some :exists) (setq result-expr nil)
		    (tconc real-body `(when ,(cadr body) (return t)))
		    (setq body (cddr body)))
	    ((:accumulate :acc)
	     (let ((cvar (gensym "ACC"))
		   (expr (cadr body))
		   (fn '+))
	       (setq result-expr cvar)
	       (setq body (cddr body))
	       (ifn (eq (car body) :init)
		 (tconc vars `(,cvar ,(cadr body)))
		 (setq body (cddr body))
		else
		 (tconc vars `(,cvar 0))
		 )
	       (ifn (eq (car body) :fn)
		 (setq fn (cadr body))
		 (setq body (cddr body))
		 )
	       (tconc real-body `(setq ,cvar (,fn ,cvar ,expr)))
	       ))
	    ((:count)
	     (let ((cvar (gensym "COUNT")))
	       (setq result-expr cvar)
	       (tconc real-body `(setq ,cvar (+ ,cvar 1)))
	       (setq body (cdr body))
	       (ifn (eq (car body) :init)
		 (tconc vars `(,cvar ,(cadr body)))
		 (setq body (cddr body))
		else
		 (tconc vars `(,cvar 0))
		 )))
	    ((:total :sum)
	     (let ((cvar (gensym "sum"))
		   (expr (cadr body)))
	       (setq result-expr cvar)
	       (tconc real-body `(setq ,cvar (+ ,cvar ,expr)))
	       (setq body (cddr body))
	       (ifn (eq (car body) :init)
		 (tconc vars `(,cvar ,(cadr body)))
		 (setq body (cddr body))
		else
		 (tconc vars `(,cvar 0))
		 )))     
	    (:collect (let ((cvar (gensym "COLLECT"))
			    (expr (cadr body)))
			(setq result-expr `(car ,cvar))
			(if (eq (caddr body) :init)
			  (progn
			    (tconc vars `(,cvar (lconc nil ,(cadddr body))))
			    (setq body (cddddr body))
			    )
			  (progn
			    (tconc vars `(,cvar (tconc nil)))
			    (setq body (cddr body))
			    ))
			(tconc real-body `(tconc ,cvar ,expr))
			(ifn (eq (car body) :tail)
			  (tconc final-body `(lconc ,cvar ,(cadr body)))
			  (setq body (cddr body)))
			(ifn (eq (car body) :atom-tail)
			  (tconc final-body `(if (not (consp ,tail-var))
					       (let ((,(cadr body) ,tail-var))
						 (rconc ,cvar ,(caddr body)))))
			  (setq body (cdddr body)))
			))
	    (:splice (let ((cvar (gensym "SPLICE"))
			   (expr (cadr body)))
		       (setq result-expr `(car ,cvar))
		       (if (eq (caddr body) :init)
			 (progn
			   (tconc vars `(,cvar (lconc nil ,(cadddr body))))
			   (setq body (cddddr body))
			   )
			 (progn
			   (tconc vars `(,cvar (tconc nil)))
			   (setq body (cddr body))
			   ))
		       (tconc real-body `(lconc ,cvar ,expr))		       
		       (ifn (eq (car body) :tail)
			 (tconc final-body `(lconc ,cvar ,(cadr body)))
			 (setq body (cddr body)))
		       (ifn (eq (car body) :atom-tail)
			 (tconc final-body `(if (not (consp ,tail-var))
					      (let ((,(cadr body) ,tail-var))
						(rconc ,cvar ,(caddr body)))))
			 (setq body (cdddr body)))))
	    ((:if :when)
	     (setq when-tag (gensym "WHEN"))
	     (when when-end
	       (tconc real-body when-end)
	       (setq when-end nil))
	     (tconc real-body `(if (not ,(cadr body)) (go ,when-tag)))
	     (setq body (cddr body)))
	    ((:else :elseif :elsewhen)
	     (if (null when-end) (error "~%DOLOOP: else without when~%"))
	     (setq when-tag (gensym "when-end"))
	     (lconc real-body `((go ,when-tag) ,when-end))
	     (ifn (member (car body) '(:elseif :elsewhen))
	       (lconc real-body `((if (not ,(cadr body)) (go ,when-tag))))
	       (setq body (cddr body))
	      else
	       (setq body (cdr body))
	       )
	     (setq when-end nil))
	    ((:end) (setq body (cdr body)))
	    (t (setq when-extension t)
	       (tconc real-body (car body))
	       (setq body (cdr body))))
	  (when (and (not when-extension) when-end (not (member (car body) '(:else :elseif :elsewhen))))
	    (tconc real-body when-end)
	    (setq when-end nil))
	  (when when-tag
	    (setq when-end when-tag)
	    (setq when-tag nil))
	  )
	(when when-end
	  (tconc real-body when-end))
	(when (and for-var (not for-var-iterate-p))
	  (tconc iterate-body `(setq ,for-var (+ ,for-var 1))))
	`(prog* ,(car vars)
	   ,@(car init-body)
	   ,go-tag
	   ,@(if tail-var `((if (not (consp ,tail-var))
			      (go ,(return-tag)))))
	   ,@(if user-var `((setq ,user-var (car ,tail-var))))
	   ,@(car real-body)
	   ,@(if tail-var `((setq ,tail-var (,tail-fn ,tail-var))))
	   ,@(car iterate-body)
	   (go ,go-tag)
	   ,@(if return-tag `(,return-tag ,@(car final-body) (return ,result-expr)))
	   )
	)))
  )
	

(defmacro dofind ((var init) pred &body body)
  `(doloop (,var ,init) :vars ((result nil)) :until result :result result ,@body (setq result ,pred))
  )

(defmacro pretty-time (universal-time &optional (suppress 't))
  (if suppress
      `(mlet ((time ,universal-time))
	 (cond ((eq time :+) "+")
	       ((eq time :-) "-")
	       (t 
		(multiple-value-bind
		    (now-sec now-min now-hr now-day now-month now-year) (get-decoded-time)
		  (multiple-value-bind
		      (sec min hr day month year) (decode-universal-time time)
		    (if (and (eq year now-year) (eq month now-month) (eq day now-day))
			(format nil "~d:~d:~d" hr min sec)
		      (format nil "~d/~d/~d-~d:~d:~d" year month day hr min sec)
		      )
		    )
		  ))))
    `(mlet ((time ,universal-time))
       (cond ((eq time :+) "+")
	     ((eq time :-) "-")
	     (t 
	      (multiple-value-bind
		  (sec min hr day month year) (decode-universal-time time)
		(format nil "~d/~d/~d-~d:~d:~d" year month day hr min sec)
		)
	      )))
    ))

;;; (for (var start incr) limit ,@expressions)

(defmacro for (varphrase end &body exprs)
  (let ((var (if (listp varphrase) (car varphrase) varphrase))
	(start (if (and (listp varphrase) (cdr varphrase))
		   (cadr varphrase)
		 0))
	(incr (if (and (listp varphrase) (cddr varphrase))
		  (caddr varphrase)
		1)))
    `(do ((,var ,start (+ ,incr ,var))
	  result)
	 ((>= ,var ,end) result)
       ,@exprs)
    )
  )

;; (use-struct <inst> (conc <field>> ... (<var> <field>)...) ,@expressions)

(defun use-struct-build (spec inst)
  (do ((conc (string (car spec)))
       (varp (cdr spec) (cdr varp))
       (result nil))
      ((null varp) result)
    (cond ((not (listp (car varp))) (push (cons (car varp) (list (find-symbol (concatenate 'string conc (string
													 (car varp))))
								 inst))
					  result))
	  (t (push (cons (caar varp) (list (cadar varp) inst)) result)))
    )
  )

(defmacro use-struct (inst field-spec &body expressions)
  (let ((alist (use-struct-build field-spec inst)))
    (cons 'progn (sublis alist expressions))
    )
  )




(defmacro incr (x) `(setf ,x (+ 1 ,x)))





(defun compute-destruct (pattern access)
  (cond ((null pattern) nil)
	((eq pattern '*) nil)
	((symbolp pattern) (list (list pattern access)))
	((consp pattern) (append (compute-destruct (car pattern) (list 'car access))
				 (compute-destruct (cdr pattern) (list 'cdr access))))
	(t (error 'bad-thing-in-destruct)))
  )



(defmacro dlet* (vars &body body)
  `(let* ,(doloop (var vars)
	   :splice (if (or (not (consp var)) (not (consp (car var))))
		     (list var)
		     (if (not (symbolp (cadr var)))
		       (let ((access-var (gensym "dlet-var")))
			 `((,access-var ,(cadr var))
			   ,@(compute-destruct (car var) access-var))
			 )
		       (compute-destruct (car var) (cadr var))))
	    )
     ,@body)
  )


(defun dlet-proc (var-spec body)
  (doloop :for ptr :from var-spec :then (cdr ptr)
   :for vars :set (tconc)
   :if (null ptr) :return (if (car vars) `(let* ,(car vars) ,@body) `(progn ,@body))
   :for spec := (car ptr)
   :if (or (not (consp spec)) (symbolp (car spec)))
    (tconc vars spec)
   :else
   :return (if (car vars)
	     `(let* ,(car vars) (destructuring-bind ,(car spec) ,(cadr spec) ,(dlet-proc (cdr ptr) body)))
	     `(destructuring-bind ,(car spec) ,(cadr spec) ,(dlet-proc (cdr ptr) body)))
    )
  )


(defmacro dlet (vars &body body)
  (dlet-proc vars body)
  )


(defmacro do-trace (&body body)
  `(when *trace* ,@body)
  )

(defvar *trace* nil)

(defmacro ptrace (&optional (arg :toggle))
  (case arg
    ((t on) `(setq *trace* t))
    ((nil off) `(setq *trace* nil))
    (:toggle `(setq *trace* (not *trace*)))
    (t `(setq *trace* (not (null ,arg))))
    )
  )


(defmacro force-string (item)
  `(mlet ((item ,item))(cond ((numberp item) (format nil "~d" item))
			    ((stringp item) item)
			    ((symbolp item) (string item))
			    (t (format nil "~s" item))))
  )


(defmacro lp (form)
  `(prog1
       t
     (excl::errorset
      (let ((lisp:*print-circle* t)
	    (lisp:*print-pretty* t)
	    (lisp:*print-level* nil)
	    (lisp:*print-length* nil)
	    ;;(lisp:*print-readably* nil) ;; an x3j13 thang
	    (excl::*print-nickname* t))
	(lisp:prin1 ,form)
	))
     )
  )


#-:ccl
(defmacro me (form)
  `(prog1
       t
     (excl::errorset
      (let ((lisp:*print-circle* t)
	    (lisp:*print-pretty* t)
	    (lisp:*print-level* nil)
	    (lisp:*print-length* nil)
	    ;;(lisp:*print-readably* nil) ;; an x3j13 thang
	    (excl::*print-nickname* t))
	(lisp:prin1 (macroexpand-1 ,form))
	))
     )
  )


#+zzdafsdfe(defmacro me (form)
  `(let ((top-level:*print-level* 50)
	(top-level:*print-length* 150)
	(*print-level* 50)
	(*print-length* 150))
    (macroexpand-1 ,form))
  )
#+:ccl
(defmacro me (form)
  `(let ((*print-level* 50)
	(*print-length* 150))
    (macroexpand-1 ,form))
  )


#-:ccl
(defmacro deep-print (form)
  `(let ((top-level:*print-level* 50)
	(top-level:*print-length* 150)
	(*print-level* 50)
	(*print-length* 150))
     (print ,form)
     t)
  )
#+:ccl
(defmacro deep-print (form)
  `(let ((*print-level* 50)
	(*print-length* 150))
    (print ,form)
    t)
  )

(defmacro truep (expr)
  `(not (null ,expr))
  )



(defmacro args (expr)
  `(arglist ,expr)
  )



(defun my-compile (supplied-name paths)
  (let* ((fasl (merge-pathnames supplied-name (car paths)))
	 (cl (doloop)))))



(defmacro rtime (&body forms)
  `(mlet ((*trace-output* (make-string-output-stream)))
     (time (progn ,@forms))
     (get-output-stream-string *trace-output*)
     )
  )


(defmacro file-path (name &optional (proto "foo.log"))
  `(mlet ((file-name ,name))
     (merge-pathnames (if (symbolp file-name)
			(string-downcase (force-string file-name))
			(force-string file-name))
		      (merge-pathnames ,proto))
     )
   )

(defun rfind (thing tree)
  (cond ((equal thing tree) t)
	((consp tree) (or (rfind thing (car tree)) (rfind thing (cdr tree))))
	))


(defun lisp-grep (file-name atom &optional (output t))
  (let ((path (file-path file-name)))
    (if (open path :direction :probe)
      (with-open-stream (ostream (if (eql output t)
				   (make-broadcast-stream *standard-output*)
				   (if (streamp output)
				     (make-broadcast-stream output)
				     (open (file-path output) :direction :output)
				     )))
	(with-open-file (input-stream path :direction :input)
	  (do ((x nil))
	      ((eq x 'done))
	    (setq x (read input-stream nil 'done))
	    (when (rfind atom x)
	      (print x ostream)
	      )
	    ))
	))
    ))


(defmacro build-symbol (&rest pieces)
  `(intern (string-upcase (concatenate 'string ,@(mapcar #'(lambda (x) (list 'string x)) pieces))))
  )


(defmacro build-keyword (&rest pieces)
  `(intern (string-upcase (concatenate 'string ,@(mapcar #'(lambda (x) (list 'string x)) pieces)))
	   'keyword)
  )


(defmacro case-string= (sel &rest cases)
  `(let ((key ,sel))
     (cond ((not (stringp key)) nil)
	   ,@(do ((case-tail cases (cdr case-tail))
		  (result (tconc)))
		 ((null case-tail) (car result))
	       (if (eq (caar case-tail) t)
		 (tconc result (car case-tail))
		 (tconc result `((string= ,(caar case-tail) key) ,@(cdar case-tail)))
		 ))
	   ))
  )

(defun def-cond-struct-slots (name pairs slots)
  (doloop (slot-name slots)
    :for conc := (or (doloop (p pairs)
		       :when (and (consp p) (eq (car p) :conc-name))
		       :return (cadr p))
		     (build-symbol name '-))
    :collect `(,slot-name
	       :initform nil
	       :accessor ,(build-symbol conc slot-name)
	       :initarg ,(intern slot-name 'keyword))
    )
  )

(defun def-cond-struct-inspect (name pairs slots)
  (doloop (slot-name slots)
    :for conc := (or (doloop (p pairs)
		       :when (and (consp p) (eq (car p) :conc-name))
		       :return (cadr p))
		     (build-symbol name '-))
    :collect `(list ',slot-name (,(build-symbol conc slot-name) obj))
    )
  )


(defvar *build-clos* nil)

(defmacro def-cond-struct ((name &rest pairs) &rest slots)
  (if *build-clos*
    `(progn (defclass ,name nil ,(def-cond-struct-slots name pairs slots))
	    (defmacro ,(build-symbol "make-" name) (&rest args)
	      `(make-instance ',',name ,@args))
	    (defmacro ,(build-symbol name "-p") (x)
	      (list 'typep x (list 'quote ',name))))
    `(progn (defstruct (,name ,@pairs) ,@slots)
	    (defmethod graphical-inspect ((obj ,name))
	       (list ,@(def-cond-struct-inspect name pairs slots)))
	    )
    )
  )


(defmacro protected-bind (vars &body body)
  (let ((save-vars (doloop (var vars)
		     :collect (if (listp var)
				(list (gensym (concatenate 'string "OLD-" (string (car var))))
				      (car var))
				(list (gensym (concatenate 'string "OLD-" (string var)))
				      var)))))
    `(let ,save-vars
       (unwind-protect
	   (progn
	     ,@(doloop (var vars)
		 :when (listp var)
		 :collect `(setf ,@var)
		 )
	     ,@ body)
	 ,@(doloop (vsave save-vars)
	     :collect `(setf ,(cadr vsave) ,(car vsave))
	     )))
    )
  )


(defmacro add-bucket (alist-var key item)
  (let ((bucket (gensym "bucket"))
	(key-var (gensym "key")))
    `(let* ((,key-var ,key)
	   (,bucket (assoc ,key-var ,alist-var)))
     (if (null ,bucket)
       (push (list ,key-var ,item) ,alist-var)
       (push ,item (cdr ,bucket))
       )
     ))
  )



(defmacro if! (&body body)
  (let ((result (tconc nil 'cond)))
    (doloop :vars ((tail body))
     :while tail
      (tconc result
	     (doloop :while (and tail
				 (or (not (symbolp (car  tail)))
				     (and (not (string-equal (string (car tail)) "else"))
					  (not (string-equal (string (car tail)) "elseif"))
					  )))
	      :collect (car tail)
	       (setf tail (cdr tail))
	       )
	     )
      (if (and tail (symbolp (car tail)) (string-equal (string (car tail)) "else"))
	(setf tail (cons t (cdr tail)))
	(setf tail (cdr tail))
	)
      )
    (car result))
  )


(defmacro truncate-string (str n)
  (let ((nvar (gensym "N"))
	(svar (gensym "STR")))
    `(let ((,svar ,str)
	   (,nvar ,n))
       (if (> (length ,svar) ,nvar)
	 (subseq ,svar ,0 ,nvar)
	 ,svar))
    )
  )




(defmacro intersect-p (path1 path2)
  (let ((h (gensym "H")))
    `(doloop (,h ,path1) :some (member ,h ,path2))
    )
  )



(defvar lisp:*print-readably* nil)


(defmacro format-l (&rest args)
  `(let ((lisp:*print-circle* nil)
	 (lisp:*print-pretty* nil)
	 (lisp:*print-level* 3)
	 (lisp:*print-length* 5)
	 (lisp:*print-readably* nil) ;; an x3j13 thang
	 (excl::*print-nickname* nil))
     (format ,@args)
     )
  )


(defmacro safe-length (x)
  `(doloop (y ,x) :count)
  )




(defun string-match-prefix (string1 string2)
  (let ((l1 (length string1))
	(l2 (length string2)))
    (cond ((> l1 l2) nil)
	  ((= l1 l2) (string-equal string1 string2))
	  (t (doloop :for i :from 0 :to (- l1 1)
	      :all (char-equal (aref string1 i) (aref string2 i))))
	  ))
  )

 

(defmacro macro-setup (vars &body body)
  (let ((pairs (doloop (v vars) :collect `(,v (gensym ,(string v))))))
    `(let ,pairs
       ,@body)
    )
  )