;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? functions to implement from, label, to, when from Telos


(defun telos-from (object)
  (cond ((kb-attr-p object) (attr-from object))
	((kb-token-p object) (tok-name object))
	((prop-object-p object) (prop-src object))
	(t object))
  )


(defun telos-label (object)
  (cond ((kb-attr-p object) (attr-label object))
	((kb-token-p object) (tok-name object))
	((prop-object-p object) (prop-type object))
	(t object))
  )


(defun telos-to (object)
  (cond ((kb-attr-p object) (attr-value object))
	((kb-token-p object) (tok-name object))
	((prop-object-p object) (prop-dest object))
	(t object))
  )


(defun telos-when (object)
  (cond ((kb-attr-p object) :not-implemented-yet)
	((kb-token-p object) :not-implemented-yet)
	((prop-object-p object) (prop-history object))
	(t *all-time*))
  )

(defun telos-attribute-propositions (object name)
  (if (kb-token-p object)
    (lookup-index-cdr (tok-attrs object) name)
    )
  )

(defun telos-instance-of-propositions (object name)
  (if (kb-token-p object)
    (tok-instance-of object)
    )
  )

(defun telos-is-a-propositions (object name)
  (if (kb-token-p object)
    (tok-parents object)
    )
  )



(defun most-specific-generalization (class &optional (history (default-history)) (belief (std-belief)))
  (let ((var (make-clause-var :name 'f :type history)))
    (let ((answers (ask-all `(is-a ,class $x ,var)))
	  (h history))
      (doloop (pair answers)
       :when (not (doloop (test answers)
		   :when (and (not (eq (car test) (car pair))) (setq h (type-isa (car test) (car pair) h belief)))
		   :return t))
       :collect (car pair)
	))
    )
  )
