(def-class test nil
  :slots ((x 10)
	  (y (* 3 2))
	  z)
  :mv ((a '(1 2 3))
       b)
  :private ((%fee 'fee)))

(def-method ({class test} fee :show :in-module)()
  (%fee $self))

(def-method ({class test} set-fee :in-module)(val)
  (setf (%fee $self) val))

(defsetf fee set-fee)

(new-instance* {class test})

(print (eq 'fee (fee {test 0})))
(setf (fee {test 0}) 100)
(print (eq 100 (fee {test 0})))

(remove-val {test 0} 'fee 100)
(print (not (bound? {test 0} 'fee)))

(print (eq 10 (x {test 0})))
(assert-val {test 0} 'z 100)
(print (eq 100 (z {test 0})))

(erase {test 0} 'y)
(print (not (bound? {test 0} 'y)))

(print (equal '(3 2 1) (a {test 0})))
(assert-vals {test 0} 'b '(1 2 3))
(print (bound? {test 0} 'b))
(erase {test 0} 'b)
(print (not (bound? {test 0} 'b)))
(print (frob-type? {test 0} {class test}))
