#|
**************************************************************************************
	File :  	propagate-symbolic
	Last Change :   13 nov 91
	Author :	dd

*************************************************************************************
|#

(defun propagate-symbolic-= (ro-obj_a ro-obj_b)
  (let ((*>-a  (real-ord-obj-*> ro-obj_a)) 
	(*<-a  (real-ord-obj-*< ro-obj_a))  
	(*>=-a (real-ord-obj-*>= ro-obj_a))  
	(*<=-a (real-ord-obj-*<= ro-obj_a))  
	(=-a  (real-ord-obj-= ro-obj_a))  
	(<>-a (real-ord-obj-<> ro-obj_a))  
	(*>-b  (real-ord-obj-*> ro-obj_b))
	(*<-b  (real-ord-obj-*< ro-obj_b))
	(*>=-b (real-ord-obj-*>= ro-obj_b))
	(*<=-b (real-ord-obj-*<= ro-obj_b))
	(=-b  (real-ord-obj-= ro-obj_b))
	(<>-b (real-ord-obj-<> ro-obj_b))
	)
       (let ((index_a (get-index (real-ord-obj-id ro-obj_a))))
	    (set-*> (bit-ior (bit-ior *>-a *>-b)
			     (bit-ior (bit-and *>=-a <>-b)
				      (bit-and *>=-b <>-a)))
		    ro-obj_a)
	    (set-*< (bit-ior (bit-ior *<-a *<-b)
			     (bit-ior (bit-and *<=-a <>-b)
				      (bit-and *<=-b <>-a)))
		    ro-obj_a)
	    (set-= (bit-ior (bit-ior =-a =-b)
			    (bit-ior (bit-and *>=-a *<=-b)  
				     (bit-and *>=-b *<=-a)))
		   ro-obj_a)
	    (set-<>  (bit-ior <>-a <>-b)
		     ro-obj_a)  
	    (set-*>= (bit-andc2 (bit-ior *>=-a *>=-b)  
				(bit-ior (bit-ior *>-b =-b)
					 =-a))
		     ro-obj_a)  
	    (set-*<= (bit-andc2 (bit-ior *<=-a *<=-b)  
				(bit-ior (bit-ior *<-b =-b)
					 =-a))
		     ro-obj_a)  
	    (set-same-index index_a (bit-andc2 (real-ord-obj-= ro-obj_a) =-a))
	    (propagate-=-rest (real-ord-obj-*> ro-obj_a)
			      (real-ord-obj-*< ro-obj_a)
			      (real-ord-obj-*>= ro-obj_a)
			      (real-ord-obj-*<= ro-obj_a)
			      (real-ord-obj-= ro-obj_a)
			      )
	    )))

(defun propagate-=-rest (*>a *<a *>=a *<=a =-a)
  (declare (special *index))
  (do ((counter 0 (1+ counter))
       (end (1+ *index)))
      ((= counter end))
      (let ((actual (get-obj counter)))
	   (cond ((set? counter *>a)
		  (set-*< (bit-ior (bit-ior (real-ord-obj-*< actual)
					    =-a)
				   (bit-ior *<a *<=a))
			  actual))
		 ((set? counter *<a)
		  (set-*> (bit-ior (bit-ior (real-ord-obj-*> actual)
					    =-a)
				   (bit-ior *>a *>=a))
			  actual))
		 ((set? counter *>=a)
		  (set-*<= (bit-ior (real-ord-obj-*<= actual)
				    (bit-ior =-a *<=a))
			   actual))
		 ((set? counter *<=a)
		  (set-*>= (bit-ior (real-ord-obj-*>= actual)
				    (bit-ior =-a *>=a))
			   actual)))
	   )))
		  
(defun propagate-symbolic-> (ro-obj_a ro-obj_b)
  (let ((index_a (get-index (real-ord-obj-id ro-obj_a)))
	(index_b (get-index (real-ord-obj-id ro-obj_b))))
       (let ((*>-a  (real-ord-obj-*> ro-obj_a))
	     (*>=-a  (real-ord-obj-*>= ro-obj_a))
	     (*<-a (real-ord-obj-*< ro-obj_a))
	     (*<-b  (real-ord-obj-*< ro-obj_b))
	     (*>-b (real-ord-obj-*> ro-obj_b))
	     (*<=-b (real-ord-obj-*<= ro-obj_b))
	     )
	    (cond ((set? index_b *<-a))
		  (t (set-*< (set-bit-weakly index_b (bit-ior (bit-ior *<-a *<-b)
						       *<=-b))
			     ro-obj_a)
		     (set-*> (set-bit-weakly index_a (bit-ior (bit-ior *>-b *>-a)
						       *>=-a))
			     ro-obj_b)
		     (set-*<= (bit-andc2 (real-ord-obj-*<= ro-obj_a)
					 (real-ord-obj-*< ro-obj_a))
			      ro-obj_a)
		     (set-*>= (bit-andc2 (real-ord-obj-*>= ro-obj_b)
					 (real-ord-obj-*> ro-obj_b))
			      ro-obj_b)
		     (propagate->-rest *>-a *>=-a 
				       (real-ord-obj-*< ro-obj_a)
				       *<-b *<=-b 
				       (real-ord-obj-*> ro-obj_b)
				       )
		     )))))

(defun propagate->-rest (*>-a *>=-a *<-a *<-b *<=-b *>-b)
  (declare (special *index))
  (do ((counter 0 (1+ counter))
       (end (1+ *index)))
      ((= counter end))
      (let ((actual (get-obj counter)))
	   (cond ((or (set? counter *>-a)
		      (set? counter *>=-a))
		  (set-*< (bit-ior (real-ord-obj-*< actual)
				   *<-a)
			  actual)
		  (set-*<= (bit-andc2 (real-ord-obj-*<= actual)
				      (real-ord-obj-*< actual))
			   actual))
		 ((or (set? counter *<-b)
		      (set? counter *<=-b))
		  (set-*> (bit-ior (real-ord-obj-*> actual)
				   *>-b)
			  actual)
		  (set-*>= (bit-andc2 (real-ord-obj-*>= actual)
				      (real-ord-obj-*> actual))
			   actual))
		 ))))

(defun propagate-symbolic->= (ro-obj_a ro-obj_b)
  (let ((index_a (get-index (real-ord-obj-id ro-obj_a)))
	(index_b (get-index (real-ord-obj-id ro-obj_b))))
	    (let ((*>-a  (real-ord-obj-*> ro-obj_a))
		  (*<-a  (real-ord-obj-*< ro-obj_a))
		  (*<=-a (real-ord-obj-*<= ro-obj_a))
		  (*>=-a (real-ord-obj-*>= ro-obj_a))
		  (*>-b  (real-ord-obj-*> ro-obj_b))
		  (*<-b  (real-ord-obj-*< ro-obj_b))
		  (*>=-b (real-ord-obj-*>= ro-obj_b))
		  (*<=-b (real-ord-obj-*<= ro-obj_b))
		  (<>-b  (real-ord-obj-<> ro-obj_b))
		  )
		 (cond ((set? index_b *>=-a)
			(propagate-symbolic-= ro-obj_a ro-obj_b))
		       ((set? index_a (bit-ior *>-b *>=-b)))
		       ((set? index_a <>-b)
			(propagate-symbolic-> ro-obj_a ro-obj_b))
		       (t (set-*< (bit-ior *<-a *<-b)
				  ro-obj_a)
			  (set-*<= (set-bit-weakly index_b (bit-andc2 (bit-ior *<=-b *<=-a) (real-ord-obj-*< ro-obj_a)))
				   ro-obj_a)
			  (set-*> (bit-ior *>-b *>-a)
				  ro-obj_b)
			  (set-*>= (set-bit-weakly index_a (bit-andc2 (bit-ior *>=-a *>=-b) (real-ord-obj-*> ro-obj_b)))
				   ro-obj_b)
			  (set-same-index index_a 
					  (bit-and (set-bit-weakly index_a 
								   (real-ord-obj-*>= ro-obj_a))
						   (set-bit-weakly index_b 
								   (real-ord-obj-*<= ro-obj_b))))
                          (propagate->=-rest *>-a *>=-a *<-b *<=-b
					     (real-ord-obj-*< ro-obj_a)
					     (real-ord-obj-*<= ro-obj_a)
					     (real-ord-obj-*> ro-obj_b)
					     (real-ord-obj-*>= ro-obj_b))
		       )))))	

(defun propagate->=-rest (*>a *>=a *<b *<=b *<a *<=a *>b *>=b)
  (declare (special *index))
  (do ((counter 0 (1+ counter))
       (end (1+ *index)))
      ((= counter end))
      (let ((actual (get-obj counter)))
	   (cond ((set? counter *>a)
		  (set-*< (bit-ior (real-ord-obj-*< actual)
				   (bit-ior *<=a *<a))
			  actual))
		 ((set? counter *>=a)
		  (set-*< (bit-ior (real-ord-obj-*< actual) *<a)
			  actual)
		  (set-*<= (bit-andc2 (bit-ior *<=a (real-ord-obj-*<= actual))
				      (real-ord-obj-*< actual))
			   actual))
		 ((set? counter *<b)
		  (set-*> (bit-ior (real-ord-obj-*> actual)
				   (bit-ior *>=b *>b))
			  actual))
		 ((set? counter *<=b)
		  (set-*> (bit-ior (real-ord-obj-*> actual) *>b)
			  actual)
		  (set-*>= (bit-andc2 (bit-ior *>=b (real-ord-obj-*>= actual))
				      (real-ord-obj-*> actual))
			   actual)))
	   )))

(defun propagate-symbolic-<> (ro-obj_a ro-obj_b)
  (let ((index_a (get-index (real-ord-obj-id ro-obj_a)))
	(index_b (get-index (real-ord-obj-id ro-obj_b))))
	    (let ((<>-a  (real-ord-obj-<> ro-obj_a))
		  (<>-b  (real-ord-obj-<> ro-obj_b))
		  )
		 (set-<> (set-bit-weakly index_b <>-a) ro-obj_a)
		 (set-<> (set-bit-weakly index_a <>-b) ro-obj_b)
		 (cond ((set? index_b (real-ord-obj-*<= ro-obj_a))
			(propagate-symbolic-> ro-obj_a ro-obj_b))
		       ((set? index_b (real-ord-obj-*>= ro-obj_a))
			(propagate-symbolic-> ro-obj_b ro-obj_a)))
		 )))

